/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany.kinetics.insolator;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dakotapride.mechanical_botany.ModConfigs;
import net.dakotapride.mechanical_botany.ModRecipeTypes;
import net.dakotapride.mechanical_botany.kinetics.insolator.InsolatingProcessingRecipeParams;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class InsolatingRecipe
extends ProcessingRecipe<RecipeWrapper, InsolatingProcessingRecipeParams> {
    public InsolatingRecipe(InsolatingProcessingRecipeParams params) {
        super(ModRecipeTypes.INSOLATING, (ProcessingRecipeParams)params);
    }

    public SizedFluidIngredient getRequiredFluid() {
        return (SizedFluidIngredient)this.fluidIngredients.getFirst();
    }

    public boolean consumeItem() {
        return ((InsolatingProcessingRecipeParams)this.params).consumeInput();
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public int getProcessingDuration() {
        return super.getProcessingDuration() * (Integer)ModConfigs.server().insolator.processingTimeMultiplier.get();
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        if (inv.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem(0)) && ((SizedFluidIngredient)this.fluidIngredients.get(0)).test(this.getRequiredFluid().getFluids()[0]);
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    public static class Serializer<R extends InsolatingRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;

        public Serializer(ProcessingRecipe.Factory<InsolatingProcessingRecipeParams, R> factory) {
            this.codec = ProcessingRecipe.codec(factory, InsolatingProcessingRecipeParams.CODEC);
            this.streamCodec = ProcessingRecipe.streamCodec(factory, InsolatingProcessingRecipeParams.STREAM_CODEC);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }
    }
}

