/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany;

import java.util.Optional;
import java.util.function.Supplier;
import net.dakotapride.mechanical_botany.kinetics.composter.CompostingRecipe;
import net.dakotapride.mechanical_botany.kinetics.insolator.InsolatingRecipe;
import net.dakotapride.mechanical_botany.recipe.MechancialBotanyRecipeTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRecipeTypes {
    public static final MechancialBotanyRecipeTypeInfo<InsolatingRecipe> INSOLATING = ModRecipeTypes.register("insolating", () -> new InsolatingRecipe.Serializer(InsolatingRecipe::new));
    public static final MechancialBotanyRecipeTypeInfo<CompostingRecipe> COMPOSTING = ModRecipeTypes.register("composting", CompostingRecipe.Serializer::new);

    public static void register(IEventBus modEventBus) {
        ShapedRecipePattern.setCraftingSize((int)9, (int)9);
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    }

    public static <I extends RecipeInput, R extends Recipe<I>> Optional<RecipeHolder<R>> find(I inv, Level world, MechancialBotanyRecipeTypeInfo<R> recipe) {
        return world.getRecipeManager().getRecipeFor(recipe.getType(), inv, world);
    }

    private static <R extends Recipe<?>> MechancialBotanyRecipeTypeInfo<R> register(String name, Supplier<? extends RecipeSerializer<R>> serializerSupplier) {
        return new MechancialBotanyRecipeTypeInfo(name, serializerSupplier, Registers.SERIALIZER_REGISTER, Registers.TYPE_REGISTER);
    }

    private static class Registers {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"mechanical_botany");
        private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"mechanical_botany");

        private Registers() {
        }
    }
}

