/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.foundation.ponder.instruction;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlockEntity;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import java.util.ArrayList;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ConveyChainRotationsInstruction
extends PonderInstruction {
    private final BlockPos chainStartLocation;
    private final float rpm;

    public ConveyChainRotationsInstruction(BlockPos chainStartLocation, float rpm) {
        this.chainStartLocation = chainStartLocation;
        this.rpm = rpm;
    }

    public boolean isComplete() {
        return true;
    }

    public void tick(PonderScene scene) {
        BlockEntity chainStartBlockEntity = scene.getWorld().getBlockEntity(this.chainStartLocation);
        if (chainStartBlockEntity instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity cogwheelChainBlockEntity = (CogwheelChainBlockEntity)chainStartBlockEntity;
            if (cogwheelChainBlockEntity.isController()) {
                this.conveyRotationsFromController(cogwheelChainBlockEntity, this.rpm);
            } else {
                Vec3i offset = cogwheelChainBlockEntity.getControllerOffset();
                if (offset == null) {
                    CreateBitsnBobs.LOGGER.warn("Could not convey rotations for ponder chain block entity at {} as it had no controller offset set", (Object)this.chainStartLocation);
                    return;
                }
                BlockPos controllerPos = this.chainStartLocation.offset(offset);
                BlockEntity controllerBlockEntity = scene.getWorld().getBlockEntity(controllerPos);
                if (controllerBlockEntity instanceof CogwheelChainBlockEntity) {
                    CogwheelChainBlockEntity controllerCogwheelChainBlockEntity = (CogwheelChainBlockEntity)controllerBlockEntity;
                    this.conveyRotationsFromController(controllerCogwheelChainBlockEntity, this.rpm);
                }
            }
        }
    }

    private void conveyRotationsFromController(CogwheelChainBlockEntity controllerChainBlockEntity, float rpm) {
        BlockPos chainControllerPos = controllerChainBlockEntity.getBlockPos();
        float initialChainRotationFactor = controllerChainBlockEntity.getChainRotationFactor();
        CogwheelChain chain = controllerChainBlockEntity.getChain();
        if (chain == null) {
            CreateBitsnBobs.LOGGER.warn("Ponder block entities chain was null despite it being a controller, ignoring instruction");
            return;
        }
        Level level = controllerChainBlockEntity.getLevel();
        for (PathedCogwheelNode chainNode : new ArrayList<PathedCogwheelNode>(chain.getChainPathCogwheelNodes())) {
            BlockEntity blockEntity;
            BlockPos nodePos = chainControllerPos.offset((Vec3i)chainNode.localPos());
            if (chainNode.localPos() == Vec3i.ZERO || !((blockEntity = controllerChainBlockEntity.getLevel().getBlockEntity(nodePos)) instanceof CogwheelChainBlockEntity)) continue;
            CogwheelChainBlockEntity childCogwheelChainBlockEntity = (CogwheelChainBlockEntity)blockEntity;
            this.modifyBlockEntityKineticRotation(level, childCogwheelChainBlockEntity, initialChainRotationFactor, childCogwheelChainBlockEntity.getChainRotationFactor(), rpm);
        }
        this.modifyBlockEntityKineticRotation(level, controllerChainBlockEntity, -1.0f, initialChainRotationFactor, rpm);
    }

    private void modifyBlockEntityKineticRotation(Level level, CogwheelChainBlockEntity childCogwheelChainBlockEntity, float initialFactor, float factor, float rpm) {
        CompoundTag tag = childCogwheelChainBlockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
        tag.putFloat("Speed", rpm * initialFactor / factor);
        childCogwheelChainBlockEntity.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
    }

    public void reset(PonderScene scene) {
        super.reset(scene);
    }
}

