/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.foundation.config;

import com.google.common.collect.ImmutableMap;
import com.kipti.bnb.registry.BnbFeatureFlag;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.config.ConfigBase;
import org.jetbrains.annotations.NotNull;

public class BnbCommonConfig
extends ConfigBase {
    public final ConfigBase.ConfigGroup FEATURE_FLAGS_GROUP = this.group(1, "featureFlags", new String[]{"Feature flags to enable or disable certain features of the mod."});
    public final Map<BnbFeatureFlag, ConfigBase.ConfigBool> FEATURE_FLAGS = this.createFeatureFlagConfigs();

    private Map<BnbFeatureFlag, ConfigBase.ConfigBool> createFeatureFlagConfigs() {
        HashMap<BnbFeatureFlag, ConfigBase.ConfigBool> map = new HashMap<BnbFeatureFlag, ConfigBase.ConfigBool>();
        for (BnbFeatureFlag featureFlag : BnbFeatureFlag.values()) {
            ConfigBase.ConfigBool configBool = this.b(featureFlag.getDefaultState(), this.enumToCamelCase(featureFlag.name().toLowerCase()), new String[]{featureFlag.getDescription()});
            map.put(featureFlag, configBool);
        }
        return ImmutableMap.copyOf(map);
    }

    private String enumToCamelCase(String lowerCase) {
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : lowerCase.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public boolean getFeatureFlagState(BnbFeatureFlag featureFlagKey) {
        if (!this.specification.isLoaded()) {
            System.out.println("Config not loaded yet but feature flag was asked for anyways!");
            return false;
        }
        ConfigBase.ConfigBool configBool = this.FEATURE_FLAGS.get((Object)featureFlagKey);
        return configBool != null && (Boolean)configBool.get() != false;
    }

    @NotNull
    public String getName() {
        return "common";
    }
}

