/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DoubleOrientedDirections {
    public static Direction getFront(Direction up, Direction front) {
        if (up.getAxis() == front.getAxis()) {
            return front;
        }
        return up.getAxis() == Direction.Axis.Y ? Direction.EAST : (up.getAxis() != Direction.Axis.Z ? Direction.NORTH : Direction.EAST);
    }

    public static Direction getLeft(BlockState state) {
        Direction up = (Direction)state.getValue((Property)GenericNixieDisplayBlock.FACING);
        Direction front = (Direction)state.getValue((Property)GenericNixieDisplayBlock.ORIENTATION);
        return DoubleOrientedDirections.getLeft(up, front);
    }

    static Direction getDirectionByNormal(Vec3i cross) {
        for (Direction direction : Direction.values()) {
            if (!direction.getNormal().equals((Object)cross)) continue;
            return direction;
        }
        return Direction.NORTH;
    }

    public static Direction getLeft(Direction up, Direction front) {
        return DoubleOrientedDirections.getDirectionByNormal(up.getNormal().cross(front.getNormal())).getOpposite();
    }
}

