/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut.mesh;

import com.kipti.bnb.content.girder_strut.cap.GirderCapAccumulator;
import com.kipti.bnb.content.girder_strut.geometry.GirderGeometry;
import com.kipti.bnb.content.girder_strut.geometry.GirderVertex;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class GirderMeshQuad {
    private final GirderVertex[] vertices;
    private final TextureAtlasSprite sprite;
    private final Direction nominalFace;
    private final int tintIndex;
    private final boolean shade;

    private GirderMeshQuad(GirderVertex[] vertices, TextureAtlasSprite sprite, Direction nominalFace, int tintIndex, boolean shade) {
        this.vertices = vertices;
        this.sprite = sprite;
        this.nominalFace = nominalFace;
        this.tintIndex = tintIndex;
        this.shade = shade;
    }

    public static GirderMeshQuad from(BakedQuad quad) {
        int[] data = quad.getVertices();
        int stride = BakedQuadHelper.VERTEX_STRIDE;
        GirderVertex[] vertices = new GirderVertex[4];
        for (int i = 0; i < 4; ++i) {
            Vector3f pos = GirderMeshQuad.toVector3f(BakedQuadHelper.getXYZ((int[])data, (int)i));
            Vector3f normal = GirderMeshQuad.toVector3f(BakedQuadHelper.getNormalXYZ((int[])data, (int)i));
            float u = BakedQuadHelper.getU((int[])data, (int)i);
            float v = BakedQuadHelper.getV((int[])data, (int)i);
            int baseIndex = stride * i;
            int color = data.length > baseIndex + 3 ? data[baseIndex + 3] : -1;
            int light = data.length > baseIndex + 6 ? data[baseIndex + 6] : GirderGeometry.DEFAULT_LIGHT;
            vertices[i] = new GirderVertex(pos, normal, u, v, color, light);
        }
        return new GirderMeshQuad(vertices, quad.getSprite(), quad.getDirection(), quad.getTintIndex(), quad.isShade());
    }

    public GirderMeshQuad translate(float dx, float dy, float dz) {
        GirderVertex[] translated = new GirderVertex[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            GirderVertex vertex = this.vertices[i];
            Vector3f pos = new Vector3f((Vector3fc)vertex.position()).add(dx, dy, dz);
            translated[i] = new GirderVertex(pos, new Vector3f((Vector3fc)vertex.normal()), vertex.u(), vertex.v(), vertex.color(), vertex.light());
        }
        return new GirderMeshQuad(translated, this.sprite, this.nominalFace, this.tintIndex, this.shade);
    }

    public GirderMeshQuad clipZ(float maxZ) {
        float minZ = Float.POSITIVE_INFINITY;
        float maxOriginalZ = Float.NEGATIVE_INFINITY;
        for (GirderVertex vertex : this.vertices) {
            float z = vertex.position().z;
            minZ = Math.min(minZ, z);
            maxOriginalZ = Math.max(maxOriginalZ, z);
        }
        if (maxZ >= maxOriginalZ - 1.0E-4f) {
            return this;
        }
        if (maxZ <= minZ + 1.0E-4f) {
            float translation = maxZ - maxOriginalZ;
            GirderVertex[] shifted = new GirderVertex[this.vertices.length];
            for (int i = 0; i < this.vertices.length; ++i) {
                GirderVertex vertex;
                vertex = this.vertices[i];
                Vector3f pos = new Vector3f((Vector3fc)vertex.position()).add(0.0f, 0.0f, translation);
                shifted[i] = new GirderVertex(pos, new Vector3f((Vector3fc)vertex.normal()), vertex.u(), vertex.v(), vertex.color(), vertex.light());
            }
            return new GirderMeshQuad(shifted, this.sprite, this.nominalFace, this.tintIndex, this.shade);
        }
        ArrayList<GirderVertex> clipped = new ArrayList<GirderVertex>();
        for (int i = 0; i < this.vertices.length; ++i) {
            boolean nextInside;
            GirderVertex current = this.vertices[i];
            GirderVertex next = this.vertices[(i + 1) % this.vertices.length];
            boolean currentInside = current.position().z <= maxZ + 1.0E-4f;
            boolean bl = nextInside = next.position().z <= maxZ + 1.0E-4f;
            if (currentInside && nextInside) {
                clipped.add(next);
                continue;
            }
            if (currentInside && !nextInside) {
                clipped.add(GirderGeometry.interpolate(current, next, this.clampT(current, next, maxZ)));
                continue;
            }
            if (currentInside || !nextInside) continue;
            clipped.add(GirderGeometry.interpolate(current, next, this.clampT(current, next, maxZ)));
            clipped.add(next);
        }
        if (clipped.size() < 3) {
            return null;
        }
        return new GirderMeshQuad(clipped.toArray(new GirderVertex[0]), this.sprite, this.nominalFace, this.tintIndex, this.shade);
    }

    private float clampT(GirderVertex current, GirderVertex next, float maxZ) {
        float delta = next.position().z - current.position().z;
        if (Math.abs(delta) < 1.0E-4f) {
            return 0.0f;
        }
        return (maxZ - current.position().z) / delta;
    }

    public void transformAndEmit(Matrix4f pose, Matrix3f normalMatrix, Vector3f planePoint, Vector3f planeNormal, GirderCapAccumulator capAccumulator, List<BakedQuad> consumer) {
        ArrayList<GirderVertex> transformed = new ArrayList<GirderVertex>(this.vertices.length);
        for (GirderVertex vertex : this.vertices) {
            Vector3f position = new Vector3f((Vector3fc)vertex.position());
            pose.transformPosition(position);
            Vector3f normal = new Vector3f((Vector3fc)vertex.normal());
            normalMatrix.transform(normal);
            if (normal.lengthSquared() > 1.0E-4f) {
                normal.normalize();
            }
            transformed.add(new GirderVertex(position, normal, vertex.u(), vertex.v(), vertex.color(), vertex.light()));
        }
        ClipResult clipResult = this.clipAgainstPlane(transformed, planePoint, planeNormal);
        List<GirderVertex> clipped = clipResult.polygon();
        if (clipped.size() >= 3) {
            GirderGeometry.emitPolygon(clipped, this.sprite, this.nominalFace, this.tintIndex, this.shade, consumer);
        }
        if (clipResult.clipped() && planeNormal.lengthSquared() > 1.0E-4f) {
            capAccumulator.addSegments(this.sprite, this.tintIndex, this.shade, clipResult.segments());
        }
    }

    private ClipResult clipAgainstPlane(List<GirderVertex> input, Vector3f planePoint, Vector3f planeNormal) {
        boolean previousInside;
        if (planeNormal.lengthSquared() <= 1.0E-4f) {
            return new ClipResult(input, List.of(), false);
        }
        ArrayList<GirderVertex> result = new ArrayList<GirderVertex>();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        boolean clipped = false;
        boolean hasInsideVertex = false;
        int size = input.size();
        GirderVertex previousVertex = input.get(size - 1);
        float previousDistance = GirderGeometry.signedDistance(previousVertex.position(), planeNormal, planePoint);
        boolean bl = previousInside = previousDistance >= -1.0E-4f;
        if (previousInside) {
            hasInsideVertex = true;
        }
        GirderVertex pendingSegmentStart = null;
        for (GirderVertex currentVertex : input) {
            boolean currentInside;
            float currentDistance = GirderGeometry.signedDistance(currentVertex.position(), planeNormal, planePoint);
            boolean bl2 = currentInside = currentDistance >= -1.0E-4f;
            if (currentInside) {
                hasInsideVertex = true;
            }
            ArrayList<GirderVertex> edgePoints = new ArrayList<GirderVertex>();
            if (Math.abs(previousDistance) <= 1.0E-4f) {
                edgePoints.add(previousVertex);
            }
            if (currentInside != previousInside) {
                float t = previousDistance / (previousDistance - currentDistance);
                GirderVertex intersection = GirderGeometry.interpolate(previousVertex, currentVertex, t);
                result.add(intersection);
                edgePoints.add(intersection);
                clipped = true;
            }
            if (currentInside) {
                result.add(currentVertex);
            }
            if (Math.abs(currentDistance) <= 1.0E-4f) {
                edgePoints.add(currentVertex);
            }
            if (!currentInside) {
                clipped = true;
            }
            for (GirderVertex edgePoint : edgePoints) {
                if (pendingSegmentStart == null) {
                    pendingSegmentStart = edgePoint;
                    continue;
                }
                if (GirderGeometry.positionsEqual(pendingSegmentStart.position(), edgePoint.position())) continue;
                segments.add(new Segment(pendingSegmentStart, edgePoint));
                pendingSegmentStart = null;
            }
            previousVertex = currentVertex;
            previousDistance = currentDistance;
            previousInside = currentInside;
        }
        return new ClipResult(result, segments, clipped);
    }

    private static Vector3f toVector3f(Vec3 vec) {
        return new Vector3f((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public void transformAndEmitToConsumer(Matrix4f pose, Matrix3f normalMatrix, Vector3f planePoint, Vector3f planeNormal, GirderCapAccumulator capAccumulator, List<Consumer<BufferBuilder>> bufferConsumer, Function<Vector3f, Integer> lightFunction) {
        ArrayList<GirderVertex> transformed = new ArrayList<GirderVertex>(this.vertices.length);
        for (GirderVertex vertex : this.vertices) {
            Vector3f position = new Vector3f((Vector3fc)vertex.position());
            pose.transformPosition(position);
            Vector3f normal = new Vector3f((Vector3fc)vertex.normal());
            normalMatrix.transform(normal);
            if (normal.lengthSquared() > 1.0E-4f) {
                normal.normalize();
            }
            transformed.add(new GirderVertex(position, normal, vertex.u(), vertex.v(), vertex.color(), vertex.light()));
        }
        ClipResult clipResult = this.clipAgainstPlane(transformed, planePoint, planeNormal);
        List<GirderVertex> clipped = clipResult.polygon();
        if (clipped.size() >= 3) {
            GirderGeometry.emitPolygonToConsumer(clipped, bufferConsumer, lightFunction);
        }
        if (clipResult.clipped() && planeNormal.lengthSquared() > 1.0E-4f) {
            capAccumulator.addSegments(this.sprite, this.tintIndex, this.shade, clipResult.segments());
        }
    }

    private record ClipResult(List<GirderVertex> polygon, List<Segment> segments, boolean clipped) {
    }

    public record Segment(GirderVertex start, GirderVertex end) {
    }
}

