/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.flywheel_bearing;

import com.kipti.bnb.content.flywheel_bearing.FlywheelBearingBlock;
import com.kipti.bnb.content.flywheel_bearing.contraption.InertControlledContraptionEntity;
import com.kipti.bnb.content.flywheel_bearing.mechanics.FlywheelMovementMechanics;
import com.kipti.bnb.mixin_accessor.FlywheelAccessibleKineticNetwork;
import com.kipti.bnb.registry.BnbConfigs;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IControlContraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FlywheelBearingBlockEntity
extends GeneratingKineticBlockEntity
implements IControlContraption,
IDisplayAssemblyExceptions {
    protected AssemblyException lastException;
    protected InertControlledContraptionEntity movedContraption;
    protected boolean checkAssemblyNextTick;
    protected float clientAngleDiff;
    protected boolean running;
    protected float clientFlywheelAbsorptionCapacityInNetwork;
    protected float clientFlywheelReleaseCapacityInNetwork;
    protected int lastGeneratorDirection = 1;
    protected FlywheelMovementMechanics flywheelMovement = new FlywheelMovementMechanics();

    public FlywheelBearingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.lazyTickRate = 5;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.running) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        Lang.builder((String)"bits_n_bobs").add(Component.translatable((String)"tooltip.bits_n_bobs.flywheel_bearing.flywheel_stats")).forGoggles(tooltip);
        Lang.builder((String)"bits_n_bobs").add(Component.translatable((String)"tooltip.bits_n_bobs.flywheel_bearing.angular_mass")).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.builder((String)"bits_n_bobs").add(Component.literal((String)(this.flywheelMovement.formatAngularMass() + " "))).style(ChatFormatting.AQUA).add(this.flywheelMovement.getAngularMassDescription().copy().withStyle(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        if (((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            Lang.builder((String)"bits_n_bobs").add(Component.translatable((String)"tooltip.bits_n_bobs.flywheel_bearing.stored_stress")).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float currentStoredStress = this.flywheelMovement.currentStoredStressTicks;
            float lastStoredStress = this.flywheelMovement.lastStoredStressTicks;
            float maxStoredStress = this.flywheelMovement.getMaxStoredStressTicks();
            int direction = Float.compare(currentStoredStress, lastStoredStress);
            int changeStrength = Mth.clamp((int)Math.round(1500.0f * Math.abs(currentStoredStress - lastStoredStress) / maxStoredStress), (int)1, (int)5);
            int maxBars = 100;
            int filledBars = Mth.clamp((int)Math.round(currentStoredStress / maxStoredStress * 100.0f), (int)0, (int)100);
            Lang.builder((String)"bits_n_bobs").add(Component.literal((String)"|".repeat(filledBars))).style(ChatFormatting.AQUA).add(Component.literal((String)"|".repeat(100 - filledBars)).withStyle(ChatFormatting.DARK_GRAY)).add(Component.literal((String)(direction == 0 ? "" : (direction > 0 ? " " + ">".repeat(changeStrength) : " " + "<".repeat(changeStrength)))).withStyle(direction == 0 ? ChatFormatting.DARK_GRAY : ChatFormatting.AQUA)).forGoggles(tooltip, 1);
            Lang.builder((String)"bits_n_bobs").add(Component.literal((String)String.format("%.1fsut", Float.valueOf(currentStoredStress)))).style(ChatFormatting.AQUA).add(Component.literal((String)String.format("/%.1fsut ", Float.valueOf(maxStoredStress))).withStyle(ChatFormatting.GRAY)).add((!this.flywheelMovement.canProvideStress() ? Component.translatable((String)"tooltip.bits_n_bobs.flywheel_bearing.empty") : (this.flywheelMovement.canReceiveStress() ? Component.empty() : Component.translatable((String)"tooltip.bits_n_bobs.flywheel_bearing.full"))).withStyle(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            Lang.builder((String)"bits_n_bobs").add(Component.translatable((String)"tooltip.bits_n_bobs.flywheel_bearing.kinetic_transfer")).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.builder((String)"bits_n_bobs").add(Component.literal((String)String.format("%.1fsu", Float.valueOf(this.flywheelMovement.kineticTransfer)))).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.addGenerationAsZeroIfNeeded(tooltip);
        return true;
    }

    private void addGenerationAsZeroIfNeeded(List<Component> tooltip) {
        if (!IRotate.StressImpact.isEnabled()) {
            return;
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (!Mth.equal((float)stressBase, (float)0.0f)) {
            return;
        }
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number((double)0.0).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void remove() {
        if (!this.level.isClientSide) {
            this.disassemble();
        }
        super.remove();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Running", this.running);
        compound.putFloat("NetworkFlywheelAbsorptionCapacity", this.hasNetwork() ? this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressAbsoptionCapacity() : 0.0f);
        compound.putFloat("NetworkFlywheelReleaseCapacity", this.hasNetwork() ? this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressReleaseCapacity() : 0.0f);
        compound.putInt("LastGeneratorDirection", this.lastGeneratorDirection);
        this.flywheelMovement.writeAdditional(compound);
        AssemblyException.write((CompoundTag)compound, (HolderLookup.Provider)registries, (AssemblyException)this.lastException);
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.wasMoved) {
            super.read(compound, registries, clientPacket);
            return;
        }
        if (clientPacket) {
            this.clientFlywheelAbsorptionCapacityInNetwork = compound.getFloat("NetworkFlywheelAbsorptionCapacity");
            this.clientFlywheelReleaseCapacityInNetwork = compound.getFloat("NetworkFlywheelReleaseCapacity");
        }
        float angleBefore = this.flywheelMovement.angle;
        this.running = compound.getBoolean("Running");
        this.lastGeneratorDirection = compound.getInt("LastGeneratorDirection");
        this.flywheelMovement.readAdditional(compound, clientPacket);
        this.lastException = AssemblyException.read((CompoundTag)compound, (HolderLookup.Provider)registries);
        super.read(compound, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (!this.running) {
            this.flywheelMovement.clientAngle = null;
            this.movedContraption = null;
        }
    }

    public float getInterpolatedAngle(float partialTicks) {
        if (this.isVirtual()) {
            return Mth.lerp((float)(partialTicks + 0.5f), (float)this.flywheelMovement.prevClientAngle, (float)(this.flywheelMovement.clientAngle == null ? this.flywheelMovement.angle : this.flywheelMovement.clientAngle.floatValue()));
        }
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        return Mth.lerp((float)partialTicks, (float)this.flywheelMovement.prevClientAngle, (float)(this.flywheelMovement.clientAngle == null ? this.flywheelMovement.angle : this.flywheelMovement.clientAngle.floatValue()));
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.checkAssemblyNextTick = true;
        if (this.movedContraption != null && Math.signum(prevSpeed) != Math.signum(this.getSpeed()) && prevSpeed != 0.0f) {
            if (!this.movedContraption.isStalled()) {
                this.flywheelMovement.angle = Math.round(this.flywheelMovement.angle);
                this.applyRotation();
            }
            this.movedContraption.getContraption().stop(this.level);
        }
    }

    public float getAngularSpeed() {
        float speed = FlywheelBearingBlockEntity.convertToAngular((float)this.flywheelMovement.angularVelocity);
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.level.isClientSide) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    public void assemble() {
        if (!(this.level.getBlockState(this.worldPosition).getBlock() instanceof FlywheelBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.getBlockState().getValue((Property)FlywheelBearingBlock.FACING);
        BearingContraption contraption = new BearingContraption(false, direction);
        try {
            if (!contraption.assemble(this.level, this.worldPosition)) {
                return;
            }
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        contraption.removeBlocksFromWorld(this.level, BlockPos.ZERO);
        this.movedContraption = InertControlledContraptionEntity.create(this.level, this, (Contraption)contraption);
        BlockPos anchor = this.worldPosition.relative(direction);
        this.movedContraption.setPos(anchor.getX(), anchor.getY(), anchor.getZ());
        this.movedContraption.setRotationAxis(direction.getAxis());
        this.level.addFreshEntity((Entity)this.movedContraption);
        this.flywheelMovement.assemble(this, contraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
        this.running = true;
        this.flywheelMovement.zero();
        this.sendData();
        this.updateGeneratedRotation();
        this.updateFlywheelStressesInNetwork();
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.flywheelMovement.zero();
        if (this.movedContraption != null) {
            this.movedContraption.setAngle(0.0f);
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.level, (Vec3i)this.worldPosition);
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.updateFlywheelStressesInNetwork();
        this.checkAssemblyNextTick = false;
        this.sendData();
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (!ICogWheel.isLargeCog((BlockState)state)) {
            return super.addPropagationLocations(block, state, neighbours);
        }
        BlockPos.betweenClosedStream((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).forEach(offset -> {
            if (offset.distSqr((Vec3i)BlockPos.ZERO) == 2.0) {
                neighbours.add(this.worldPosition.offset((Vec3i)offset));
            }
        });
        return neighbours;
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.level.isClientSide && this.checkAssemblyNextTick) {
            this.checkAssemblyNextTick = false;
            if (this.running) {
                if (this.speed == 0.0f && (this.movedContraption == null || this.movedContraption.getContraption().getBlocks().isEmpty())) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.level);
                    }
                    this.disassemble();
                    return;
                }
            } else {
                this.assemble();
            }
        }
        if (!this.running) {
            this.flywheelMovement.zero();
            return;
        }
        if (((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            this.flywheelMovement.tickForStorageBehaviour(this);
        } else {
            this.flywheelMovement.tick(this);
        }
        this.applyRotation();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && this.running && !this.level.isClientSide) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.level.isClientSide ? this.flywheelMovement.clientAngle.floatValue() : this.flywheelMovement.angle);
        BlockState blockState = this.getBlockState();
        if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            this.movedContraption.setRotationAxis(((Direction)blockState.getValue((Property)BlockStateProperties.FACING)).getAxis());
        }
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (this.running) {
            return false;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof BearingBlock)) {
            return false;
        }
        BlockState attachedState = this.level.getBlockState(this.worldPosition.relative((Direction)state.getValue((Property)BearingBlock.FACING)));
        if (attachedState.canBeReplaced()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, (String)"hint.empty_bearing", (Object[])new Object[0]);
        return true;
    }

    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public void attach(ControlledContraptionEntity contraption) {
        BlockState blockState = this.getBlockState();
        if (!(contraption.getContraption() instanceof BearingContraption)) {
            return;
        }
        if (!(contraption instanceof InertControlledContraptionEntity)) {
            return;
        }
        InertControlledContraptionEntity inertControlledContraptionEntity = (InertControlledContraptionEntity)contraption;
        if (!blockState.hasProperty((Property)BearingBlock.FACING)) {
            return;
        }
        this.movedContraption = inertControlledContraptionEntity;
        this.setChanged();
        BlockPos anchor = this.worldPosition.relative((Direction)blockState.getValue((Property)BearingBlock.FACING));
        this.movedContraption.setPos(anchor.getX(), anchor.getY(), anchor.getZ());
        this.running = true;
        if (!this.level.isClientSide) {
            this.sendData();
        }
    }

    public void onStall() {
        if (!this.level.isClientSide) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.isRemoved();
    }

    public BlockPos getBlockPosition() {
        return this.worldPosition;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public float getFlywheelStressDelta() {
        float flywheelAbsorptionCapacityInNetwork;
        if (!this.hasNetwork() || !((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            return 0.0f;
        }
        float f = this.level == null ? 0.0f : (flywheelAbsorptionCapacityInNetwork = this.level.isClientSide ? this.clientFlywheelAbsorptionCapacityInNetwork : this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressAbsoptionCapacity());
        float flywheelReleaseCapacityInNetwork = this.level == null ? 0.0f : (this.level.isClientSide ? this.clientFlywheelReleaseCapacityInNetwork : this.getOrCreateFlywheelNetwork().bits_n_bobs$getFlywheelStressReleaseCapacity());
        float stressDifferenceInNetwork = this.capacity - flywheelReleaseCapacityInNetwork - this.stress;
        float flywheelAbsorptionStressCapacity = this.getFlywheelStressAbsorptionCapacity();
        float flywheelReleaseStressCapacity = this.getFlywheelStressReleaseCapacity();
        if (stressDifferenceInNetwork > 0.0f) {
            if (flywheelAbsorptionCapacityInNetwork == 0.0f) {
                return 0.0f;
            }
            return flywheelAbsorptionStressCapacity / flywheelAbsorptionCapacityInNetwork * stressDifferenceInNetwork;
        }
        if (flywheelReleaseCapacityInNetwork == 0.0f) {
            return 0.0f;
        }
        return flywheelReleaseStressCapacity / flywheelReleaseCapacityInNetwork * stressDifferenceInNetwork;
    }

    protected FlywheelAccessibleKineticNetwork getOrCreateFlywheelNetwork() {
        return (FlywheelAccessibleKineticNetwork)this.getOrCreateNetwork();
    }

    public float getFlywheelStressAbsorptionCapacity() {
        return this.running ? this.flywheelMovement.getFlywheelStressCapacity() : 0.0f;
    }

    public void updateFlywheelStressesInNetwork() {
        if (!((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue() || !this.hasNetwork()) {
            return;
        }
        this.getOrCreateFlywheelNetwork().bits_n_bobs$updateFlywheelStresses();
    }

    public float getGeneratedSpeed() {
        if (!((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            return 0.0f;
        }
        float currentSpeed = this.getTheoreticalSpeed();
        if (currentSpeed != 0.0f) {
            int direction;
            int n = direction = currentSpeed > 0.0f ? 1 : -1;
            if (direction != this.lastGeneratorDirection) {
                this.lastGeneratorDirection = direction;
                this.sendData();
            }
        }
        return this.flywheelMovement.canProvideStress() ? (float)(this.lastGeneratorDirection * 8) : 0.0f;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        if (!((Boolean)BnbConfigs.server().FLYWHEEL_STORAGE_CAPACITY.get()).booleanValue()) {
            return 0.0f;
        }
        this.lastCapacityProvided = capacity = this.getFlywheelStressReleaseCapacity();
        float currentSpeed = this.getGeneratedSpeed();
        return currentSpeed == 0.0f ? capacity : capacity / Math.abs(currentSpeed);
    }

    public float getFlywheelStressReleaseCapacity() {
        return this.flywheelMovement.canProvideStress() ? this.flywheelMovement.getMaxTransferCapacity() : 0.0f;
    }

    public void updateFlywheelStressesFromNetwork() {
        this.sendData();
    }
}

