/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CogwheelChainTangents {
    public static Vec3 getTangentOnCog(PlacingCogwheelNode previousNode, int previousSide, PlacingCogwheelNode currentNode, int currentSide) {
        double previousRadius = previousNode.isLarge() ? 1.0 : 0.5;
        double currentRadius = currentNode.isLarge() ? 1.0 : 0.5;
        Vec3 incoming = currentNode.center().subtract(previousNode.center());
        if (previousNode.rotationAxis() != currentNode.rotationAxis()) {
            int incomingSign;
            Vec3 projectedIncoming = incoming.subtract(CogwheelChainTangents.getDirectionOfAxis(currentNode).scale(incoming.dot(CogwheelChainTangents.getDirectionOfAxis(currentNode)))).subtract(CogwheelChainTangents.getDirectionOfAxis(previousNode).scale(incoming.dot(CogwheelChainTangents.getDirectionOfAxis(previousNode)))).normalize();
            if (projectedIncoming.lengthSqr() < 1.0E-7) {
                return null;
            }
            int n = incomingSign = projectedIncoming.cross(CogwheelChainTangents.getDirectionOfAxis(previousNode)).dot(CogwheelChainTangents.getDirectionOfAxis(currentNode)) > 0.0 ? 1 : -1;
            if (incomingSign != previousSide || incomingSign != currentSide) {
                return null;
            }
            return CogwheelChainTangents.getDirectionOfAxis(previousNode).scale((double)previousNode.pos().subtract((Vec3i)currentNode.pos()).get(previousNode.rotationAxis()));
        }
        if (previousSide == currentSide) {
            return incoming.normalize().cross(CogwheelChainTangents.getDirectionOfAxis(currentNode)).scale(-currentRadius * (double)currentSide);
        }
        double factor = previousRadius / (previousRadius + currentRadius);
        Vec3 tangentOrigin = incoming.scale(factor);
        double distance = tangentOrigin.length();
        double sineRatio = currentRadius / distance;
        double cosRatio = Math.sqrt(1.0 - sineRatio * sineRatio);
        double perpendicularHeight = cosRatio * currentRadius;
        double lengthAlongIncoming = sineRatio * currentRadius;
        return incoming.normalize().cross(CogwheelChainTangents.getDirectionOfAxis(currentNode)).scale(-perpendicularHeight * (double)currentSide).add(incoming.normalize().scale(-lengthAlongIncoming));
    }

    @NotNull
    private static Vec3 getDirectionOfAxis(PlacingCogwheelNode currentNode) {
        return Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)currentNode.rotationAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).getNormal());
    }
}

