/*
 * Decompiled with CFR 0.152.
 */
package elocindev.necronomicon.api.text;

import elocindev.necronomicon.util.ColorUtils;
import java.awt.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class TextAPI {
    public static void setStaticGradient(MutableComponent text, int color1, int color2) {
        text.setStyle(Styles.getStaticGradient((Component)text, color1, color2).getStyle());
    }

    public static void setSlideGradient(MutableComponent text, int offset, int color1, int color2, float tickrate) {
        text.setStyle(Styles.getGradient((Component)text, offset, color1, color2, tickrate).getStyle());
    }

    public static void setBreathingGradient(MutableComponent text, int offset, int color1, int color2, float tickrate) {
        text.setStyle(Styles.getBreathingGradient((Component)text, offset, color1, color2, tickrate).getStyle());
    }

    public static void setRainbowGradient(MutableComponent text, int offset, float tickrate) {
        text.setStyle(Styles.getRainbowGradient((Component)text, offset, tickrate).getStyle());
    }

    private static MutableComponent getEmptyText() {
        return Component.empty();
    }

    public class Styles {
        public Styles(TextAPI this$0) {
        }

        public static MutableComponent getStaticGradient(Component text, int color1, int color2) {
            MutableComponent gradientColor = TextAPI.getEmptyText();
            String string = text.getString();
            for (int i = 0; i < string.length(); ++i) {
                int color = ColorUtils.interpolate(color1, color2, (double)i / (double)string.length());
                Style style = Style.EMPTY.withColor(color);
                gradientColor.append((Component)Component.literal((String)String.valueOf(string.charAt(i))).setStyle(style));
            }
            return gradientColor;
        }

        public static MutableComponent getGradient(Component text, int offset, int color1, int color2, float tickrate) {
            long time = System.currentTimeMillis() / ((long)tickrate * 50L);
            MutableComponent gradientColor = TextAPI.getEmptyText();
            String string = text.getString();
            for (int i = 0; i < string.length(); ++i) {
                double hue = (double)(time - (long)i - (long)offset) % 45.0;
                Style style = Style.EMPTY.withColor(ColorUtils.gradientSlide((float)hue / 22.5f, new Color(color1), new Color(color2)).getRGB());
                gradientColor.append((Component)Component.literal((String)String.valueOf(string.charAt(i))).setStyle(style));
            }
            return gradientColor;
        }

        public static MutableComponent getBreathingGradient(Component text, int offset, int color1, int color2, float tickrate) {
            long time = System.currentTimeMillis() / ((long)tickrate * 50L);
            MutableComponent gradientColor = TextAPI.getEmptyText();
            String string = text.getString();
            for (int i = 0; i < string.length(); ++i) {
                double animationFactor = (Math.sin((double)(time - (long)i - (long)offset) * 0.05) + 1.0) / 2.0;
                int color = ColorUtils.interpolateAnimation(color1, color2, (double)i / (double)string.length(), animationFactor);
                Style style = Style.EMPTY.withColor(color);
                gradientColor.append((Component)Component.literal((String)String.valueOf(string.charAt(i))).setStyle(style));
            }
            return gradientColor;
        }

        public static MutableComponent getRainbowGradient(Component text, int offset, float tickrate) {
            long time = System.currentTimeMillis() / ((long)tickrate * 50L);
            String string = text.getString();
            MutableComponent rainbowColor = TextAPI.getEmptyText();
            for (int i = 0; i < string.length(); ++i) {
                double hue = 0.011111111111111112 * (double)(time - (long)i - (long)offset);
                Style style = Style.EMPTY.withColor(Color.HSBtoRGB((float)(hue % 360.0), 0.5f, 1.0f));
                rainbowColor.append((Component)Component.literal((String)String.valueOf(string.charAt(i))).setStyle(style));
            }
            return rainbowColor;
        }
    }
}

