/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.networking.MobLootPayload;
import fzzyhmstrs.emi_loot.server.ComplexLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.SimpleLootPoolBuilder;
import fzzyhmstrs.emi_loot.util.TextKey;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MobLootTableSender
implements LootSender<ComplexLootPoolBuilder> {
    private final String idToSend;
    private final String mobIdToSend;
    final List<ComplexLootPoolBuilder> builderList = new LinkedList<ComplexLootPoolBuilder>();
    boolean isEmpty = true;

    public MobLootTableSender(ResourceLocation id, ResourceLocation mobId) {
        this.idToSend = LootSender.getIdToSend(id);
        this.mobIdToSend = LootSender.getIdToSend(mobId);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            if (!builder.isEmpty) {
                this.isEmpty = false;
            }
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(ServerPlayer player) {
        if (!ConfigApi.INSTANCE.network().canSend(MobLootPayload.TYPE.id(), (Player)player)) {
            return;
        }
        if (this.isEmpty) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("avoiding empty mob: " + this.idToSend);
            }
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUtf(this.idToSend);
        buf.writeUtf(this.mobIdToSend);
        if (this.builderList.size() == 1 && this.builderList.get((int)0).isSimple) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("sending simple mob: " + this.idToSend);
            }
            buf.writeShort(-1);
            buf.writeResourceKey(this.builderList.get((int)0).simpleStack.getItem().builtInRegistryHolder().key());
            ConfigApi.INSTANCE.network().send((CustomPacketPayload)new MobLootPayload(buf), (Player)player);
            return;
        }
        if (this.builderList.isEmpty()) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("avoiding empty mob: " + this.idToSend);
            }
            return;
        }
        buf.writeShort(this.builderList.size());
        this.builderList.forEach(builder -> {
            ArrayList totalConditions = new ArrayList();
            builder.conditions.forEach(lootConditionResult -> totalConditions.add(lootConditionResult.text()));
            builder.functions.forEach(lootFunctionResult -> totalConditions.addAll(lootFunctionResult.conditions()));
            buf.writeShort(totalConditions.size());
            totalConditions.forEach(lootConditionResult -> lootConditionResult.toBuf(buf));
            buf.writeShort(builder.functions.size());
            builder.functions.forEach(lootFunctionResult -> lootFunctionResult.text().toBuf(buf));
            HashMap<List<TextKey>, SimpleLootPoolBuilder> lootPoolBuilderMap = builder.builtMap;
            buf.writeShort(lootPoolBuilderMap.size());
            lootPoolBuilderMap.forEach((key, chestBuilder) -> {
                buf.writeShort(key.size());
                key.forEach(textKey -> textKey.toBuf(buf));
                Object2FloatMap<ItemStack> keyPoolMap = lootPoolBuilderMap.getOrDefault((Object)key, new SimpleLootPoolBuilder((float)1.0f)).builtMap;
                buf.writeShort(keyPoolMap.size());
                keyPoolMap.forEach((stack, weight) -> {
                    this.writeItemStack(buf, (ItemStack)stack, (Level)player.serverLevel());
                    buf.writeFloat(weight.floatValue());
                });
            });
        });
        ConfigApi.INSTANCE.network().send((CustomPacketPayload)new MobLootPayload(buf), (Player)player);
    }

    @Override
    public void addBuilder(ComplexLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<ComplexLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

