/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.neoforge.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BlockRendererImpl {
    public static final Function<BlockState, ItemTransform> B2T;
    public static final ItemTransform T_CUBE;
    public static final ItemTransform T_CROSS;
    public static final Set<BlockEntity> TICKED_BE;

    public static void onClientTick(ClientTickEvent.Pre event) {
        TICKED_BE.clear();
    }

    public static void render(BlockState blockState, GuiGraphics draw, int x, int y, float delta) {
        FluidState fluidState;
        PoseStack matrices = draw.pose();
        matrices.pushPose();
        matrices.translate((float)x, (float)y, 150.0f);
        matrices.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrices.scale(16.0f, 16.0f, 16.0f);
        ClientLevel world = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        BlockPos blockPos = player != null ? player.blockPosition() : BlockPos.ZERO;
        ItemTransform t = B2T.apply(blockState);
        Objects.requireNonNullElse(t, T_CUBE).apply(false, matrices);
        BlockRenderDispatcher brm = Minecraft.getInstance().getBlockRenderer();
        MultiBufferSource.BufferSource vcp = draw.bufferSource();
        VertexConsumer consumer = vcp.getBuffer(Sheets.translucentCullBlockSheet());
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            RandomSource random = RandomSource.create();
            random.setSeed(42L);
            consumer.setLight(0xF000F0);
            brm.renderBatched(blockState, blockPos, (BlockAndTintGetter)world, matrices, consumer, false, random);
        }
        if (!(fluidState = blockState.getFluidState()).isEmpty()) {
            // empty if block
        }
        matrices.popPose();
        draw.flush();
    }

    static {
        T_CUBE = new ItemTransform(new Vector3f(30.0f, 210.0f, 0.0f), new Vector3f(0.925f, -0.8125f, 0.0f), new Vector3f(0.625f));
        T_CROSS = new ItemTransform(new Vector3f(15.0f, 195.0f, 0.0f), new Vector3f(1.0f, -0.95f, 0.0f), new Vector3f(0.8f));
        TICKED_BE = new HashSet<BlockEntity>();
        B2T = state -> {
            Block block = state.getBlock();
            return block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof WebBlock || block instanceof SeagrassBlock || block instanceof DoublePlantBlock ? T_CROSS : null;
        };
    }
}

