/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.InteractableTextWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.stack.ChestLootEmiStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ChestLootRecipe
implements EmiRecipe {
    private final ClientChestLootTable loot;
    private final Supplier<ArrayListMultimap<Float, EmiStack>> lootStacksSorted;
    private final int lootStacksSortedSize;
    private final List<EmiStack> outputs;
    private boolean isGuaranteedNonChance = false;
    private final ChestLootEmiStack inputStack;
    private final float columns = 8.0f;

    public ChestLootRecipe(ChestLootRecipeData data) {
        this.loot = data.loot;
        this.isGuaranteedNonChance = data.guaranteed;
        this.lootStacksSorted = Suppliers.memoize(() -> {
            ArrayListMultimap map2 = ArrayListMultimap.create();
            Iterator<Map.Entry<Float, ItemStack>> it = data.itr;
            while (it.hasNext()) {
                Map.Entry<Float, ItemStack> entry = it.next();
                EmiStack stack = EmiStack.of((ItemStack)entry.getValue());
                map2.put((Object)entry.getKey(), (Object)stack);
            }
            return map2;
        });
        this.lootStacksSortedSize = data.lootStacksSortedSize;
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        for (ItemStack stack : data.totalItemList) {
            list.add(EmiStack.of((ItemStack)stack));
        }
        this.outputs = list;
        this.inputStack = new ChestLootEmiStack(this.loot.id);
    }

    public EmiRecipeCategory getCategory() {
        return EMILoot.config.splitChestLootByTrial && this.loot.id.getPath().contains("trial_chamber") ? EmiClientPlugin.TRIAL_CATEGORY : EmiClientPlugin.CHEST_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"emi_loot", (String)("/" + this.getCategory().id.getPath() + "/" + this.loot.id.getNamespace() + "/" + this.loot.id.getPath()));
    }

    public List<EmiIngredient> getInputs() {
        return new ArrayList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int titleHeight = 11;
        int boxesHeight = (int)Math.ceil((float)this.lootStacksSortedSize / 8.0f) * (EMILoot.config.isCompact(EMILoot.Type.CHEST) ? 18 : 19) - 1;
        return titleHeight + boxesHeight;
    }

    public void addWidgets(WidgetHolder widgets) {
        int finalRowHeight;
        int titleSpace;
        if (widgets.getHeight() < this.getDisplayHeight()) {
            titleSpace = 9;
            finalRowHeight = (widgets.getHeight() - titleSpace) / (int)Math.ceil((double)this.lootStacksSortedSize / 8.0);
        } else {
            titleSpace = 11;
            finalRowHeight = 18;
        }
        widgets.add((Widget)new InteractableTextWidget(this.inputStack, 1, 0, 0x404040, false).recipeContext(this));
        if (EMILootAgnos.isModLoaded(this.loot.id.getNamespace())) {
            widgets.addTooltip(LText.components(this.inputStack.getName(), this.loot.id.getNamespace()), 0, 0, 144, 10);
        } else {
            widgets.addTooltipText(List.of(this.inputStack.getName()), 0, 0, 144, 10);
        }
        AtomicInteger index = new AtomicInteger(this.lootStacksSortedSize);
        for (Map.Entry entry : ((ArrayListMultimap)this.lootStacksSorted.get()).asMap().entrySet()) {
            float weight = ((Float)entry.getKey()).floatValue();
            Collection items = (Collection)entry.getValue();
            if (this.loot.items.size() <= 48 && !EMILoot.config.chestLootAlwaysStackSame) {
                for (EmiStack stack : items) {
                    int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
                    int column = (index.get() - 1) % 8;
                    index.getAndDecrement();
                    String fTrim = FloatTrimmer.trimFloatString(weight, (Integer)EMILoot.config.chanceDecimalPlaces.get());
                    SlotWidget slotWidget = new SlotWidget((EmiIngredient)stack, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
                    widgets.add((Widget)slotWidget.appendTooltip((Component)LText.translatable("emi_loot.percentage", fTrim).withStyle(ChatFormatting.GRAY)));
                }
                continue;
            }
            int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
            int column = (int)((float)(index.get() - 1) % 8.0f);
            index.getAndDecrement();
            EmiIngredient ingredient = EmiIngredient.of(items.stream().toList());
            String fTrim = FloatTrimmer.trimFloatString(Math.max(weight / 100.0f, 0.01f), Math.max((Integer)EMILoot.config.chanceDecimalPlaces.get() + 1, 2));
            SlotWidget slotWidget = new SlotWidget(ingredient, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
            widgets.add((Widget)slotWidget.appendTooltip((Component)LText.translatable("emi_loot.rolls", fTrim).withStyle(ChatFormatting.GRAY)));
        }
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isGuaranteedNonChance;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }

    public record ChestLootRecipeData(ClientChestLootTable loot, Iterator<Map.Entry<Float, ItemStack>> itr, List<ItemStack> totalItemList, boolean guaranteed, int lootStacksSortedSize) {
        public static ChestLootRecipeData of(ClientChestLootTable loot) {
            boolean isGuaranteedNonChance = false;
            if (loot.items.size() == 1 && loot.items.values().toFloatArray()[0] == 1.0f) {
                isGuaranteedNonChance = true;
            }
            ArrayList<ItemStack> totalItemList = new ArrayList<ItemStack>();
            ArrayListMultimap map2 = ArrayListMultimap.create();
            loot.items.forEach((item, weight) -> {
                map2.put(weight, item);
                totalItemList.add((ItemStack)item);
            });
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                float key = ((Float)iterator.next()).floatValue();
                map2.get((Object)Float.valueOf(key)).sort(Comparator.comparingInt(s -> BuiltInRegistries.ITEM.getId((Object)s.getItem())));
            }
            Iterator<Map.Entry<Float, ItemStack>> itr = map2.entries().iterator();
            int lootStacksSortedSize = loot.items.size() > 48 || EMILoot.config.chestLootAlwaysStackSame ? map2.keySet().size() : loot.items.size();
            return new ChestLootRecipeData(loot, itr, totalItemList, isGuaranteedNonChance, lootStacksSortedSize);
        }
    }
}

