/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.BlockEntitySubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.EntitySubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.SoundSubRegistryHelper;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;

public class RegistryHelper {
    private final Map<ResourceKey<? extends Registry<?>>, ISubRegistryHelper<?>> subHelpers = Maps.newHashMap();
    protected final String modId;

    public RegistryHelper(String modId) {
        this.modId = modId;
        this.putDefaultSubHelpers();
    }

    public static RegistryHelper create(String modId, Consumer<RegistryHelper> consumer) {
        RegistryHelper helper = new RegistryHelper(modId);
        consumer.accept(helper);
        return helper;
    }

    public String getModId() {
        return this.modId;
    }

    public ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name);
    }

    public <V> void putSubHelper(ResourceKey<Registry<V>> registry, ISubRegistryHelper<V> subHelper) {
        this.subHelpers.put(registry, subHelper);
    }

    protected void putDefaultSubHelpers() {
        this.putSubHelper(Registries.ITEM, new ItemSubRegistryHelper(this));
        this.putSubHelper(Registries.BLOCK, new BlockSubRegistryHelper(this));
        this.putSubHelper(Registries.SOUND_EVENT, new SoundSubRegistryHelper(this));
        this.putSubHelper(Registries.BLOCK_ENTITY_TYPE, new BlockEntitySubRegistryHelper(this));
        this.putSubHelper(Registries.ENTITY_TYPE, new EntitySubRegistryHelper(this));
    }

    @Nonnull
    public <T, S extends ISubRegistryHelper<T>> S getSubHelper(ResourceKey<Registry<T>> registry) {
        ISubRegistryHelper<?> subHelper = this.subHelpers.get(registry);
        if (subHelper == null) {
            throw new NullPointerException("No Sub Helper is registered for the forge registry: " + String.valueOf(registry));
        }
        return (S)subHelper;
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<Item, ?>> T getItemSubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(Registries.ITEM));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<Block, ?>> T getBlockSubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(Registries.BLOCK));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<SoundEvent, ?>> T getSoundSubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(Registries.SOUND_EVENT));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<BlockEntityType<?>, ?>> T getBlockEntitySubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(Registries.BLOCK_ENTITY_TYPE));
    }

    @Nonnull
    public <T extends AbstractSubRegistryHelper<EntityType<?>, ?>> T getEntitySubHelper() {
        return (T)((AbstractSubRegistryHelper)this.getSubHelper(Registries.ENTITY_TYPE));
    }

    public void register(IEventBus eventBus) {
        this.subHelpers.values().forEach(helper -> helper.register(eventBus));
    }
}

