/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.item.BlueprintBoatItem;
import com.teamabnormals.blueprint.common.item.FuelItem;
import com.teamabnormals.blueprint.core.registry.BlueprintBoatTypes;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemSubRegistryHelper
extends AbstractSubRegistryHelper<Item, DeferredRegister.Items> {
    public ItemSubRegistryHelper(RegistryHelper parent, DeferredRegister.Items deferredRegister) {
        super(parent, deferredRegister);
    }

    public ItemSubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.createItems((String)parent.getModId()));
    }

    public static BlockItem createStandingAndWallBlockItem(Block floorBlock, Block wallBlock, Direction direction) {
        return new StandingAndWallBlockItem(floorBlock, wallBlock, new Item.Properties(), direction);
    }

    public static BlockItem createDoubleHighBlockItem(Block blockForInput) {
        return new DoubleHighBlockItem(blockForInput, new Item.Properties());
    }

    @Deprecated(forRemoval=true)
    public static FuelItem createFuelItem(int burnTime) {
        return new FuelItem(burnTime, new Item.Properties());
    }

    public static BlockItem createSimpleBlockItem(Block blockForInput) {
        return new BlockItem(blockForInput, new Item.Properties());
    }

    public static Item.Properties createSimpleItemProperty(int stackSize) {
        return new Item.Properties().stacksTo(stackSize);
    }

    public <I extends Item> DeferredItem<I> createItem(String name, Supplier<? extends I> supplier) {
        return ((DeferredRegister.Items)this.deferredRegister).register(name, supplier);
    }

    public DeferredItem<DeferredSpawnEggItem> createSpawnEggItem(String entityName, Supplier<EntityType<? extends Mob>> supplier, int primaryColor, int secondaryColor) {
        return ((DeferredRegister.Items)this.deferredRegister).register(entityName + "_spawn_egg", () -> new DeferredSpawnEggItem(supplier, primaryColor, secondaryColor, new Item.Properties()));
    }

    public Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> createBoatAndChestBoatItem(String wood, DeferredHolder<Block, ?> block, boolean raft) {
        ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)this.parent.getModId(), (String)wood);
        DeferredItem boat = ((DeferredRegister.Items)this.deferredRegister).register(wood + "_boat", () -> new BlueprintBoatItem(false, name, ItemSubRegistryHelper.createSimpleItemProperty(1)));
        DeferredItem chestBoat = ((DeferredRegister.Items)this.deferredRegister).register(wood + "_chest_boat", () -> new BlueprintBoatItem(true, name, ItemSubRegistryHelper.createSimpleItemProperty(1)));
        BlueprintBoatTypes.registerType(name, () -> ((DeferredItem)boat).get(), () -> ((DeferredItem)chestBoat).get(), () -> block.get(), raft);
        return Pair.of((Object)boat, (Object)chestBoat);
    }

    public Pair<DeferredItem<BlueprintBoatItem>, DeferredItem<BlueprintBoatItem>> createBoatAndChestBoatItem(String wood, DeferredHolder<Block, ?> block) {
        return this.createBoatAndChestBoatItem(wood, block, false);
    }
}

