/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.client.MemoizedBEWLR;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.block.sign.BlueprintCeilingHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.common.item.FuelBlockItem;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockSubRegistryHelper
extends AbstractSubRegistryHelper<Block, DeferredRegister.Blocks> {
    protected final DeferredRegister<Item> itemRegister;
    protected final HashMap<DeferredHolder<? extends Item, ?>, IClientItemExtensions> clientItemExtensions = new HashMap();

    public BlockSubRegistryHelper(RegistryHelper parent) {
        this(parent, (ISubRegistryHelper<Item>)parent.getSubHelper(Registries.ITEM));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, ISubRegistryHelper<Item> itemHelper) {
        this(parent, itemHelper.getDeferredRegister(), DeferredRegister.createBlocks((String)parent.getModId()));
    }

    private BlockSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> itemRegister, DeferredRegister.Blocks deferredRegister) {
        super(parent, deferredRegister);
        this.itemRegister = itemRegister;
    }

    @Override
    public void register(IEventBus eventBus) {
        super.register(eventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(event -> {
                this.clientItemExtensions.forEach((holder, extensions) -> event.registerItem(extensions, new Item[]{(Item)holder.get()}));
                this.clientItemExtensions.clear();
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static IClientItemExtensions chestBEWLRItemExtensions(Supplier<? extends Block> block, boolean trapped) {
        return MemoizedBEWLR.asCustomItemRenderer(trapped ? (dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<BlueprintTrappedChestBlockEntity>(dispatcher, entityModelSet, new BlueprintTrappedChestBlockEntity(BlockPos.ZERO, ((Block)block.get()).defaultBlockState())) : (dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<BlueprintChestBlockEntity>(dispatcher, entityModelSet, new BlueprintChestBlockEntity(BlockPos.ZERO, ((Block)block.get()).defaultBlockState())));
    }

    public <B extends Block> DeferredBlock<B> createBlock(String name, Supplier<? extends B> supplier) {
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public <B extends Block> DeferredBlock<B> createBlock(String name, Supplier<? extends B> supplier, Item.Properties properties) {
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }

    public <B extends Block> DeferredBlock<B> createBlockWithItem(String name, Supplier<? extends B> supplier, Supplier<BlockItem> item) {
        this.itemRegister.register(name, item);
        return ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
    }

    public <B extends Block> DeferredBlock<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        return ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
    }

    @Deprecated(forRemoval=true)
    public <B extends Block> DeferredBlock<B> createFuelBlock(String name, Supplier<? extends B> supplier, int burnTime) {
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties()));
        return block;
    }

    public <B extends Block> DeferredBlock<B> createBlockWithBEWLR(String name, Supplier<? extends B> supplier, Supplier<MemoizedBEWLR.Factory> belwr) {
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
        DeferredHolder item = this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientItemExtensions.put(item, MemoizedBEWLR.asCustomItemRenderer(belwr.get()));
        }
        return block;
    }

    public <B extends Block> DeferredBlock<B> createDoubleHighBlock(String name, Supplier<? extends B> supplier) {
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
        this.itemRegister.register(name, () -> new DoubleHighBlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public <B extends Block> DeferredBlock<B> createStandingAndWallBlock(String name, Supplier<? extends B> supplier, Supplier<? extends B> wallSupplier, Direction direction) {
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
        this.itemRegister.register(name, () -> new StandingAndWallBlockItem((Block)block.get(), (Block)wallSupplier.get(), new Item.Properties(), direction));
        return block;
    }

    public <B extends Block> DeferredBlock<B> createRareBlock(String name, Supplier<? extends B> supplier, Rarity rarity) {
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().rarity(rarity)));
        return block;
    }

    public DeferredBlock<BlueprintChestBlock> createChestBlock(String name, String materialName, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials(modId, materialName, false);
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, () -> new BlueprintChestBlock(chestMaterialsName, properties));
        DeferredHolder item = this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientItemExtensions.put(item, BlockSubRegistryHelper.chestBEWLRItemExtensions((Supplier<? extends Block>)block, false));
        }
        return block;
    }

    public DeferredBlock<BlueprintChestBlock> createChestBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createChestBlock(materialName + "_chest", materialName, properties);
    }

    public DeferredBlock<BlueprintTrappedChestBlock> createTrappedChestBlock(String name, String materialName, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials(modId, materialName, true);
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name, () -> new BlueprintTrappedChestBlock(chestMaterialsName, properties));
        DeferredHolder item = this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientItemExtensions.put(item, BlockSubRegistryHelper.chestBEWLRItemExtensions((Supplier<? extends Block>)block, true));
        }
        return block;
    }

    public DeferredBlock<BlueprintTrappedChestBlock> createTrappedChestBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createTrappedChestBlock("trapped_" + materialName + "_chest", materialName, properties);
    }

    public Pair<DeferredBlock<BlueprintStandingSignBlock>, DeferredBlock<BlueprintWallSignBlock>> createSignBlock(String name, WoodType woodType, BlockBehaviour.Properties properties) {
        DeferredBlock standing = ((DeferredRegister.Blocks)this.deferredRegister).register(name + "_sign", () -> new BlueprintStandingSignBlock(properties, woodType));
        DeferredBlock wall = ((DeferredRegister.Blocks)this.deferredRegister).register(name + "_wall_sign", () -> new BlueprintWallSignBlock(properties.lootFrom((Supplier)standing), woodType));
        this.itemRegister.register(name + "_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)standing.get(), (Block)wall.get()));
        return Pair.of((Object)standing, (Object)wall);
    }

    public Pair<DeferredBlock<BlueprintCeilingHangingSignBlock>, DeferredBlock<BlueprintWallHangingSignBlock>> createHangingSignBlock(String name, WoodType woodType, BlockBehaviour.Properties properties) {
        DeferredBlock ceiling = ((DeferredRegister.Blocks)this.deferredRegister).register(name + "_hanging_sign", () -> new BlueprintCeilingHangingSignBlock(properties, woodType));
        DeferredBlock wall = ((DeferredRegister.Blocks)this.deferredRegister).register(name + "_wall_hanging_sign", () -> new BlueprintWallHangingSignBlock(properties.lootFrom((Supplier)ceiling), woodType));
        this.itemRegister.register(name + "_hanging_sign", () -> new HangingSignItem((Block)ceiling.get(), (Block)wall.get(), new Item.Properties().stacksTo(16)));
        return Pair.of((Object)ceiling, (Object)wall);
    }
}

