/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockEntitySubRegistryHelper
extends AbstractSubRegistryHelper<BlockEntityType<?>, DeferredRegister<BlockEntityType<?>>> {
    public BlockEntitySubRegistryHelper(RegistryHelper parent, DeferredRegister<BlockEntityType<?>> deferredRegister) {
        super(parent, deferredRegister);
    }

    public BlockEntitySubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)parent.getModId()));
    }

    public static Block[] collectBlocks(Class<?> blockClass) {
        return (Block[])BuiltInRegistries.BLOCK.stream().filter(blockClass::isInstance).toArray(Block[]::new);
    }

    public <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> createBlockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends T> blockEntity, Supplier<Set<Block>> validBlocks) {
        return this.deferredRegister.register(name, () -> new BlockEntityType(blockEntity, (Set)validBlocks.get(), null));
    }

    public <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> createBlockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends T> blockEntity, Class<? extends Block> blockClass) {
        return this.deferredRegister.register(name, () -> new BlockEntityType(blockEntity, (Set)Sets.newHashSet((Object[])BlockEntitySubRegistryHelper.collectBlocks(blockClass)), null));
    }
}

