/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.item;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class ItemStackBuilder {
    private final ItemStack stack;

    public ItemStackBuilder(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStackBuilder(ItemLike item) {
        this(new ItemStack(item));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemStackBuilder setCount(int count) {
        this.stack.setCount(count);
        return this;
    }

    public ItemStackBuilder grow(int amount) {
        this.stack.grow(amount);
        return this;
    }

    public ItemStackBuilder shrink(int amount) {
        this.stack.shrink(amount);
        return this;
    }

    public ItemStackBuilder setUnbreakable(boolean showTooltip) {
        this.stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(showTooltip));
        return this;
    }

    public ItemStackBuilder addEnchantment(Holder<Enchantment> enchantment, int level) {
        this.stack.enchant(enchantment, level);
        return this;
    }

    public ItemStackBuilder setName(@Nullable Component text) {
        this.stack.set(DataComponents.ITEM_NAME, (Object)text);
        return this;
    }

    public ItemStackBuilder addLore(Component text) {
        this.stack.update(DataComponents.LORE, (Object)ItemLore.EMPTY, lore -> lore.withLineAdded(text));
        return this;
    }

    public ItemStackBuilder addAttributeModifier(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slotGroup) {
        this.stack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, modifiers -> modifiers.withModifierAdded(attribute, modifier, slotGroup));
        return this;
    }

    public ItemStack build() {
        return this.stack.copy();
    }
}

