/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public final class BlueprintAndCondition
implements ICondition {
    public static final Codec<List<ICondition>> SHORT_CIRCUIT_CODEC = new Codec<List<ICondition>>(){

        public <T> DataResult<Pair<List<ICondition>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult listResult = ops.getList(input);
            Optional error = listResult.error();
            if (error.isPresent()) {
                return DataResult.error(() -> ((DataResult.Error)error.get()).message());
            }
            Consumer list = (Consumer)listResult.result().get();
            try {
                ArrayList conditions = new ArrayList();
                list.accept(element -> {
                    DataResult conditionResult = ICondition.CODEC.decode(ops, element);
                    Optional conditionError = conditionResult.error();
                    if (conditionError.isPresent()) {
                        throw new EscapeException(((DataResult.Error)conditionError.get()).message());
                    }
                    ICondition condition = (ICondition)((Pair)conditionResult.result().get()).getFirst();
                    if (!condition.test(ICondition.IContext.EMPTY)) {
                        throw new EscapeException(null);
                    }
                    conditions.add(condition);
                });
                return DataResult.success((Object)Pair.of(conditions, input));
            }
            catch (EscapeException e) {
                String errorMessage = e.error;
                return errorMessage != null ? DataResult.error(() -> errorMessage) : DataResult.success((Object)Pair.of(List.of(), input));
            }
        }

        public <T> DataResult<T> encode(List<ICondition> input, DynamicOps<T> ops, T prefix) {
            return ICondition.LIST_CODEC.encode(input, ops, prefix);
        }
    };
    public static final MapCodec<BlueprintAndCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SHORT_CIRCUIT_CODEC.fieldOf("values").forGetter(condition -> condition.children)).apply((Applicative)builder, BlueprintAndCondition::new));
    private final List<ICondition> children;

    @Deprecated
    public BlueprintAndCondition(ResourceLocation location, List<ICondition> children) {
        this(children);
    }

    public BlueprintAndCondition(List<ICondition> children) {
        this.children = children;
    }

    public BlueprintAndCondition(ICondition ... children) {
        this(List.of(children));
    }

    public boolean test(ICondition.IContext context) {
        return !this.children.isEmpty();
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    private static final class EscapeException
    extends RuntimeException {
        @Nullable
        private final String error;

        private EscapeException(String error) {
            this.error = error;
        }
    }
}

