/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api;

import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.phys.Vec3;

public final class AdvancedRandomPos {
    @Nullable
    public static Vec3 findRandomTarget(PathfinderMob pathfinder, int xz, int y, boolean goDeep) {
        return AdvancedRandomPos.findRandomTargetBlock(pathfinder, xz, y, null, goDeep);
    }

    @Nullable
    private static Vec3 findRandomTargetBlock(PathfinderMob pathfinder, int xz, int y, @Nullable Vec3 targetVec, boolean goDeep) {
        return AdvancedRandomPos.generateRandomPos(pathfinder, xz, y, targetVec, true, 1.5707963267948966, goDeep, arg_0 -> ((PathfinderMob)pathfinder).getWalkTargetValue(arg_0));
    }

    @Nullable
    private static Vec3 generateRandomPos(PathfinderMob pathfinder, int xz, int y, @Nullable Vec3 p_191379_3_, boolean p_191379_4_, double p_191379_5_, boolean goDeep, ToDoubleFunction<BlockPos> p_191379_7_) {
        PathNavigation pathnavigator = pathfinder.getNavigation();
        RandomSource random = pathfinder.getRandom();
        boolean flag = pathfinder.hasRestriction() && pathfinder.getRestrictCenter().closerThan((Vec3i)pathfinder.blockPosition(), (double)(pathfinder.getRestrictRadius() + (float)xz) + 1.0);
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos blockpos = new BlockPos((Vec3i)pathfinder.blockPosition());
        for (int i = 0; i < 10; ++i) {
            double d1;
            BlockPos blockpos1 = AdvancedRandomPos.getBlockPos(random, xz, y, p_191379_3_, p_191379_5_, goDeep);
            if (blockpos1 == null) continue;
            int j = blockpos1.getX();
            int k = blockpos1.getY();
            int l = blockpos1.getZ();
            if (pathfinder.hasRestriction() && xz > 1) {
                BlockPos blockpos2 = pathfinder.getRestrictCenter();
                j = pathfinder.getX() > (double)blockpos2.getX() ? (j -= random.nextInt(xz / 2)) : (j += random.nextInt(xz / 2));
                l = pathfinder.getZ() > (double)blockpos2.getZ() ? (l -= random.nextInt(xz / 2)) : (l += random.nextInt(xz / 2));
            }
            BlockPos blockpos3 = new BlockPos(Mth.floor((double)((double)j + pathfinder.getX())), Mth.floor((double)((double)k + pathfinder.getY())), Mth.floor((double)((double)l + pathfinder.getZ())));
            if (flag && !pathfinder.isWithinRestriction(blockpos3) || !pathnavigator.isStableDestination(blockpos3) || !p_191379_4_ && AdvancedRandomPos.isWaterDestination(blockpos3 = AdvancedRandomPos.moveAboveSolid(blockpos3, pathfinder), pathfinder) || !((d1 = p_191379_7_.applyAsDouble(blockpos3)) > d0)) continue;
            d0 = d1;
            blockpos = blockpos3;
            flag1 = true;
        }
        if (flag1) {
            return Vec3.atCenterOf((Vec3i)blockpos);
        }
        return null;
    }

    @Nullable
    private static BlockPos getBlockPos(RandomSource rand, int xz, int y, @Nullable Vec3 Vector3d, double angle, boolean goDeep) {
        if (Vector3d != null && !(angle >= Math.PI)) {
            double d3 = Mth.atan2((double)Vector3d.z, (double)Vector3d.x) - 1.5707963705062866;
            double d4 = d3 + (double)(2.0f * rand.nextFloat() - 1.0f) * angle;
            double d0 = Math.sqrt(rand.nextDouble()) * (double)Mth.SQRT_OF_TWO * (double)xz;
            double d1 = -d0 * Math.sin(d4);
            double d2 = d0 * Math.cos(d4);
            if (!(Math.abs(d1) > (double)xz) && !(Math.abs(d2) > (double)xz)) {
                double newY = rand.nextInt(2 * y + 1) - y;
                return new BlockPos(Mth.floor((double)d1), Mth.floor((double)newY), Mth.floor((double)d2));
            }
            return null;
        }
        int newX = rand.nextInt(2 * xz + 1) - xz;
        int newY = rand.nextInt(2 * y + 1) - y;
        int newZ = rand.nextInt(2 * xz + 1) - xz;
        if (goDeep) {
            newY = rand.nextInt(y + 1) - y * 2;
        }
        return new BlockPos(newX, newY, newZ);
    }

    private static BlockPos moveAboveSolid(BlockPos pos, PathfinderMob pathfinder) {
        if (!pathfinder.level().getBlockState(pos).isSolid()) {
            return pos;
        }
        BlockPos blockpos = pos.above();
        while (blockpos.getY() < pathfinder.level().getMaxBuildHeight() && pathfinder.level().getBlockState(blockpos).isSolid()) {
            blockpos = blockpos.above();
        }
        return blockpos;
    }

    private static boolean isWaterDestination(BlockPos pos, PathfinderMob pathfinder) {
        return pathfinder.level().getFluidState(pos).is(FluidTags.WATER);
    }
}

