/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.common.remolder.data.DataExpressionParser;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.DataVisitor;
import com.teamabnormals.blueprint.common.remolder.data.ElementType;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import com.teamabnormals.blueprint.common.remolder.data.ReturnType;
import com.teamabnormals.blueprint.common.remolder.data.VariableDataVisitor;
import java.text.ParseException;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public sealed interface DynamicReference {
    public static final Codec<Direct> DIRECT_CODEC = new Codec<Direct>(){

        public <T> DataResult<Pair<Direct, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)new Direct(dynamicOps -> ops.convertTo(dynamicOps, input)), (Object)ops.empty()));
        }

        public <T> DataResult<T> encode(Direct direct, DynamicOps<T> ops, T prefix) {
            return DataResult.success(direct.getter.apply(ops));
        }
    };
    public static final Codec<Expression> EXPRESSION_CODEC = Codec.STRING.flatXmap(string -> {
        try {
            return DataResult.success((Object)DynamicReference.eval(string));
        }
        catch (ParseException exception) {
            return DataResult.error(exception::getMessage);
        }
    }, expression -> DataResult.success((Object)expression.getRawExpression()));
    public static final MapCodec<DynamicReference> MAP_CODEC = Codec.mapEither((MapCodec)DIRECT_CODEC.fieldOf("value"), (MapCodec)EXPRESSION_CODEC.fieldOf("expressed_value")).xmap(either -> {
        Optional left = either.left();
        if (left.isPresent()) {
            return (DynamicReference)left.get();
        }
        return (DynamicReference)either.right().get();
    }, reference -> {
        if (reference instanceof Direct) {
            Direct direct = (Direct)reference;
            return Either.left((Object)direct);
        }
        return Either.right((Object)((Expression)reference));
    });

    public static Direct value(Function<DynamicOps<?>, ?> getter) {
        return new Direct(getter);
    }

    public static <A> Direct value(A value, Encoder<A> encoder) {
        return new Direct(dynamicOps -> {
            DataResult dataResult = encoder.encodeStart(dynamicOps, value);
            Optional error = dataResult.error();
            if (error.isPresent()) {
                throw new RuntimeException(((DataResult.Error)error.get()).message());
            }
            return dataResult.result().get();
        });
    }

    public static <A> Direct value(A value, final Function<A, JsonElement> encoder) {
        return DynamicReference.value(value, new Encoder<A>(){

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, (JsonElement)encoder.apply(input)));
            }
        });
    }

    public static Expression target(String expression) {
        return new Expression(expression, null);
    }

    public static Expression eval(String expression) throws ParseException {
        return new Expression(expression);
    }

    public DataVisitor visitor();

    public static final class Direct
    implements DynamicReference {
        private final Function<DynamicOps<?>, ?> getter;
        private final DataVisitor visitor;

        public Direct(final Function<DynamicOps<?>, ?> getter) {
            this.getter = getter;
            String fieldName = "getter" + System.nanoTime();
            this.visitor = new DataVisitor(){

                @Override
                public void visit(Molding molding) {
                    molding.provideVariable("direct", DataType.FUNCTION, getter).visit(molding);
                    VariableDataVisitor.OPS.visit(molding);
                    molding.visitMethodInsn(185, "java/util/function/Function", "apply", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                    molding.visitTypeInsn(192, molding.getDataType().getInternalName());
                }

                @Override
                public ReturnType getReturnType() {
                    return ElementType.ELEMENTAL;
                }
            };
        }

        @Override
        public DataVisitor visitor() {
            return this.visitor;
        }
    }

    public static final class Expression
    implements DynamicReference {
        private final String rawExpression;
        private final DataVisitor visitor;

        public Expression(String rawExpression) throws ParseException {
            this(rawExpression, DataExpressionParser.parse(rawExpression));
        }

        public Expression(String rawExpression, @Nullable DataVisitor visitor) {
            this.rawExpression = rawExpression;
            this.visitor = visitor;
        }

        public String getRawExpression() {
            return this.rawExpression;
        }

        @Override
        public DataVisitor visitor() {
            return this.visitor;
        }
    }
}

