/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.DataVisitor;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import com.teamabnormals.blueprint.common.remolder.data.ReturnType;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class DataVisitors {
    static Const booleanValue(boolean value) {
        return new Const(DataType.BOOLEAN, value, value ? 4 : 3);
    }

    static DataVisitor charValue(char value) {
        return value <= '\u0005' ? new Const(DataType.CHAR, Character.valueOf(value), value + 3) : new Ldc(DataType.CHAR, Character.valueOf(value));
    }

    static DataVisitor byteValue(byte value) {
        return value >= -1 && value <= 5 ? new Const(DataType.BYTE, value, value + 3) : new Ldc(DataType.BYTE, value);
    }

    static DataVisitor shortValue(short value) {
        return value >= -1 && value <= 5 ? new Const(DataType.SHORT, value, value + 3) : new Ldc(DataType.SHORT, value);
    }

    static DataVisitor intValue(int value) {
        return value >= -1 && value <= 5 ? new Const(DataType.INT, value, value + 3) : new Ldc(DataType.INT, value);
    }

    static DataVisitor longValue(long value) {
        if (value == 0L) {
            return new Const(DataType.LONG, value, 9);
        }
        if (value == 1L) {
            return new Const(DataType.LONG, value, 10);
        }
        return new Ldc(DataType.LONG, value);
    }

    static DataVisitor floatValue(float value) {
        int opcode;
        if (value == 0.0f) {
            opcode = 11;
        } else if (value == 1.0f) {
            opcode = 12;
        } else if (value == 2.0f) {
            opcode = 13;
        } else {
            return new Ldc(DataType.FLOAT, Float.valueOf(value));
        }
        return new Const(DataType.FLOAT, Float.valueOf(value), opcode);
    }

    static DataVisitor doubleValue(double value) {
        if (value == 0.0) {
            return new Const(DataType.DOUBLE, value, 14);
        }
        if (value == 1.0) {
            return new Const(DataType.DOUBLE, value, 15);
        }
        return new Ldc(DataType.DOUBLE, value);
    }

    static DataVisitor string(String value) {
        return new Ldc(DataType.STRING, value);
    }

    static void ifneResult(MethodVisitor method) {
        Label trueResult = new Label();
        method.visitJumpInsn(154, trueResult);
        method.visitInsn(3);
        Label end = new Label();
        method.visitJumpInsn(167, end);
        method.visitLabel(trueResult);
        method.visitInsn(4);
        method.visitLabel(end);
    }

    static void boolean2Int(MethodVisitor method) {
        method.visitInsn(3);
        method.visitMethodInsn(184, "java/lang/Boolean", "compare", "(ZZ)I", false);
    }

    static void boolean2Long(MethodVisitor method) {
        Label trueLabel = new Label();
        method.visitJumpInsn(154, trueLabel);
        method.visitInsn(9);
        Label endLabel = new Label();
        method.visitJumpInsn(167, endLabel);
        method.visitLabel(trueLabel);
        method.visitInsn(10);
        method.visitLabel(endLabel);
    }

    static void boolean2Float(MethodVisitor method) {
        Label trueLabel = new Label();
        method.visitJumpInsn(154, trueLabel);
        method.visitInsn(11);
        Label endLabel = new Label();
        method.visitJumpInsn(167, endLabel);
        method.visitLabel(trueLabel);
        method.visitInsn(12);
        method.visitLabel(endLabel);
    }

    static void boolean2Double(MethodVisitor method) {
        Label trueLabel = new Label();
        method.visitJumpInsn(154, trueLabel);
        method.visitInsn(14);
        Label endLabel = new Label();
        method.visitJumpInsn(167, endLabel);
        method.visitLabel(trueLabel);
        method.visitInsn(15);
        method.visitLabel(endLabel);
    }

    static void long2Boolean(MethodVisitor method) {
        method.visitInsn(9);
        method.visitInsn(148);
        DataVisitors.ifneResult(method);
    }

    static void float2Boolean(MethodVisitor method) {
        method.visitInsn(11);
        method.visitInsn(149);
        DataVisitors.ifneResult(method);
    }

    static void double2Boolean(MethodVisitor method) {
        method.visitInsn(14);
        method.visitInsn(151);
        DataVisitors.ifneResult(method);
    }

    static void int2Long(MethodVisitor method) {
        method.visitInsn(133);
    }

    static void int2Float(MethodVisitor method) {
        method.visitInsn(134);
    }

    static void int2Double(MethodVisitor method) {
        method.visitInsn(135);
    }

    static void int2Byte(MethodVisitor method) {
        method.visitInsn(145);
    }

    static void int2Char(MethodVisitor method) {
        method.visitInsn(146);
    }

    static void int2Short(MethodVisitor method) {
        method.visitInsn(147);
    }

    static void float2Int(MethodVisitor method) {
        method.visitInsn(139);
    }

    static void float2Long(MethodVisitor method) {
        method.visitInsn(140);
    }

    static void float2Double(MethodVisitor method) {
        method.visitInsn(141);
    }

    static void long2Int(MethodVisitor method) {
        method.visitInsn(136);
    }

    static void long2Float(MethodVisitor method) {
        method.visitInsn(137);
    }

    static void long2Double(MethodVisitor method) {
        method.visitInsn(138);
    }

    static void double2Int(MethodVisitor method) {
        method.visitInsn(142);
    }

    static void double2Long(MethodVisitor method) {
        method.visitInsn(143);
    }

    static void double2Float(MethodVisitor method) {
        method.visitInsn(144);
    }

    static void number2Boolean(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
        DataVisitors.double2Boolean(method);
    }

    static void number2Char(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "charValue", "()C", false);
    }

    static void number2Byte(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B", false);
    }

    static void number2Short(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S", false);
    }

    static void number2Int(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "intValue", "()I", false);
    }

    static void number2Long(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "longValue", "()J", false);
    }

    static void number2Float(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F", false);
    }

    static void number2Double(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
    }

    static void boxBoolean(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
    }

    static void unboxBoolean(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
    }

    static void boxChar(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
    }

    static void unboxCharacter(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
    }

    static void boxByte(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
    }

    static void unboxByte(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
    }

    static void boxShort(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
    }

    static void unboxShort(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
    }

    static void boxInt(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
    }

    static void unboxInteger(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
    }

    static void boxLong(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
    }

    static void unboxLong(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
    }

    static void boxFloat(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
    }

    static void unboxFloat(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
    }

    static void boxDouble(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
    }

    static void unboxDouble(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
    }

    static void boxPrimitive(Molding molding, Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            DataVisitors.boxBoolean(molding);
        } else if (clazz == Integer.TYPE) {
            DataVisitors.boxInt(molding);
        } else if (clazz == Long.TYPE) {
            DataVisitors.boxLong(molding);
        } else if (clazz == Float.TYPE) {
            DataVisitors.boxFloat(molding);
        } else if (clazz == Double.TYPE) {
            DataVisitors.boxDouble(molding);
        } else if (clazz == Character.TYPE) {
            DataVisitors.boxChar(molding);
        } else if (clazz == Byte.TYPE) {
            DataVisitors.boxByte(molding);
        } else if (clazz == Short.TYPE) {
            DataVisitors.boxShort(molding);
        }
    }

    static void stringLength(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/String", "length", "()I", false);
    }

    static DataVisitor element(final DataVisitor visitor) {
        return new DataVisitor(){

            @Override
            public void visit(Molding molding) {
                molding.element(visitor);
            }

            @Override
            public ReturnType getReturnType() {
                return molding -> molding.getRepresentationType(visitor.getReturnType().getDataType(molding));
            }
        };
    }

    static DataVisitor str(final DataVisitor visitor) {
        return new DataVisitor(){

            @Override
            public void visit(Molding molding) {
                visitor.visit(molding);
                DataType<?> dataType = visitor.getReturnType().getDataType(molding);
                try {
                    molding.toString(dataType);
                }
                catch (UnsupportedOperationException unsupported) {
                    Type type = dataType.getType();
                    TypeVisitors.Visitors visitorsForType = TypeVisitors.getVisitors(type);
                    if (visitorsForType != null) {
                        Consumer<MethodVisitor> converter = visitorsForType.stringConverter();
                        if (converter != null) {
                            converter.accept(molding);
                        }
                        return;
                    }
                    int sort = type.getSort();
                    if (sort == 10 || sort == 9) {
                        molding.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;", false);
                    }
                    throw new UnsupportedOperationException("Don't know how to convert " + String.valueOf(type) + " to string");
                }
            }

            @Override
            public ReturnType getReturnType() {
                return DataType.STRING;
            }
        };
    }

    static DataVisitor convertViaTypeVisitors(DataVisitor visitor, DataType<?> type, Function<TypeVisitors.Visitors, Consumer<? super Molding>> converterFromVisitors, Consumer<Molding> numberVisitor) {
        Consumer<Molding> converter;
        ReturnType returnType = visitor.getReturnType();
        if (returnType instanceof DataType) {
            DataType dataType = (DataType)returnType;
            TypeVisitors.Visitors visitorsForType = TypeVisitors.getVisitors(dataType.getType());
            if (visitorsForType != null) {
                converter = converterFromVisitors.apply(visitorsForType);
                if (converter == null) {
                    return visitor;
                }
            } else {
                if (!Number.class.isAssignableFrom(dataType.getClazz())) {
                    throw new UnsupportedOperationException("Don't know how to convert " + String.valueOf(dataType) + " to " + String.valueOf(type));
                }
                converter = numberVisitor;
            }
        } else {
            converter = molding -> molding.convert(returnType.getDataType((Molding)((Object)molding)), type);
        }
        return new Pipe(visitor, converter, type);
    }

    static DataVisitor convertToBoolean(DataVisitor visitor) {
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.BOOLEAN, TypeVisitors.Visitors::booleanConverter, DataVisitors::number2Boolean);
    }

    static DataVisitor convertToBooleanWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.BOOLEAN_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToBoolean(visitor).then(DataVisitors::boxBoolean, DataType.BOOLEAN_WRAPPER);
    }

    static DataVisitor convertToChar(DataVisitor visitor) {
        Constant constant;
        Object object;
        if (visitor instanceof Constant && (object = (constant = (Constant)visitor).value()) instanceof Number) {
            Number number;
            Number number2 = number = (Number)object;
            Objects.requireNonNull(number2);
            object = number2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Double.class, Float.class, Short.class, Byte.class}, (Object)object, n)) {
                case 0: {
                    Integer i = (Integer)object;
                    return DataVisitors.charValue((char)number.intValue());
                }
                case 1: {
                    Long l = (Long)object;
                    return DataVisitors.charValue((char)number.longValue());
                }
                case 2: {
                    Double v = (Double)object;
                    return DataVisitors.charValue((char)number.doubleValue());
                }
                case 3: {
                    Float v = (Float)object;
                    return DataVisitors.charValue((char)number.floatValue());
                }
                case 4: {
                    Short i = (Short)object;
                    return DataVisitors.charValue((char)number.shortValue());
                }
                case 5: {
                    Byte b = (Byte)object;
                    return DataVisitors.charValue((char)number.byteValue());
                }
            }
        }
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.CHAR, TypeVisitors.Visitors::charConverter, DataVisitors::number2Char);
    }

    static DataVisitor convertToCharWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.CHARACTER_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToChar(visitor).then(DataVisitors::boxChar, DataType.CHARACTER_WRAPPER);
    }

    static DataVisitor convertToByte(DataVisitor visitor) {
        Constant constant;
        Object object;
        if (visitor instanceof Constant && (object = (constant = (Constant)visitor).value()) instanceof Number) {
            Number number = (Number)object;
            return DataVisitors.byteValue(number.byteValue());
        }
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.BYTE, TypeVisitors.Visitors::byteConverter, DataVisitors::number2Byte);
    }

    static DataVisitor convertToByteWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.BYTE_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToByte(visitor).then(DataVisitors::boxByte, DataType.BYTE_WRAPPER);
    }

    static DataVisitor convertToShort(DataVisitor visitor) {
        Constant constant;
        Object object;
        if (visitor instanceof Constant && (object = (constant = (Constant)visitor).value()) instanceof Number) {
            Number number = (Number)object;
            return DataVisitors.shortValue(number.shortValue());
        }
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.SHORT, TypeVisitors.Visitors::shortConverter, DataVisitors::number2Short);
    }

    static DataVisitor convertToShortWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.SHORT_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToShort(visitor).then(DataVisitors::boxShort, DataType.SHORT_WRAPPER);
    }

    static DataVisitor convertToInt(DataVisitor visitor) {
        Constant constant;
        Object object;
        if (visitor instanceof Constant && (object = (constant = (Constant)visitor).value()) instanceof Number) {
            Number number = (Number)object;
            return DataVisitors.intValue(number.intValue());
        }
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.INT, TypeVisitors.Visitors::intConverter, DataVisitors::number2Int);
    }

    static DataVisitor convertToIntWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.INTEGER_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToInt(visitor).then(DataVisitors::boxInt, DataType.INTEGER_WRAPPER);
    }

    static DataVisitor convertToLong(DataVisitor visitor) {
        Constant constant;
        Object object;
        if (visitor instanceof Constant && (object = (constant = (Constant)visitor).value()) instanceof Number) {
            Number number = (Number)object;
            return DataVisitors.longValue(number.longValue());
        }
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.LONG, TypeVisitors.Visitors::longConverter, DataVisitors::number2Long);
    }

    static DataVisitor convertToLongWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.LONG_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToLong(visitor).then(DataVisitors::boxLong, DataType.LONG_WRAPPER);
    }

    static DataVisitor convertToFloat(DataVisitor visitor) {
        Constant constant;
        Object object;
        if (visitor instanceof Constant && (object = (constant = (Constant)visitor).value()) instanceof Number) {
            Number number = (Number)object;
            return DataVisitors.floatValue(number.floatValue());
        }
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.FLOAT, TypeVisitors.Visitors::floatConverter, DataVisitors::number2Float);
    }

    static DataVisitor convertToFloatWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.FLOAT_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToFloat(visitor).then(DataVisitors::boxFloat, DataType.FLOAT_WRAPPER);
    }

    static DataVisitor convertToDouble(DataVisitor visitor) {
        Constant constant;
        Object object;
        if (visitor instanceof Constant && (object = (constant = (Constant)visitor).value()) instanceof Number) {
            Number number = (Number)object;
            return DataVisitors.doubleValue(number.doubleValue());
        }
        return DataVisitors.convertViaTypeVisitors(visitor, DataType.DOUBLE, TypeVisitors.Visitors::doubleConverter, DataVisitors::number2Double);
    }

    static DataVisitor convertToDoubleWrapper(DataVisitor visitor) {
        if (visitor.getReturnType() == DataType.DOUBLE_WRAPPER) {
            return visitor;
        }
        return DataVisitors.convertToDouble(visitor).then(DataVisitors::boxDouble, DataType.DOUBLE_WRAPPER);
    }

    record Const(DataType<?> type, Object value, int opcode) implements Constant
    {
        @Override
        public void visit(Molding molding) {
            molding.visitInsn(this.opcode);
        }

        @Override
        public ReturnType getReturnType() {
            return this.type;
        }
    }

    record Ldc(DataType<?> type, Object value) implements Constant
    {
        @Override
        public void visit(Molding molding) {
            molding.visitLdcInsn(this.value);
        }

        @Override
        public ReturnType getReturnType() {
            return this.type;
        }
    }

    static final class TypeVisitors {
        private static final HashMap<Type, Visitors> MAP = new HashMap();
        public static final Visitors BOOLEAN_VISITORS;
        public static final Visitors BOOLEAN_WRAPPER_VISITORS;
        public static final Visitors CHAR_VISITORS;
        public static final Visitors CHAR_WRAPPER_VISITORS;
        public static final Visitors BYTE_VISITORS;
        public static final Visitors BYTE_WRAPPER_VISITORS;
        public static final Visitors SHORT_VISITORS;
        public static final Visitors SHORT_WRAPPER_VISITORS;
        public static final Visitors INT_VISITORS;
        public static final Visitors INT_WRAPPER_VISITORS;
        public static final Visitors LONG_VISITORS;
        public static final Visitors LONG_WRAPPER_VISITORS;
        public static final Visitors FLOAT_VISITORS;
        public static final Visitors FLOAT_WRAPPER_VISITORS;
        public static final Visitors DOUBLE_VISITORS;
        public static final Visitors DOUBLE_WRAPPER_VISITORS;
        public static final Visitors STRING_VISITORS;

        TypeVisitors() {
        }

        public static synchronized Visitors register(Type type, Visitors visitors) {
            MAP.put(type, visitors);
            return visitors;
        }

        @Nullable
        public static Visitors getVisitors(Type type) {
            return MAP.get(type);
        }

        static {
            Consumer<MethodVisitor> booleanToInt = DataVisitors::boolean2Int;
            BOOLEAN_VISITORS = TypeVisitors.register(Type.BOOLEAN_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(Z)Ljava/lang/String;", false), null, booleanToInt, booleanToInt, booleanToInt, booleanToInt, DataVisitors::boolean2Long, DataVisitors::boolean2Float, DataVisitors::boolean2Double));
            Consumer<MethodVisitor> booleanWrapperToInt = method -> {
                DataVisitors.unboxBoolean(method);
                DataVisitors.boolean2Int(method);
            };
            BOOLEAN_WRAPPER_VISITORS = TypeVisitors.register(DataType.BOOLEAN_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxBoolean(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(Z)Ljava/lang/String;", false);
            }, DataVisitors::unboxBoolean, booleanWrapperToInt, booleanWrapperToInt, booleanWrapperToInt, booleanWrapperToInt, method -> {
                DataVisitors.unboxBoolean(method);
                DataVisitors.boolean2Long(method);
            }, method -> {
                DataVisitors.unboxBoolean(method);
                DataVisitors.boolean2Float(method);
            }, method -> {
                DataVisitors.unboxBoolean(method);
                DataVisitors.boolean2Double(method);
            }));
            Consumer<MethodVisitor> ifneResult = DataVisitors::ifneResult;
            Consumer<MethodVisitor> i2b = DataVisitors::int2Byte;
            Consumer<MethodVisitor> i2s = DataVisitors::int2Short;
            Consumer<MethodVisitor> i2l = DataVisitors::int2Long;
            Consumer<MethodVisitor> i2f = DataVisitors::int2Float;
            Consumer<MethodVisitor> i2d = DataVisitors::int2Double;
            CHAR_VISITORS = TypeVisitors.register(Type.CHAR_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;", false), ifneResult, null, i2b, i2s, null, i2l, i2f, i2d));
            Consumer<MethodVisitor> unboxCharacter = DataVisitors::unboxCharacter;
            CHAR_WRAPPER_VISITORS = TypeVisitors.register(DataType.CHARACTER_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxCharacter(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;", false);
            }, method -> {
                DataVisitors.unboxCharacter(method);
                DataVisitors.ifneResult(method);
            }, unboxCharacter, method -> {
                DataVisitors.unboxCharacter(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.unboxCharacter(method);
                DataVisitors.int2Short(method);
            }, unboxCharacter, method -> {
                DataVisitors.unboxCharacter(method);
                DataVisitors.int2Long(method);
            }, method -> {
                DataVisitors.unboxCharacter(method);
                DataVisitors.int2Float(method);
            }, method -> {
                DataVisitors.unboxCharacter(method);
                DataVisitors.int2Double(method);
            }));
            Consumer<MethodVisitor> i2c = DataVisitors::int2Char;
            BYTE_VISITORS = TypeVisitors.register(Type.BYTE_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false), ifneResult, i2c, null, null, null, i2l, i2f, i2d));
            Consumer<MethodVisitor> unboxByte = DataVisitors::unboxByte;
            BYTE_WRAPPER_VISITORS = TypeVisitors.register(DataType.BYTE_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxByte(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false);
            }, method -> {
                DataVisitors.unboxByte(method);
                DataVisitors.ifneResult(method);
            }, method -> {
                DataVisitors.unboxByte(method);
                DataVisitors.int2Char(method);
            }, unboxByte, unboxByte, unboxByte, method -> {
                DataVisitors.unboxByte(method);
                DataVisitors.int2Long(method);
            }, method -> {
                DataVisitors.unboxByte(method);
                DataVisitors.int2Float(method);
            }, method -> {
                DataVisitors.unboxByte(method);
                DataVisitors.int2Double(method);
            }));
            SHORT_VISITORS = TypeVisitors.register(Type.SHORT_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false), ifneResult, i2c, i2b, null, null, i2l, i2f, i2d));
            Consumer<MethodVisitor> unboxShort = DataVisitors::unboxShort;
            SHORT_WRAPPER_VISITORS = TypeVisitors.register(DataType.SHORT_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxShort(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false);
            }, method -> {
                DataVisitors.unboxShort(method);
                DataVisitors.ifneResult(method);
            }, method -> {
                DataVisitors.unboxShort(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.unboxShort(method);
                DataVisitors.int2Byte(method);
            }, unboxShort, unboxShort, method -> {
                DataVisitors.unboxShort(method);
                DataVisitors.int2Long(method);
            }, method -> {
                DataVisitors.unboxShort(method);
                DataVisitors.int2Float(method);
            }, method -> {
                DataVisitors.unboxShort(method);
                DataVisitors.int2Double(method);
            }));
            INT_VISITORS = TypeVisitors.register(Type.INT_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false), ifneResult, i2c, i2b, i2s, null, i2l, i2f, i2d));
            INT_WRAPPER_VISITORS = TypeVisitors.register(DataType.INTEGER_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxInteger(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false);
            }, method -> {
                DataVisitors.unboxInteger(method);
                DataVisitors.ifneResult(method);
            }, method -> {
                DataVisitors.unboxInteger(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.unboxInteger(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.unboxInteger(method);
                DataVisitors.int2Short(method);
            }, DataVisitors::unboxInteger, method -> {
                DataVisitors.unboxInteger(method);
                DataVisitors.int2Long(method);
            }, method -> {
                DataVisitors.unboxInteger(method);
                DataVisitors.int2Float(method);
            }, method -> {
                DataVisitors.unboxInteger(method);
                DataVisitors.int2Double(method);
            }));
            LONG_VISITORS = TypeVisitors.register(Type.LONG_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(J)Ljava/lang/String;", false), DataVisitors::long2Boolean, method -> {
                DataVisitors.long2Int(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.long2Int(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.long2Int(method);
                DataVisitors.int2Short(method);
            }, DataVisitors::long2Int, null, DataVisitors::long2Float, DataVisitors::long2Double));
            LONG_WRAPPER_VISITORS = TypeVisitors.register(DataType.LONG_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxLong(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(J)Ljava/lang/String;", false);
            }, method -> {
                DataVisitors.unboxLong(method);
                DataVisitors.long2Boolean(method);
            }, method -> {
                DataVisitors.unboxLong(method);
                DataVisitors.long2Int(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.unboxLong(method);
                DataVisitors.long2Int(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.unboxLong(method);
                DataVisitors.long2Int(method);
                DataVisitors.int2Short(method);
            }, method -> {
                DataVisitors.unboxLong(method);
                DataVisitors.long2Int(method);
            }, DataVisitors::unboxLong, method -> {
                DataVisitors.unboxLong(method);
                DataVisitors.long2Float(method);
            }, method -> {
                DataVisitors.unboxLong(method);
                DataVisitors.long2Double(method);
            }));
            FLOAT_VISITORS = TypeVisitors.register(Type.FLOAT_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(F)Ljava/lang/String;", false), DataVisitors::float2Boolean, method -> {
                DataVisitors.float2Int(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.float2Int(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.float2Int(method);
                DataVisitors.int2Short(method);
            }, DataVisitors::float2Int, DataVisitors::float2Long, null, DataVisitors::float2Double));
            FLOAT_WRAPPER_VISITORS = TypeVisitors.register(DataType.FLOAT_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxFloat(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(F)Ljava/lang/String;", false);
            }, method -> {
                DataVisitors.unboxFloat(method);
                DataVisitors.float2Boolean(method);
            }, method -> {
                DataVisitors.unboxFloat(method);
                DataVisitors.float2Int(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.unboxFloat(method);
                DataVisitors.float2Int(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.unboxFloat(method);
                DataVisitors.float2Int(method);
                DataVisitors.int2Short(method);
            }, method -> {
                DataVisitors.unboxFloat(method);
                DataVisitors.float2Int(method);
            }, method -> {
                DataVisitors.unboxFloat(method);
                DataVisitors.float2Long(method);
            }, DataVisitors::unboxFloat, method -> {
                DataVisitors.unboxFloat(method);
                DataVisitors.float2Double(method);
            }));
            DOUBLE_VISITORS = TypeVisitors.register(Type.DOUBLE_TYPE, new Visitors(method -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(D)Ljava/lang/String;", false), DataVisitors::double2Boolean, method -> {
                DataVisitors.double2Int(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.double2Int(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.double2Int(method);
                DataVisitors.int2Short(method);
            }, DataVisitors::double2Int, DataVisitors::double2Long, DataVisitors::double2Float, null));
            DOUBLE_WRAPPER_VISITORS = TypeVisitors.register(DataType.DOUBLE_WRAPPER.getType(), new Visitors(method -> {
                DataVisitors.unboxDouble(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(D)Ljava/lang/String;", false);
            }, method -> {
                DataVisitors.unboxDouble(method);
                DataVisitors.double2Boolean(method);
            }, method -> {
                DataVisitors.unboxDouble(method);
                DataVisitors.double2Int(method);
                DataVisitors.int2Char(method);
            }, method -> {
                DataVisitors.unboxDouble(method);
                DataVisitors.double2Int(method);
                DataVisitors.int2Byte(method);
            }, method -> {
                DataVisitors.unboxDouble(method);
                DataVisitors.double2Int(method);
                DataVisitors.int2Short(method);
            }, method -> {
                DataVisitors.unboxDouble(method);
                DataVisitors.double2Int(method);
            }, method -> {
                DataVisitors.unboxDouble(method);
                DataVisitors.double2Long(method);
            }, method -> {
                DataVisitors.unboxDouble(method);
                DataVisitors.double2Float(method);
            }, DataVisitors::unboxDouble));
            STRING_VISITORS = TypeVisitors.register(DataType.STRING.getType(), new Visitors(null, method -> {
                method.visitMethodInsn(182, "java/lang/String", "isEmpty", "()Z", false);
                Label isNotEmpty = new Label();
                method.visitJumpInsn(153, isNotEmpty);
                method.visitInsn(3);
                Label end = new Label();
                method.visitJumpInsn(167, end);
                method.visitLabel(isNotEmpty);
                method.visitInsn(4);
                method.visitLabel(end);
            }, method -> {
                method.visitInsn(3);
                method.visitMethodInsn(182, "java/lang/String", "charAt", "(I)C", false);
            }, method -> method.visitMethodInsn(184, "java/lang/Byte", "parseByte", "(Ljava/lang/String;)B", false), method -> method.visitMethodInsn(184, "java/lang/Short", "parseShort", "(Ljava/lang/String;)S", false), method -> method.visitMethodInsn(184, "java/lang/Integer", "parseInt", "(Ljava/lang/String;)I", false), method -> method.visitMethodInsn(184, "java/lang/Long", "parseLong", "(Ljava/lang/String;)J", false), method -> method.visitMethodInsn(184, "java/lang/Float", "parseFloat", "(Ljava/lang/String;)F", false), method -> method.visitMethodInsn(184, "java/lang/Double", "parseDouble", "(Ljava/lang/String;)D", false)));
        }

        record Visitors(@Nullable Consumer<MethodVisitor> stringConverter, @Nullable Consumer<MethodVisitor> booleanConverter, @Nullable Consumer<MethodVisitor> charConverter, @Nullable Consumer<MethodVisitor> byteConverter, @Nullable Consumer<MethodVisitor> shortConverter, @Nullable Consumer<MethodVisitor> intConverter, @Nullable Consumer<MethodVisitor> longConverter, @Nullable Consumer<MethodVisitor> floatConverter, @Nullable Consumer<MethodVisitor> doubleConverter) {
        }
    }

    record Pipe(DataVisitor visitor, Consumer<? super Molding> consumer, ReturnType type) implements DataVisitor
    {
        @Override
        public void visit(Molding molding) {
            this.visitor.visit(molding);
            this.consumer.accept(molding);
        }

        @Override
        public ReturnType getReturnType() {
            return this.type;
        }
    }

    static interface Constant
    extends DataVisitor {
        public Object value();
    }
}

