/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.common.remolder.RemolderEntry;
import com.teamabnormals.blueprint.common.remolder.Remolding;
import com.teamabnormals.blueprint.common.remolder.RemoldingCompiler;
import com.teamabnormals.blueprint.common.remolder.data.MoldingTypes;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.EmptyResourceSelector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public final class RemolderLoader {
    private static final Gson GSON = new Gson();
    private final HashMap<String, IdentityHashMap<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>>> fileExtensionToEntries = new HashMap();
    private final RemoldingCompiler compiler;
    private final PackType packType;

    public RemolderLoader(CloseableResourceManager manager, PackType packType) {
        RemoldingCompiler.ExportEntry[] exports;
        this.packType = packType;
        try (BufferedReader reader = manager.getResourceOrThrow(Blueprint.location("remolder.json")).openAsReader();){
            JsonElement element = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
            DataResult dataResult = Settings.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
            Optional dataResultError = dataResult.error();
            if (dataResultError.isPresent()) {
                throw new JsonParseException(((DataResult.Error)dataResultError.get()).message());
            }
            exports = ((Settings)((Pair)dataResult.result().get()).getFirst()).exports;
        }
        catch (JsonParseException | IOException exception) {
            Blueprint.LOGGER.error("Error loading " + packType.getDirectory() + " Remolder settings, using default settings instead!", exception);
            exports = new RemoldingCompiler.ExportEntry[]{};
        }
        this.compiler = new RemoldingCompiler(this.getClass().getClassLoader(), exports);
    }

    public void reloadRemolders(CloseableResourceManager manager, Executor executor) {
        HashMap<String, IdentityHashMap<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>>> fileExtensionToEntries = this.fileExtensionToEntries;
        fileExtensionToEntries.clear();
        FileToIdConverter fileToIdConverter = FileToIdConverter.json((String)"remolders");
        Map resources = fileToIdConverter.listMatchingResources((ResourceManager)manager);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(resources.size());
        String packTypeDirectory = this.packType.getDirectory() + "/";
        AtomicInteger successfulCount = new AtomicInteger();
        for (Map.Entry entry : resources.entrySet()) {
            futures.add(CompletableFuture.runAsync(() -> {
                ResourceLocation entryKey = (ResourceLocation)entry.getKey();
                ResourceLocation entryId = fileToIdConverter.fileToId(entryKey);
                entryKey = ResourceLocation.fromNamespaceAndPath((String)entryKey.getNamespace(), (String)(packTypeDirectory + entryKey.getPath()));
                try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                    Remolding remolding;
                    JsonElement element = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                    DataResult remolderEntryDataResult = RemolderEntry.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    Optional remolderEntryError = remolderEntryDataResult.error();
                    if (remolderEntryError.isPresent()) {
                        throw new JsonParseException(((DataResult.Error)remolderEntryError.get()).message());
                    }
                    RemolderEntry remolderEntry = (RemolderEntry)((Pair)remolderEntryDataResult.result().get()).getFirst();
                    if (remolderEntry == RemolderEntry.NOOP) {
                        return;
                    }
                    ResourceSelector<?> pathSelector = remolderEntry.pathSelector().getResourceSelector();
                    if (pathSelector == EmptyResourceSelector.INSTANCE) {
                        return;
                    }
                    MoldingTypes.MoldingType<?> moldingType = remolderEntry.molding();
                    try {
                        remolding = this.compiler.compile(entryKey.toString(), moldingType.dataType(), moldingType.factory(), remolderEntry.remolder());
                    }
                    catch (Throwable throwable) {
                        throw new JsonParseException("Error while generating modifications for Remolder '" + String.valueOf(entryKey) + "': " + String.valueOf(throwable));
                    }
                    RemolderLoader remolderLoader = this;
                    synchronized (remolderLoader) {
                        for (String fileExtension : moldingType.fileExtensions()) {
                            Pair entries = fileExtensionToEntries.computeIfAbsent(fileExtension, __ -> new IdentityHashMap()).computeIfAbsent(moldingType, __ -> Pair.of(new HashMap(), new ArrayList()));
                            Either<Set<ResourceLocation>, Predicate<ResourceLocation>> either = pathSelector.select();
                            Optional locations = either.left();
                            Set<String> packs = remolderEntry.packs();
                            if (locations.isPresent()) {
                                Map directRemoldings = (Map)entries.getFirst();
                                Entry remoldingEntry = new Entry(packs == null ? s -> true : packs::contains, remolding);
                                ((Set)locations.get()).forEach(location -> directRemoldings.computeIfAbsent(location.toString(), __ -> new ArrayList()).add(remoldingEntry));
                                continue;
                            }
                            ((ArrayList)entries.getSecond()).add(Pair.of((Object)((Predicate)either.right().get()), (Object)new Entry(packs == null ? s -> true : packs::contains, remolding)));
                        }
                    }
                    successfulCount.getAndIncrement();
                }
                catch (JsonParseException | IOException | IllegalArgumentException exception) {
                    Blueprint.LOGGER.error("Couldn't load remolder file {} from {}", (Object)entryId, (Object)entryKey, (Object)exception);
                }
            }, executor));
        }
        CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).join();
        Blueprint.LOGGER.info("Successfully loaded {} {} remolders!", (Object)successfulCount.get(), (Object)this.packType.getDirectory());
    }

    @Nullable
    private Function<Resource, Resource> getResourceFunction(ResourceLocation location) {
        String extension;
        IdentityHashMap<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>> entriesForExtension;
        String locationString = location.toString();
        int lastIndexOfDot = locationString.lastIndexOf(46);
        if (lastIndexOfDot >= 0 && (entriesForExtension = this.fileExtensionToEntries.get(extension = locationString.substring(lastIndexOfDot + 1))) != null) {
            String locationWithoutExtension = locationString.substring(0, lastIndexOfDot);
            ResourceLocation resourceLocationWithoutExtension = ResourceLocation.parse((String)locationWithoutExtension);
            boolean foundNone = true;
            Pair[] typeEntries = new Pair[entriesForExtension.size()];
            int i = 0;
            for (Map.Entry<MoldingTypes.MoldingType<?>, Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>>> entry : entriesForExtension.entrySet()) {
                Pair<Map<String, List<Entry>>, ArrayList<Pair<Predicate<ResourceLocation>, Entry>>> value = entry.getValue();
                ArrayList indirectRemolders = (ArrayList)value.getSecond();
                ArrayList<Entry> entriesForLocation = (ArrayList<Entry>)((Map)value.getFirst()).get(locationWithoutExtension);
                if (!indirectRemolders.isEmpty()) {
                    entriesForLocation = entriesForLocation == null ? new ArrayList<Entry>() : new ArrayList(entriesForLocation);
                    for (Pair filterAndRemolding : indirectRemolders) {
                        if (!((Predicate)filterAndRemolding.getFirst()).test(resourceLocationWithoutExtension)) continue;
                        entriesForLocation.add((Entry)filterAndRemolding.getSecond());
                    }
                    if (entriesForLocation.isEmpty()) {
                        continue;
                    }
                } else if (entriesForLocation == null) continue;
                foundNone = false;
                typeEntries[i++] = Pair.of(entry.getKey(), entriesForLocation);
            }
            if (foundNone) {
                return null;
            }
            int finalI = i;
            return resource -> {
                for (int j = 0; j < finalI; ++j) {
                    Pair moldingTypeWithEntries = typeEntries[j];
                    resource = ((MoldingTypes.MoldingType)moldingTypeWithEntries.getFirst()).remold(locationWithoutExtension, (Resource)resource, (List)moldingTypeWithEntries.getSecond());
                }
                return resource;
            };
        }
        return null;
    }

    public Optional<Resource> getResource(ResourceLocation location, Optional<Resource> resource) {
        Function<Resource, Resource> function = this.getResourceFunction(location);
        if (function == null) {
            return resource;
        }
        return resource.map(function);
    }

    public List<Resource> getResourceStack(List<Resource> stack, ResourceLocation location) {
        Function<Resource, Resource> resourceFunction = this.getResourceFunction(location);
        if (resourceFunction == null) {
            return stack;
        }
        return new DataUtil.ReadMappedList<Resource>(stack, resourceFunction);
    }

    public Map<ResourceLocation, Resource> listResources(Map<ResourceLocation, Resource> map) {
        for (Map.Entry<ResourceLocation, Resource> entry : map.entrySet()) {
            Function<Resource, Resource> resourceFunction = this.getResourceFunction(entry.getKey());
            if (resourceFunction == null) continue;
            entry.setValue(resourceFunction.apply(entry.getValue()));
        }
        return map;
    }

    public Map<ResourceLocation, List<Resource>> listResourceStacks(Map<ResourceLocation, List<Resource>> map) {
        for (Map.Entry<ResourceLocation, List<Resource>> entry : map.entrySet()) {
            Function<Resource, Resource> resourceFunction = this.getResourceFunction(entry.getKey());
            if (resourceFunction == null) continue;
            entry.setValue(new DataUtil.ReadMappedList<Resource>(entry.getValue(), resourceFunction));
        }
        return map;
    }

    public record Settings(RemoldingCompiler.ExportEntry[] exports) {
        private static final Codec<RemoldingCompiler.ExportEntry[]> EXPORTS_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(map -> {
            Set entries = map.entrySet();
            if (entries.isEmpty()) {
                return new RemoldingCompiler.ExportEntry[0];
            }
            RemoldingCompiler.ExportEntry[] exports = new RemoldingCompiler.ExportEntry[entries.size()];
            int exportsCount = 0;
            for (Map.Entry entry : entries) {
                Pattern pattern = Pattern.compile(String.valueOf(entry.getValue()));
                exports[exportsCount++] = new RemoldingCompiler.ExportEntry((String)entry.getKey(), pattern.pattern(), string -> pattern.matcher((CharSequence)string).matches());
            }
            return exports;
        }, array -> Stream.of(array).collect(Collectors.toMap(RemoldingCompiler.ExportEntry::folder, RemoldingCompiler.ExportEntry::pattern)));
        public static final Codec<Settings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EXPORTS_CODEC.fieldOf("exports").forGetter(Settings::exports)).apply((Applicative)instance, Settings::new));
    }

    public record Entry(Predicate<String> packFilter, Remolding<?> remolding) {
    }
}

