/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.item;

import com.teamabnormals.blueprint.client.renderer.HasBlueprintBoatType;
import com.teamabnormals.blueprint.common.entity.BlueprintBoat;
import com.teamabnormals.blueprint.common.entity.BlueprintChestBoat;
import com.teamabnormals.blueprint.core.registry.BlueprintEntityTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlueprintBoatItem
extends Item {
    private static final Predicate<Entity> COLLISION_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final boolean hasChest;
    private final ResourceLocation type;

    public BlueprintBoatItem(boolean hasChest, ResourceLocation type, Item.Properties properties) {
        super(properties);
        this.hasChest = hasChest;
        this.type = type;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DispenserBoatBehavior(hasChest, type));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult hitResult = BlueprintBoatItem.getPlayerPOVHitResult((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.getType() == HitResult.Type.MISS) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        Vec3 vec3d = playerIn.getViewVector(1.0f);
        List list = level.getEntities((Entity)playerIn, playerIn.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), COLLISION_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec3d1 = playerIn.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec3d1)) continue;
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
        }
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            HasBlueprintBoatType boat = this.hasChest ? new BlueprintChestBoat(level, this.type, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z) : new BlueprintBoat(level, this.type, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z);
            boat.setYRot(playerIn.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox().inflate(-0.1))) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
            }
            if (!playerIn.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    static class DispenserBoatBehavior
    extends DefaultDispenseItemBehavior {
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
        private final boolean hasChest;
        private final ResourceLocation type;

        public DispenserBoatBehavior(boolean hasChest, ResourceLocation type) {
            this.hasChest = hasChest;
            this.type = type;
        }

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double d4;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel serverlevel = source.level();
            Vec3 vec3 = source.center();
            double d0 = 0.5625 + (double)((EntityType)BlueprintEntityTypes.BOAT.get()).getWidth() / 2.0;
            double d1 = vec3.x() + (double)direction.getStepX() * d0;
            double d2 = vec3.y() + (double)((float)direction.getStepY() * 1.125f);
            double d3 = vec3.z() + (double)direction.getStepZ() * d0;
            BlockPos blockpos = source.pos().relative(direction);
            HasBlueprintBoatType boat = this.hasChest ? new BlueprintChestBoat((Level)serverlevel, this.type, d1, d2, d3) : new BlueprintBoat((Level)serverlevel, this.type, d1, d2, d3);
            EntityType.createDefaultStackConfig((ServerLevel)serverlevel, (ItemStack)stack, null).accept(boat);
            boat.setYRot(direction.toYRot());
            if (boat.canBoatInFluid(serverlevel.getFluidState(blockpos))) {
                d4 = 1.0;
            } else {
                if (!serverlevel.getBlockState(blockpos).isAir() || !boat.canBoatInFluid(serverlevel.getFluidState(blockpos.below()))) {
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
                d4 = 0.0;
            }
            boat.setPos(d1, d2 + d4, d3);
            serverlevel.addFreshEntity((Entity)boat);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    }
}

