/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.blueprint.client.RewardHandler;
import com.teamabnormals.blueprint.client.model.SlabfishHatModel;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.BlueprintConfig;
import com.teamabnormals.blueprint.core.sonar.OnlineImageCache;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class SlabfishHatRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public static OnlineImageCache REWARD_CACHE = new OnlineImageCache("blueprint", 1L, TimeUnit.DAYS);
    private final SlabfishHatModel model = new SlabfishHatModel(SlabfishHatModel.createBodyModel().bakeRoot());

    public SlabfishHatRenderLayer(PlayerRenderer renderer) {
        super((RenderLayerParent)renderer);
    }

    public void render(PoseStack stack, MultiBufferSource source, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (BlueprintConfig.CLIENT.disableSlabfishHats) {
            return;
        }
        RewardHandler.RewardProperties properties = RewardHandler.getRewardProperties();
        if (properties == null) {
            return;
        }
        RewardHandler.RewardProperties.SlabfishProperties slabfishProperties = properties.getSlabfishProperties();
        if (slabfishProperties == null) {
            return;
        }
        String defaultTypeUrl = slabfishProperties.getDefaultTypeUrl();
        IDataManager data = (IDataManager)entity;
        if (entity.isInvisible() || entity.isSpectator() || !RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.ENABLED) || defaultTypeUrl == null || !RewardHandler.REWARDS.containsKey(entity.getUUID())) {
            return;
        }
        RewardHandler.RewardData reward = RewardHandler.REWARDS.get(entity.getUUID());
        if (reward.getSlabfish() == null || reward.getTier() < 2) {
            return;
        }
        RewardHandler.RewardData.SlabfishData slabfish = reward.getSlabfish();
        ResourceLocation typeLocation = REWARD_CACHE.requestTexture(reward.getTier() >= 4 && slabfish.getTypeUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.TYPE) ? slabfish.getTypeUrl() : defaultTypeUrl).getNow(null);
        if (typeLocation == null) {
            return;
        }
        ResourceLocation sweaterLocation = reward.getTier() >= 3 && slabfish.getSweaterUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.SWEATER) ? (ResourceLocation)REWARD_CACHE.requestTexture(slabfish.getSweaterUrl()).getNow(null) : null;
        ResourceLocation backpackLocation = slabfish.getBackpackUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.BACKPACK) ? (ResourceLocation)REWARD_CACHE.requestTexture(slabfish.getBackpackUrl()).getNow(null) : null;
        ModelPart body = this.model.body;
        ModelPart backpack = this.model.backpack;
        body.copyFrom(((PlayerModel)this.getParentModel()).head);
        body.render(stack, source.getBuffer(slabfish.isTranslucent() ? RenderType.entityTranslucent((ResourceLocation)typeLocation) : RenderType.entityCutout((ResourceLocation)typeLocation)), packedLight, OverlayTexture.NO_OVERLAY);
        if (sweaterLocation != null) {
            body.render(stack, source.getBuffer(RenderType.entityCutout((ResourceLocation)sweaterLocation)), packedLight, OverlayTexture.NO_OVERLAY);
        }
        if (backpackLocation != null) {
            backpack.copyFrom(body);
            backpack.render(stack, source.getBuffer(RenderType.entityCutout((ResourceLocation)backpackLocation)), packedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

