/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.util.math.CircularGridUtils;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.FairRingIterator;
import net.mehvahdjukaar.supplementaries.common.worldgen.LocatedStructure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureLocator {
    @Nullable
    public static LocatedStructure findNearestStructure(ServerLevel level, @NotNull HolderSet<Structure> targetStructures, BlockPos searchCenter, int maximumChunkSearchRadius, boolean findNewlyGeneratedOnly, int maxStructuresToConsider, boolean stopSearchWhenFound) {
        List<LocatedStructure> foundStructures = StructureLocator.findNearestStructures(level, targetStructures, searchCenter, maximumChunkSearchRadius, findNewlyGeneratedOnly, 1, maxStructuresToConsider, stopSearchWhenFound);
        if (!foundStructures.isEmpty()) {
            return foundStructures.get(0);
        }
        return null;
    }

    public static List<LocatedStructure> findNearestStructures(ServerLevel level, @NotNull TagKey<Structure> structureTag, BlockPos searchCenter, int maximumChunkSearchRadius, boolean findNewlyGeneratedOnly, int requiredStructureCount, int maxStructuresToConsider, boolean stopSearchWhenFound) {
        HolderSet targetStructures = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(structureTag).orElse(null);
        return StructureLocator.findNearestStructures(level, (HolderSet<Structure>)targetStructures, searchCenter, maximumChunkSearchRadius, findNewlyGeneratedOnly, requiredStructureCount, maxStructuresToConsider, stopSearchWhenFound);
    }

    public static List<LocatedStructure> findNearestStructures(ServerLevel level, HolderSet<Structure> targetStructureSet, BlockPos searchCenter, int maximumChunkSearchRadius, boolean findNewlyGeneratedOnly, int requiredStructureCount, int maxStructuresToConsider, boolean stopSearchWhenFound) {
        if (targetStructureSet == null) {
            return List.of();
        }
        if (targetStructureSet.size() > maxStructuresToConsider) {
            ArrayList structureList = new ArrayList(targetStructureSet.stream().toList());
            Collections.shuffle(structureList);
            targetStructureSet = HolderSet.direct(structureList.subList(0, maxStructuresToConsider));
        }
        List<LocatedStructure> foundStructures = new ArrayList<LocatedStructure>();
        if (!level.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return foundStructures;
        }
        if (targetStructureSet.size() == 0) {
            Supplementaries.LOGGER.error("Found empty target structures for structure map. It's likely some mod broke some vanilla tag. Check your logs!");
            return foundStructures;
        }
        List selectedStructures = targetStructureSet.stream().toList();
        ChunkGenerator chunkGenerator = level.getChunkSource().getGenerator();
        double closestDistanceSquared = Double.MAX_VALUE;
        selectedStructures = new ArrayList(selectedStructures);
        Collections.shuffle(selectedStructures);
        Supplementaries.LOGGER.info("Searching for closest structure among {} from position {}", (Object)Arrays.toString(selectedStructures.stream().map(Holder::getRegisteredName).toArray()), (Object)searchCenter);
        Object2ObjectArrayMap structuresByPlacement = new Object2ObjectArrayMap();
        ChunkGeneratorStructureState structureState = level.getChunkSource().getGeneratorState();
        for (Holder structureHolder : selectedStructures) {
            for (StructurePlacement structurePlacement : structureState.getPlacementsForStructure(structureHolder)) {
                structuresByPlacement.computeIfAbsent(structurePlacement, p -> new ObjectArraySet()).add(structureHolder);
            }
        }
        if (structuresByPlacement.isEmpty()) {
            return foundStructures;
        }
        Int2ObjectAVLTreeMap spreadToStructures = new Int2ObjectAVLTreeMap();
        StructureManager structureManager = level.structureManager();
        for (Map.Entry entry : structuresByPlacement.entrySet()) {
            StructurePlacement placement = (StructurePlacement)entry.getKey();
            if (placement instanceof ConcentricRingsStructurePlacement) {
                double distanceSquared;
                ConcentricRingsStructurePlacement ringsPlacement = (ConcentricRingsStructurePlacement)placement;
                Pair foundStructurePair = chunkGenerator.getNearestGeneratedStructure((Set)entry.getValue(), level, structureManager, searchCenter, findNewlyGeneratedOnly, ringsPlacement);
                if (foundStructurePair == null || !((distanceSquared = searchCenter.distSqr((Vec3i)foundStructurePair.getFirst())) < closestDistanceSquared)) continue;
                closestDistanceSquared = distanceSquared;
                foundStructures.add(new LocatedStructure((BlockPos)foundStructurePair.getFirst(), (Holder<Structure>)((Holder)foundStructurePair.getSecond()), null, distanceSquared));
                continue;
            }
            if (!(placement instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement randomPlacement = (RandomSpreadStructurePlacement)placement;
            int spacing = randomPlacement.spacing();
            List list = (List)spreadToStructures.computeIfAbsent(spacing, s -> new ArrayList());
            for (Holder struct : (Set)entry.getValue()) {
                list.add(new StructureAndPlacement((Holder<Structure>)struct, randomPlacement));
            }
        }
        if (!spreadToStructures.isEmpty()) {
            int centerChunkX = SectionPos.blockToSectionCoord((int)searchCenter.getX());
            int n = SectionPos.blockToSectionCoord((int)searchCenter.getZ());
            long worldSeed = level.getSeed();
            StructureManager manager = level.structureManager();
            FairRingIterator ringIterator = new FairRingIterator(new ArrayList<Integer>((Collection<Integer>)spreadToStructures.keySet()), maximumChunkSearchRadius, true);
            int lastIteration = 0;
            ArrayList<Pair<ChunkPos, StructureAndPlacement>> candidatePosThisIteration = new ArrayList<Pair<ChunkPos, StructureAndPlacement>>();
            block4: while (ringIterator.hasNext()) {
                boolean useLessPreciseSearch;
                FairRingIterator.Ring ring = ringIterator.next();
                int gridScale = ring.gridSize();
                List placementsInGrid = (List)spreadToStructures.get(gridScale);
                int radius = ring.radius();
                boolean bl = useLessPreciseSearch = stopSearchWhenFound || radius * 16 > 2000;
                if (lastIteration != ring.commonIterationsIndex()) {
                    lastIteration = ring.commonIterationsIndex();
                    StructureLocator.flushCandidates(level, searchCenter, findNewlyGeneratedOnly, candidatePosThisIteration, manager, foundStructures);
                    if (foundStructures.size() >= requiredStructureCount) break;
                }
                Iterator cellsInRing = CircularGridUtils.iterateInRing((int)0, (int)0, (int)radius, (int)gridScale);
                while (cellsInRing.hasNext()) {
                    Vec2i cell = (Vec2i)cellsInRing.next();
                    for (StructureAndPlacement placementInfo : placementsInGrid) {
                        RandomSpreadStructurePlacement placement = placementInfo.placement;
                        Holder<Structure> structure = placementInfo.structure;
                        int potentialChunkX = centerChunkX + cell.x();
                        int potentialChunkZ = n + cell.y();
                        ChunkPos structureChunk = placement.getPotentialStructureChunk(worldSeed, potentialChunkX, potentialChunkZ);
                        candidatePosThisIteration.add((Pair<ChunkPos, StructureAndPlacement>)Pair.of((Object)structureChunk, (Object)new StructureAndPlacement(structure, placement)));
                    }
                    if (!useLessPreciseSearch) continue;
                    StructureLocator.flushCandidates(level, searchCenter, findNewlyGeneratedOnly, candidatePosThisIteration, manager, foundStructures);
                    if (foundStructures.size() < requiredStructureCount) continue;
                    break block4;
                }
            }
            StructureLocator.flushCandidates(level, searchCenter, findNewlyGeneratedOnly, candidatePosThisIteration, manager, foundStructures);
        }
        foundStructures.sort(Comparator.comparingDouble(LocatedStructure::distSqrt));
        if (foundStructures.size() >= requiredStructureCount) {
            foundStructures = (List)Lists.partition(foundStructures, (int)requiredStructureCount).getFirst();
        }
        if (findNewlyGeneratedOnly) {
            for (LocatedStructure locatedStructure : foundStructures) {
                if (locatedStructure.start() == null || !locatedStructure.start().canBeReferenced()) continue;
                structureManager.addReference(locatedStructure.start());
            }
        }
        Supplementaries.LOGGER.info("\n Structure locator found {} structures: \n{}", (Object)foundStructures.size(), (Object)String.join((CharSequence)"\n", (CharSequence[])foundStructures.stream().map(LocatedStructure::toString).toArray(CharSequence[]::new)));
        return foundStructures;
    }

    private static void flushCandidates(ServerLevel level, BlockPos searchCenter, boolean findNewlyGeneratedOnly, List<Pair<ChunkPos, StructureAndPlacement>> candidatePosThisIteration, StructureManager manager, List<LocatedStructure> found) {
        Iterator<Pair<ChunkPos, StructureAndPlacement>> iterator = candidatePosThisIteration.iterator();
        while (iterator.hasNext()) {
            Pair<ChunkPos, StructureAndPlacement> entry;
            Holder<Structure> structure = ((StructureAndPlacement)entry.getSecond()).structure;
            RandomSpreadStructurePlacement placement = ((StructureAndPlacement)entry.getSecond()).placement;
            entry = iterator.next();
            ChunkPos chunkPos = (ChunkPos)entry.getFirst();
            LocatedStructure located = StructureLocator.getStructureThatWillSpawnAt(structure, (LevelReader)level, manager, findNewlyGeneratedOnly, placement, chunkPos, searchCenter);
            if (located == null) continue;
            found.add(located);
        }
        candidatePosThisIteration.clear();
    }

    @Nullable
    private static LocatedStructure getStructureThatWillSpawnAt(Holder<Structure> targetStructures, LevelReader level, StructureManager structureManager, boolean skipKnownStructures, RandomSpreadStructurePlacement placement, ChunkPos chunkPosition, BlockPos searchCenter) {
        LocatedStructure foundStructures = null;
        StructureCheckResult checkResult = structureManager.checkStructurePresence(chunkPosition, (Structure)targetStructures.value(), (StructurePlacement)placement, skipKnownStructures);
        if (checkResult != StructureCheckResult.START_NOT_PRESENT) {
            if (!skipKnownStructures && checkResult == StructureCheckResult.START_PRESENT) {
                foundStructures = LocatedStructure.relativeTo(placement.getLocatePos(chunkPosition), targetStructures, null, searchCenter);
            } else {
                ChunkAccess chunk = level.getChunk(chunkPosition.x, chunkPosition.z, ChunkStatus.STRUCTURE_STARTS);
                StructureStart structureStart = structureManager.getStartForStructure(SectionPos.bottomOf((ChunkAccess)chunk), (Structure)targetStructures.value(), (StructureAccess)chunk);
                if (structureStart != null && structureStart.isValid() && (!skipKnownStructures || structureStart.canBeReferenced())) {
                    foundStructures = LocatedStructure.relativeTo(placement.getLocatePos(structureStart.getChunkPos()), targetStructures, structureStart, searchCenter);
                }
            }
        }
        if (foundStructures != null) {
            // empty if block
        }
        return foundStructures;
    }

    @Nullable
    public BlockPos findRandomStructure(TagKey<Structure> structureTag, BlockPos searchCenter, int searchRadius, boolean findUnexploredOnly, ServerLevel level) {
        if (!level.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return null;
        }
        Optional structureSet = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(structureTag);
        if (structureSet.isEmpty()) {
            return null;
        }
        HolderSet.Named structures = (HolderSet.Named)structureSet.get();
        List structureList = structures.stream().toList();
        Holder chosenStructure = (Holder)structureList.get(level.random.nextInt(structureList.size()));
        Pair foundPair = level.getChunkSource().getGenerator().findNearestMapStructure(level, (HolderSet)HolderSet.direct((Holder[])new Holder[]{chosenStructure}), searchCenter, searchRadius, findUnexploredOnly);
        return foundPair != null ? (BlockPos)foundPair.getFirst() : null;
    }

    private record StructureAndPlacement(Holder<Structure> structure, RandomSpreadStructurePlacement placement) {
    }
}

