/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SafeRecipe
extends CustomRecipe {
    private final Ingredient requiredShulker;
    private final Ingredient requiredIngot;

    public SafeRecipe(CraftingBookCategory category, Ingredient shulker, Ingredient ingot) {
        super(category);
        this.requiredShulker = shulker;
        this.requiredIngot = ingot;
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack shulker = null;
        ItemStack netherite = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.requiredShulker.test(stack)) {
                if (shulker != null) {
                    return false;
                }
                shulker = stack;
                continue;
            }
            if (this.requiredIngot.test(stack)) {
                if (netherite != null) {
                    return false;
                }
                netherite = stack;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return shulker != null && netherite != null;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack shulker = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!this.requiredShulker.test(stack)) continue;
            shulker = stack;
            break;
        }
        return shulker.transmuteCopy((ItemLike)ModRegistry.SAFE_ITEM.get(), 1);
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.SAFE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SafeRecipe> {
        private static final MapCodec<SafeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("shulker").forGetter(recipe -> recipe.requiredShulker), (App)Ingredient.CODEC.fieldOf("ingot").forGetter(recipe -> recipe.requiredIngot)).apply((Applicative)instance, SafeRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SafeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.requiredShulker, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.requiredIngot, SafeRecipe::new);

        public MapCodec<SafeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SafeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

