/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonSpecialItemRenderer;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.items.SongInstrumentItem;
import net.mehvahdjukaar.supplementaries.common.items.components.FluteTargets;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FluteItem
extends SongInstrumentItem
implements IThirdPersonAnimationProvider,
IThirdPersonSpecialItemRenderer,
IFirstPersonAnimationProvider {
    public FluteItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isValidRepairItem(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.is(Items.BAMBOO);
    }

    public boolean isFoil(ItemStack pStack) {
        FluteTargets flutePet = (FluteTargets)pStack.get(ModComponents.FLUTE_PETS.get());
        return flutePet != null || super.isFoil(pStack);
    }

    public static boolean interactWithPet(ItemStack stack, Player player, Entity target, InteractionHand hand) {
        TamableAnimal animal;
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (target instanceof TamableAnimal && (animal = (TamableAnimal)target).isTame() && animal.getOwnerUUID().equals(player.getUUID()) || target.getType().is(ModTags.FLUTE_PET)) {
            Fox fox;
            AbstractHorse horse;
            if (target instanceof AbstractHorse && !(horse = (AbstractHorse)target).isTamed()) {
                return false;
            }
            if (target instanceof Fox && !(fox = (Fox)target).trusts(player.getUUID())) {
                return false;
            }
            FluteTargets flutePets = (FluteTargets)stack.getOrDefault(ModComponents.FLUTE_PETS.get(), (Object)FluteTargets.of(target));
            if (flutePets.size() > 5) {
                player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.flute"), true);
            } else {
                flutePets = flutePets.andAdd(target);
                stack.set(ModComponents.FLUTE_PETS.get(), (Object)flutePets);
                player.setItemInHand(hand, stack);
                player.getCooldowns().addCooldown(stack.getItem(), 20);
            }
            return true;
        }
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand handIn) {
        super.use(level, player, handIn);
        ItemStack stack = player.getItemInHand(handIn);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            int r = CommonConfigs.Tools.FLUTE_RADIUS.get();
            FluteTargets fluteTargets = (FluteTargets)stack.get(ModComponents.FLUTE_PETS.get());
            if (fluteTargets != null) {
                for (Entity entity : fluteTargets.getEntities(serverLevel)) {
                    LivingEntity pet;
                    int maxDist = CommonConfigs.Tools.FLUTE_DISTANCE.get() * CommonConfigs.Tools.FLUTE_DISTANCE.get();
                    if (!(entity instanceof LivingEntity) || (pet = (LivingEntity)entity).level() != player.level() || !(pet.distanceToSqr((Entity)player) < (double)maxDist) || !pet.randomTeleport(x, y, z, false)) continue;
                    pet.stopSleeping();
                }
                player.getCooldowns().addCooldown((Item)this, 20);
            } else if (CommonConfigs.Tools.FLUTE_UNBOUND.get().booleanValue()) {
                AABB bb = new AABB(x - (double)r, y - (double)r, z - (double)r, x + (double)r, y + (double)r, z + (double)r);
                List entities = level.getEntities((Entity)player, bb, TamableAnimal.class::isInstance);
                for (Entity e : entities) {
                    TamableAnimal pet = (TamableAnimal)e;
                    if (!pet.isTame() || pet.isOrderedToSit() || !pet.getOwnerUUID().equals(player.getUUID())) continue;
                    pet.randomTeleport(x, y, z, false);
                }
                player.getCooldowns().addCooldown((Item)this, 20);
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    @Override
    public void releaseUsing(ItemStack stack, Level pLevel, LivingEntity entity, int pTimeCharged) {
        super.releaseUsing(stack, pLevel, entity, pTimeCharged);
        stack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        FluteTargets flutePet = (FluteTargets)stack.get(ModComponents.FLUTE_PETS.get());
        if (flutePet != null) {
            flutePet.addToTooltip(context, tooltipComponents::add, tooltipFlag);
        }
    }

    @Override
    public void spawnNoteParticle(Level level, LivingEntity entity, int note) {
        if (!ClientConfigs.Items.FLUTE_PARTICLES.get().booleanValue()) {
            return;
        }
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float xRot = -entity.getXRot() * ((float)Math.PI / 180);
        float yRot = -Mth.wrapDegrees((float)entity.yHeadRot) * ((float)Math.PI / 180);
        bx = bx.xRot(xRot).yRot(yRot);
        by = by.xRot(xRot).yRot(yRot);
        bz = bz.xRot(xRot).yRot(yRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 0.28 + (double)level.random.nextFloat() * 0.5);
        int mirror = entity.getMainArm() == HumanoidArm.RIGHT ^ entity.getUsedItemHand() == InteractionHand.MAIN_HAND ? -1 : 1;
        armVec = armVec.yRot((float)(-1.5707963267948966 * (double)mirror)).add(0.0, 0.15, 0.1);
        Vec3 newV = bx.scale(armVec.x).add(by.scale(armVec.y)).add(bz.scale(armVec.z));
        double x = entity.getX() + newV.x;
        double y = entity.getEyeY() + newV.y;
        double z = entity.getZ() + newV.z;
        SimpleParticleType particle = entity.isUnderWater() ? ParticleTypes.BUBBLE : ParticleTypes.NOTE;
        level.addParticle((ParticleOptions)particle, x, y, z, (double)level.random.nextInt(24) / 24.0, 0.0, 0.0);
    }

    public void animateItemFirstPerson(Player player, ItemStack stack, InteractionHand hand, HumanoidArm arm, PoseStack poseStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (player.isUsingItem() && player.getUseItemRemainingTicks() > 0 && player.getUsedItemHand() == hand) {
            int mirror = player.getMainArm() == HumanoidArm.RIGHT ^ hand == InteractionHand.MAIN_HAND ? -1 : 1;
            poseStack.translate(-0.4 * (double)mirror, 0.2, 0.0);
            float timeLeft = (float)stack.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTicks + 1.0f);
            float sin = Mth.sin((float)((timeLeft - 0.1f) * 1.3f));
            poseStack.translate(0.0f, sin * 0.0038f, 0.0f);
            poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
            poseStack.scale(1.0f * (float)mirror, -1.0f * (float)mirror, -1.0f);
        }
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, false);
            return true;
        }
        return false;
    }

    public boolean isTwoHanded() {
        return true;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, true);
            return true;
        }
        return false;
    }

    private <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity, boolean leftHand) {
        ModelPart mainHand = leftHand ? model.leftArm : model.rightArm;
        ModelPart offHand = leftHand ? model.rightArm : model.leftArm;
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float headXRot = MthUtils.wrapRad((float)model.head.xRot);
        float headYRot = MthUtils.wrapRad((float)model.head.yRot);
        float downFacingRot = Mth.clamp((float)headXRot, (float)0.0f, (float)0.8f);
        float xRot = FluteItem.getMaxHeadXRot(headXRot) - (entity.isCrouching() ? 1.0f : 0.0f) - 0.3f + downFacingRot * 0.5f;
        bx = bx.xRot(xRot);
        by = by.xRot(xRot);
        bz = bz.xRot(xRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 1.0);
        float mirror = leftHand ? -1.0f : 1.0f;
        armVec = armVec.yRot(-0.99f * mirror);
        Vec3 newV = bx.scale(armVec.x).add(by.scale(armVec.y)).add(bz.scale(armVec.z));
        float yaw = (float)Math.atan2(-newV.x, newV.z);
        float len = (float)newV.length();
        float pitch = (float)Math.asin(newV.y / (double)len);
        mainHand.yRot = yaw + headYRot * 1.4f - 0.1f * mirror - 0.5f * downFacingRot * mirror;
        mainHand.xRot = (float)((double)pitch - 1.5707963267948966);
        offHand.yRot = (float)Mth.clamp((double)((double)(MthUtils.wrapRad((float)mainHand.yRot) - 1.0f * mirror) * 0.2), (double)-0.15, (double)0.15) + 1.1f * mirror;
        offHand.xRot = MthUtils.wrapRad((float)(mainHand.xRot - 0.06f));
        float offset = leftHand ? -Mth.clamp((float)headYRot, (float)-1.0f, (float)0.0f) : Mth.clamp((float)headYRot, (float)0.0f, (float)1.0f);
        mainHand.z = -offset * 0.95f;
        AnimationUtils.bobModelPart((ModelPart)model.leftArm, (float)entity.tickCount, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)model.rightArm, (float)entity.tickCount, (float)-1.0f);
    }

    public static float getMaxHeadXRot(float xRot) {
        return Mth.clamp((float)xRot, (float)-1.2566371f, (float)1.5707964f);
    }

    public <T extends Player, M extends EntityModel<T> & HeadedModel> void renderThirdPersonItem(M parentModel, LivingEntity entity, ItemStack stack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!stack.isEmpty()) {
            ItemDisplayContext transform;
            boolean leftHand;
            poseStack.pushPose();
            boolean bl = leftHand = humanoidArm == HumanoidArm.LEFT;
            if (entity.getUseItem() == stack) {
                ModelPart head = ((HeadedModel)parentModel).getHead();
                float oldRot = head.xRot;
                head.xRot = FluteItem.getMaxHeadXRot(MthUtils.wrapRad((float)oldRot));
                head.translateAndRotate(poseStack);
                head.xRot = oldRot;
                CustomHeadLayer.translateToHead((PoseStack)poseStack, (boolean)false);
                poseStack.translate(0.0, -0.265625, -0.53125);
                if (leftHand) {
                    poseStack.mulPose(RotHlpr.XN90);
                }
                transform = ItemDisplayContext.HEAD;
            } else {
                ((ArmedModel)parentModel).translateToHand(humanoidArm, poseStack);
                poseStack.mulPose(RotHlpr.XN90);
                poseStack.mulPose(RotHlpr.Y180);
                poseStack.translate((double)((float)(leftHand ? -1 : 1) / 16.0f), 0.125, -0.625);
                transform = leftHand ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            }
            Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderItem(entity, stack, transform, leftHand, poseStack, bufferSource, light);
            poseStack.popPose();
        }
    }
}

