/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WickerFenceBlock
extends WaterBlock {
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.WEST_WALL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape NORTH_TEST = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH_WALL);
        enumMap.put(Direction.EAST, EAST_WALL);
        enumMap.put(Direction.SOUTH, SOUTH_WALL);
        enumMap.put(Direction.WEST, WEST_WALL);
    })));

    public WickerFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH_WALL, (Comparable)WallSide.NONE)).setValue(EAST_WALL, (Comparable)WallSide.NONE)).setValue(SOUTH_WALL, (Comparable)WallSide.NONE)).setValue(WEST_WALL, (Comparable)WallSide.NONE));
        this.shapeByIndex = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(1.0f, 1.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.or((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallSide.LOW ? Shapes.or((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) {
        float f = 8.0f - width;
        float g = 8.0f + width;
        float h = 8.0f - depth;
        float i = 8.0f + depth;
        VoxelShape postShape = Block.box((double)f, (double)0.0, (double)f, (double)g, (double)wallPostHeight, (double)g);
        VoxelShape northShape = Block.box((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallLowHeight, (double)i);
        VoxelShape southShape = Block.box((double)h, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)16.0);
        VoxelShape westShape = Block.box((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)i);
        VoxelShape eastShape = Block.box((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallLowHeight, (double)i);
        VoxelShape northShapeTall = Block.box((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallTallHeight, (double)i);
        VoxelShape southShapeTall = Block.box((double)h, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)16.0);
        VoxelShape weastShapeTall = Block.box((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)i);
        VoxelShape eastShapeTall = Block.box((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallTallHeight, (double)i);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WallSide east : EAST_WALL.getPossibleValues()) {
            for (WallSide north : NORTH_WALL.getPossibleValues()) {
                for (WallSide west : WEST_WALL.getPossibleValues()) {
                    for (WallSide south : SOUTH_WALL.getPossibleValues()) {
                        VoxelShape conbinedShape = Shapes.empty();
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, east, eastShape, eastShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, west, westShape, weastShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, north, northShape, northShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, south, southShape, southShapeTall);
                        conbinedShape = Shapes.or((VoxelShape)conbinedShape, (VoxelShape)postShape);
                        BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(EAST_WALL, (Comparable)east)).setValue(WEST_WALL, (Comparable)west)).setValue(NORTH_WALL, (Comparable)north)).setValue(SOUTH_WALL, (Comparable)south);
                        builder.put((Object)((BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)conbinedShape);
                        builder.put((Object)((BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)conbinedShape);
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex.get(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.collisionShapeByIndex.get(state);
    }

    private boolean connectsTo(BlockState state, boolean sideSolid, Direction direction) {
        Block block = state.getBlock();
        boolean fenceGate = block instanceof FenceGateBlock && FenceGateBlock.connectsToDirection((BlockState)state, (Direction)direction);
        return state.is((Block)this) || !WickerFenceBlock.isExceptionForConnection((BlockState)state) && sideSolid || block instanceof IronBarsBlock || fenceGate;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level levelReader = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState state = super.getStateForPlacement(context);
        return this.allUpdate(state, blockPos, (LevelReader)levelReader);
    }

    @NotNull
    private BlockState allUpdate(BlockState state, BlockPos blockPos, LevelReader levelReader) {
        BlockPos northPos = blockPos.north();
        BlockPos eastPos = blockPos.east();
        BlockPos southPos = blockPos.south();
        BlockPos westPos = blockPos.west();
        BlockPos abovePos = blockPos.above();
        BlockState northState = levelReader.getBlockState(northPos);
        BlockState eastState = levelReader.getBlockState(eastPos);
        BlockState southState = levelReader.getBlockState(southPos);
        BlockState westState = levelReader.getBlockState(westPos);
        BlockState aboveState = levelReader.getBlockState(abovePos);
        boolean north = this.connectsTo(northState, northState.isFaceSturdy((BlockGetter)levelReader, northPos, Direction.SOUTH), Direction.SOUTH);
        boolean east = this.connectsTo(eastState, eastState.isFaceSturdy((BlockGetter)levelReader, eastPos, Direction.WEST), Direction.WEST);
        boolean south = this.connectsTo(southState, southState.isFaceSturdy((BlockGetter)levelReader, southPos, Direction.NORTH), Direction.NORTH);
        boolean weast = this.connectsTo(westState, westState.isFaceSturdy((BlockGetter)levelReader, westPos, Direction.EAST), Direction.EAST);
        if (!(east || weast || north || south)) {
            BlockState belowState = levelReader.getBlockState(blockPos.below());
            if (belowState.is((Block)this)) {
                east = belowState.getValue(EAST_WALL) != WallSide.NONE;
                weast = belowState.getValue(WEST_WALL) != WallSide.NONE;
                north = belowState.getValue(NORTH_WALL) != WallSide.NONE;
                south = belowState.getValue(SOUTH_WALL) != WallSide.NONE;
            } else {
                east = true;
                weast = true;
                north = true;
                south = true;
            }
        }
        return this.getCorrectShape(levelReader, state, abovePos, aboveState, north, east, south, weast);
    }

    private BlockState getCorrectShape(LevelReader level, BlockState state, BlockPos pos, BlockState upState, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection) {
        VoxelShape voxelShape = upState.getCollisionShape((BlockGetter)level, pos).getFaceShape(Direction.DOWN);
        return this.updateSides(state, northConnection, eastConnection, southConnection, westConnection, voxelShape);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        state = super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
        return switch (direction) {
            case Direction.DOWN -> this.allUpdate(state, currentPos, (LevelReader)level);
            case Direction.UP -> this.topUpdate((LevelReader)level, state, neighborPos, neighborState);
            default -> this.allUpdate(state, currentPos, (LevelReader)level);
        };
    }

    private static boolean isConnected(BlockState state, Property<WallSide> heightProperty) {
        return state.getValue(heightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape firstShape, VoxelShape secondShape) {
        return !Shapes.joinIsNotEmpty((VoxelShape)secondShape, (VoxelShape)firstShape, (BooleanOp)BooleanOp.ONLY_FIRST);
    }

    private BlockState topUpdate(LevelReader level, BlockState state, BlockPos pos, BlockState secondState) {
        boolean north = WickerFenceBlock.isConnected(state, NORTH_WALL);
        boolean east = WickerFenceBlock.isConnected(state, EAST_WALL);
        boolean south = WickerFenceBlock.isConnected(state, SOUTH_WALL);
        boolean west = WickerFenceBlock.isConnected(state, WEST_WALL);
        return this.getCorrectShape(level, state, pos, secondState, north, east, south, west);
    }

    private BlockState updateSides(BlockState state, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, VoxelShape wallShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)this.makeWallState(northConnection, wallShape, NORTH_TEST))).setValue(EAST_WALL, (Comparable)this.makeWallState(eastConnection, wallShape, EAST_TEST))).setValue(SOUTH_WALL, (Comparable)this.makeWallState(southConnection, wallShape, SOUTH_TEST))).setValue(WEST_WALL, (Comparable)this.makeWallState(westConnection, wallShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean allowConnection, VoxelShape shape, VoxelShape neighbourShape) {
        if (allowConnection) {
            return WickerFenceBlock.isCovered(shape, neighbourShape) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(NORTH_WALL, (Comparable)((WallSide)state.getValue(SOUTH_WALL)))).setValue(SOUTH_WALL, (Comparable)((WallSide)state.getValue(NORTH_WALL)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(EAST_WALL, (Comparable)((WallSide)state.getValue(WEST_WALL)))).setValue(WEST_WALL, (Comparable)((WallSide)state.getValue(EAST_WALL)));
            default -> super.mirror(state, mirror);
        };
    }
}

