/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MovingSlidyBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class SlidyBlock
extends FallingBlock
implements IPistonMotionReact {
    public static final MapCodec<SlidyBlock> CODEC = SlidyBlock.simpleCodec(SlidyBlock::new);
    public static final BooleanProperty ON_PRESSURE_PLATE = ModBlockProperties.ON_PRESSURE_PLATE;

    public SlidyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ON_PRESSURE_PLATE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public void onMagnetMoved(Level level, BlockPos blockPos, Direction direction, BlockState blockState, BlockEntity blockEntity) {
        this.onMoved(level, blockPos, blockState, direction, false);
    }

    public void onMoved(Level level, BlockPos pos, BlockState movedState, Direction direction, boolean extending) {
        if (level.getBlockState(pos.below()).is(BlockTags.ICE)) {
            for (Direction dir : Direction.values()) {
                if (!SuppPlatformStuff.canStickTo(movedState, level.getBlockState(pos.relative(dir)))) continue;
                return;
            }
            MovingSlidyBlock.maybeMove(movedState, level, pos, direction);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ON_PRESSURE_PLATE});
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return 0x888877;
    }

    protected void falling(FallingBlockEntity entity) {
        entity.setHurtsEntities(1.0f, 10);
    }

    public static boolean canFall(BlockPos pos, LevelAccessor world) {
        return (world.isEmptyBlock(pos.below()) || SlidyBlock.isFree((BlockState)world.getBlockState(pos.below()))) && pos.getY() >= world.getMinBuildHeight() && !IRopeConnection.isSupportingCeiling(pos.above(), (LevelReader)world) && !SlidyBlock.hasHoneyAround(pos, world);
    }

    private static boolean hasHoneyAround(BlockPos pos, LevelAccessor world) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!world.getBlockState(pos.relative(dir)).is(Blocks.HONEY_BLOCK)) continue;
            return true;
        }
        return false;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (SlidyBlock.canFall(pos, (LevelAccessor)level)) {
            FallingBlockEntity entity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
            this.falling(entity);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public void onLand(Level level, BlockPos pos, BlockState state, BlockState state1, FallingBlockEntity blockEntity) {
        super.onLand(level, pos, state, state1, blockEntity);
        if (!blockEntity.isSilent()) {
            level.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (hitResult.getDirection().getAxis() == Direction.Axis.Y) {
            return InteractionResult.PASS;
        }
        if (MovingSlidyBlock.maybeMove(state, level, pos, hitResult.getDirection().getOpposite())) {
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_ACTIVATE, pos);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }
}

