/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.NoticeBoardBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NoticeBoardBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.HAS_BOOK;
    public static final BooleanProperty CULLED = ModBlockProperties.CULLED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public NoticeBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CULLED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_BOOK, CULLED, POWERED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        BlockPos facingPos;
        Direction dir = context.getHorizontalDirection().getOpposite();
        Level level = context.getLevel();
        BlockState facingState = level.getBlockState(facingPos = (pos = context.getClickedPos()).relative(dir));
        boolean culled = facingState.isSolidRender((BlockGetter)level, pos) && facingState.isFaceSturdy((BlockGetter)level, facingPos, dir.getOpposite());
        boolean powered = level.getBestNeighborSignal(pos) > 0;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue((Property)CULLED, (Comparable)Boolean.valueOf(culled))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NoticeBoardBlockTile) {
            NoticeBoardBlockTile tile = (NoticeBoardBlockTile)blockEntity;
            return tile.interact(player, hand, hitResult, stack);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        return blockEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)blockEntity) : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new NoticeBoardBlockTile(pPos, pState);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == state.getValue((Property)FACING) && level.getBlockEntity(currentPos) instanceof NoticeBoardBlockTile) {
            boolean culled = facingState.isSolidRender((BlockGetter)level, currentPos) && facingState.isFaceSturdy((BlockGetter)level, facingPos, facing.getOpposite());
            state = (BlockState)state.setValue((Property)CULLED, (Comparable)Boolean.valueOf(culled));
        }
        return state;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        NoticeBoardBlockTile tile;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof NoticeBoardBlockTile && !(tile = (NoticeBoardBlockTile)blockEntity).isEmpty()) {
            return (int)Mth.clamp((float)(tile.getPageProgress() + 1.0f), (float)1.0f, (float)15.0f);
        }
        return 0;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean powered;
        super.neighborChanged(state, world, pos, pBlock, pFromPos, pIsMoving);
        boolean bl = powered = world.getBestNeighborSignal(pos) > 0;
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            BlockEntity blockEntity;
            if (powered && (blockEntity = world.getBlockEntity(pos)) instanceof NoticeBoardBlockTile) {
                NoticeBoardBlockTile tile = (NoticeBoardBlockTile)blockEntity;
                tile.turnPage();
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }
}

