/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class BarnaclesBlock
extends MultifaceBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BarnaclesBlock> CODEC = BarnaclesBlock.simpleCodec(BarnaclesBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new UnderwaterSpreadConfig(this));

    public BarnaclesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean canBeAttachTo(BlockGetter level, Direction direction, BlockPos pos, BlockState state) {
        return MultifaceBlock.canAttachTo((BlockGetter)level, (Direction)direction, (BlockPos)pos, (BlockState)state) && state.isSolid();
    }

    public boolean isValidStateForPlacement(BlockGetter level, BlockState state, BlockPos pos, Direction direction) {
        if (!(!this.isFaceSupported(direction) || state.is((Block)this) && BarnaclesBlock.hasFace((BlockState)state, (Direction)direction))) {
            BlockPos blockPos = pos.relative(direction);
            return this.canBeAttachTo(level, direction, blockPos, level.getBlockState(blockPos));
        }
        return false;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        boolean bl = false;
        for (Direction direction : DIRECTIONS) {
            if (!BarnaclesBlock.hasFace((BlockState)state, (Direction)direction)) continue;
            BlockPos blockPos = pos.relative(direction);
            if (!this.canBeAttachTo((BlockGetter)level, direction, blockPos, level.getBlockState(blockPos))) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (!BarnaclesBlock.hasAnyFace((BlockState)state)) {
            return Blocks.AIR.defaultBlockState();
        }
        return BarnaclesBlock.hasFace((BlockState)state, (Direction)direction) && !this.canBeAttachTo((BlockGetter)level, direction, neighborPos, neighborState) ? BarnaclesBlock.removeFace(state, BarnaclesBlock.getFaceProperty((Direction)direction)) : state;
    }

    private static BlockState removeFace(BlockState state, BooleanProperty faceProp) {
        BlockState blockState = (BlockState)state.setValue((Property)faceProp, (Comparable)Boolean.valueOf(false));
        return BarnaclesBlock.hasAnyFace((BlockState)blockState) ? blockState : Blocks.AIR.defaultBlockState();
    }

    public MapCodec<BarnaclesBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && random.nextInt(100) == 0) {
            Direction[] directions = (Direction[])MultifaceBlock.availableFaces((BlockState)state).toArray(Direction[]::new);
            Direction dir = directions[random.nextInt(directions.length)];
            ParticleUtils.spawnParticleOnFace((Level)level, (BlockPos)pos, (Direction)dir, (ParticleOptions)ParticleTypes.BUBBLE, (Vec3)new Vec3(0.0, 0.1, 0.0), (double)0.44f);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.getItemInHand().is(ModRegistry.BARNACLES.get().asItem()) || super.canBeReplaced(state, useContext);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return false;
        }
        return Direction.stream().anyMatch(arg4 -> this.spreader.canSpreadInAnyDirection(state, (BlockGetter)level, pos, arg4.getOpposite()));
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.spreader.spreadFromRandomFaceTowardRandomDirection(state, (LevelAccessor)level, pos, random);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    private static class UnderwaterSpreadConfig
    extends MultifaceSpreader.DefaultSpreaderConfig {
        public UnderwaterSpreadConfig(MultifaceBlock block) {
            super(block);
        }

        public boolean canSpreadInto(BlockGetter level, BlockPos pos, MultifaceSpreader.SpreadPos spreadPos) {
            if (level.getFluidState(spreadPos.pos()).getType() != Fluids.WATER) {
                return false;
            }
            return super.canSpreadInto(level, pos, spreadPos);
        }
    }
}

