/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.GlobeRenderData;
import net.mehvahdjukaar.supplementaries.client.renderers.NoiseRenderType;
import net.mehvahdjukaar.supplementaries.client.renderers.SphereRenderType;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GlobeBlockTileRenderer
implements BlockEntityRenderer<GlobeBlockTile> {
    private final Map<GlobeManager.Model, ModelPart> models = new EnumMap<GlobeManager.Model, ModelPart>(GlobeManager.Model.class);
    private final boolean noise;
    public static GlobeBlockTileRenderer INSTANCE = null;

    public static LayerDefinition createBaseMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("globe", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)16);
    }

    public static LayerDefinition createSpecialMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("flat", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 4.0f, 8.0f).texOffs(0, 13).addBox(-4.0f, -24.0f, -4.0f, 8.0f, 2.0f, 8.0f).texOffs(4, 23).addBox(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).texOffs(8, 24).addBox(-2.0f, -21.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        root.addOrReplaceChild("sheared", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 4.0f).texOffs(0, 12).addBox(0.0f, -28.0f, 0.0f, 4.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition snow = root.addOrReplaceChild("snow", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -28.0f, -4.0f, 8.0f, 5.0f, 8.0f).texOffs(0, 14).addBox(-4.0f, -23.0f, -4.0f, 8.0f, 1.0f, 8.0f).texOffs(4, 16).addBox(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f).texOffs(0, 17).addBox(-2.0f, -24.0f, -2.0f, 4.0f, 1.0f, 4.0f).texOffs(0, 28).addBox(-1.0f, -25.975f, -1.0f, 2.0f, 2.0f, 2.0f).texOffs(12, 20).addBox(-1.0f, -21.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        snow.addOrReplaceChild("roof_l", CubeListBuilder.create().texOffs(11, 27).addBox(0.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        snow.addOrReplaceChild("roof_r", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, -1.0f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-25.9f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public GlobeBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.bakeLayer(ClientRegistry.GLOBE_BASE_MODEL);
        this.models.put(GlobeManager.Model.GLOBE, model.getChild("globe"));
        ModelPart special = context.bakeLayer(ClientRegistry.GLOBE_SPECIAL_MODEL);
        this.models.put(GlobeManager.Model.FLAT, special.getChild("flat"));
        this.models.put(GlobeManager.Model.SNOW, special.getChild("snow"));
        this.models.put(GlobeManager.Model.SHEARED, special.getChild("sheared"));
        INSTANCE = this;
        this.noise = MiscUtils.FESTIVITY.isAprilsFool();
    }

    public void render(GlobeBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(RotHlpr.rot((Direction)tile.getDirection()));
        poseStack.translate(0.0, 0.0625, 0.0);
        poseStack.mulPose(RotHlpr.X22);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f - tile.getRotation(partialTicks)));
        this.renderGlobe(tile.getRenderData(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tile.isSepia(), tile.getLevel());
        poseStack.popPose();
    }

    public void renderGlobe(GlobeRenderData data, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, boolean isSepia, Level level) {
        VertexConsumer builder;
        poseStack.pushPose();
        poseStack.mulPose(RotHlpr.X180);
        GlobeManager.Model globeModel = data.getModel(isSepia);
        if (globeModel == GlobeManager.Model.ROUND || this.noise && isSepia) {
            poseStack.mulPose(RotHlpr.Z180);
            VertexConsumer builder2 = buffer.getBuffer(SphereRenderType.RENDER_TYPE.apply(data.getTexture(isSepia)));
            GlobeBlockTileRenderer.addSphereQuad(poseStack, builder2, 0.65f, light);
            poseStack.popPose();
            return;
        }
        if (this.noise) {
            double si = Math.sin((double)System.currentTimeMillis() / 8000.0) * 30.0;
            float v = (float)Mth.clamp((double)si, (double)-0.5, (double)0.5);
            float c = (float)Mth.clamp((double)si, (double)-2.0, (double)2.0);
            Uniform intensity = ClientRegistry.NOISE_SHADER.get().getUniform("Intensity");
            if (intensity != null) {
                intensity.set(Mth.cos((float)((float)Math.PI * c / 4.0f)));
            }
            poseStack.scale(v + 0.5f + 0.01f, 1.0f, 1.0f);
            builder = buffer.getBuffer(NoiseRenderType.RENDER_TYPE.apply(data.getTexture(isSepia)));
        } else if (globeModel == GlobeManager.Model.FLAT) {
            poseStack.scale(0.01f, 1.0f, 1.0f);
            globeModel = GlobeManager.DEFAULT_DATA.getModel(isSepia);
            RenderType renderType = RenderUtil.getEntityCutoutMipmapRenderType((ResourceLocation)GlobeManager.DEFAULT_DATA.getTexture(isSepia));
            builder = buffer.getBuffer(renderType);
        } else {
            RenderType renderType = RenderUtil.getEntityCutoutMipmapRenderType((ResourceLocation)data.getTexture(isSepia));
            builder = buffer.getBuffer(renderType);
        }
        ModelPart model = this.models.get((Object)globeModel);
        model.render(poseStack, builder, light, overlay, -1);
        poseStack.popPose();
    }

    public static Vector3f getPitchAndYaw(Matrix4f m) {
        float roll;
        float yaw;
        float m02 = m.m02();
        float m12 = m.m12();
        float m22 = m.m22();
        float m01 = m.m01();
        float m11 = m.m11();
        float m21 = m.m21();
        float m00 = m.m00();
        float m10 = m.m10();
        float m20 = m.m20();
        float pitch = (float)Math.asin(-m12);
        if (Math.abs(m12) < 0.999f) {
            yaw = (float)Math.atan2(m02, m22);
            roll = (float)Math.atan2(m10, m11);
        } else {
            yaw = (float)Math.atan2(-m20, m00);
            roll = 0.0f;
        }
        return new Vector3f(pitch, yaw, roll);
    }

    private static void addSphereQuad(PoseStack stack, VertexConsumer consumer, float radius, int light) {
        Matrix4f matrix = stack.last().pose();
        Vector3f sphereRot = GlobeBlockTileRenderer.getPitchAndYaw(matrix);
        Vector3f spherePos = matrix.transformPosition(new Vector3f(0.0f, 0.0f, 0.0f));
        matrix.setRotationYXZ(0.0f, 0.0f, 0.0f);
        Minecraft mc = Minecraft.getInstance();
        Camera cam = mc.gameRenderer.getMainCamera();
        matrix.rotate((Quaternionfc)cam.rotation());
        Vector3f v1 = matrix.transformPosition(new Vector3f(radius, radius, 0.0f));
        Vector3f centerRel1 = spherePos.sub((Vector3fc)v1, new Vector3f());
        consumer.addVertex(v1.x, v1.y, v1.z).setNormal(centerRel1.x, centerRel1.y, centerRel1.z).setColor(-1).setLight(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
        Vector3f v2 = matrix.transformPosition(new Vector3f(-radius, radius, 0.0f));
        Vector3f centerRel2 = spherePos.sub((Vector3fc)v2, new Vector3f());
        consumer.addVertex(v2.x, v2.y, v2.z).setNormal(centerRel2.x, centerRel2.y, centerRel2.z).setColor(-1).setLight(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
        Vector3f v3 = matrix.transformPosition(new Vector3f(-radius, -radius, 0.0f));
        Vector3f centerRel3 = spherePos.sub((Vector3fc)v3, new Vector3f());
        consumer.addVertex(v3.x, v3.y, v3.z).setNormal(centerRel3.x, centerRel3.y, centerRel3.z).setColor(-1).setLight(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
        Vector3f v4 = matrix.transformPosition(new Vector3f(radius, -radius, 0.0f));
        Vector3f centerRel4 = spherePos.sub((Vector3fc)v4, new Vector3f());
        consumer.addVertex(v4.x, v4.y, v4.z).setNormal(centerRel4.x, centerRel4.y, centerRel4.z).setColor(-1).setLight(light);
        GlobeBlockTileRenderer.addExtraVec3f(consumer, sphereRot);
    }

    private static void addExtraVec3f(VertexConsumer consumer, Vector3f vec) {
        consumer.setUv(vec.x, vec.y);
        short[] shorts = GlobeBlockTileRenderer.floatToTwoShorts(vec.z);
        consumer.setUv1((int)shorts[0], (int)shorts[1]);
    }

    public static short[] floatToTwoShorts(float value) {
        int bits = Float.floatToIntBits(value);
        short high = (short)(bits >>> 16 & 0xFFFF);
        short low = (short)(bits & 0xFFFF);
        return new short[]{high, low};
    }
}

