/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlackboardTextureManager {
    private static final LoadingCache<BlackboardData, BlackboardVisuals> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        BlackboardVisuals value = (BlackboardVisuals)i.getValue();
        if (value != null) {
            RenderSystem.recordRenderCall(value::close);
        }
    }).build((CacheLoader)new CacheLoader<BlackboardData, BlackboardVisuals>(){

        public BlackboardVisuals load(BlackboardData key) {
            return null;
        }
    });

    public static BlackboardVisuals getInstance(BlackboardData key) {
        BlackboardVisuals textureInstance = (BlackboardVisuals)TEXTURE_CACHE.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new BlackboardVisuals(key.getPixelsUnsafe(), key.isGlow());
            TEXTURE_CACHE.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    public static void closeAll() {
        TEXTURE_CACHE.invalidateAll();
    }

    public static class BlackboardVisuals
    implements AutoCloseable {
        private static final int WIDTH = 16;
        private final Map<Direction, List<BakedQuad>> quadsCache = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final byte[][] pixels;
        private final boolean glow;
        @Nullable
        private DynamicTexture texture;
        @Nullable
        private RenderType renderType;
        @Nullable
        private ResourceLocation textureLocation;

        private BlackboardVisuals(byte[][] pixels, boolean glow) {
            this.pixels = pixels;
            this.glow = glow;
        }

        public byte[][] getPixels() {
            return this.pixels;
        }

        public boolean isGlow() {
            return this.glow;
        }

        private void initializeTexture() {
            this.texture = new DynamicTexture(16, 16, false);
            for (int y = 0; y < this.pixels.length && y < 16; ++y) {
                for (int x = 0; x < this.pixels[y].length && x < 16; ++x) {
                    this.texture.getPixels().setPixelRGBA(x, y, BlackboardVisuals.getColoredPixel(this.pixels[x][y], x, y));
                }
            }
            this.texture.upload();
            this.textureLocation = Minecraft.getInstance().getTextureManager().register("blackboard/", this.texture);
            this.renderType = RenderType.entitySolid((ResourceLocation)this.textureLocation);
        }

        private static int getColoredPixel(byte i, int x, int y) {
            int offset = i > 0 ? 16 : 0;
            int tint = BlackboardBlock.colorFromByte(i);
            TextureAtlas textureMap = Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);
            TextureAtlasSprite sprite = textureMap.getSprite(ModTextures.BLACKBOARD_TEXTURE);
            return BlackboardVisuals.getTintedColor(sprite, x, y, offset, tint);
        }

        private static int getTintedColor(TextureAtlasSprite sprite, int x, int y, int offset, int tint) {
            if (sprite == null || sprite.contents().getFrameCount() == 0) {
                return -1;
            }
            int tintR = FastColor.ABGR32.red((int)tint);
            int tintG = FastColor.ABGR32.green((int)tint);
            int tintB = FastColor.ABGR32.blue((int)tint);
            int pixel = ClientHelper.getPixelRGBA((TextureAtlasSprite)sprite, (int)0, (int)Math.min(sprite.contents().width() - 1, x + offset), (int)Math.min(sprite.contents().height() - 1, y));
            int totalB = FastColor.ARGB32.blue((int)pixel);
            int totalG = FastColor.ARGB32.green((int)pixel);
            int totalR = FastColor.ARGB32.red((int)pixel);
            return FastColor.ARGB32.color((int)255, (int)(totalR * tintR / 255), (int)(totalG * tintG / 255), (int)(totalB * tintB / 255));
        }

        @NotNull
        public List<BakedQuad> getOrCreateModel(Direction dir, BiFunction<BlackboardVisuals, Direction, List<BakedQuad>> modelFactory) {
            return this.quadsCache.computeIfAbsent(dir, d -> (List)modelFactory.apply(this, (Direction)d));
        }

        @NotNull
        public ResourceLocation getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @NotNull
        public RenderType getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
            if (this.textureLocation != null) {
                Minecraft.getInstance().getTextureManager().release(this.textureLocation);
            }
        }
    }
}

