/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.ClassTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.RemappedEnumConstant;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class EnumTypeInfo
extends ClassTypeInfo
implements TypeWrapperFactory<Object> {
    static final Map<Class<?>, EnumTypeInfo> CACHE = new IdentityHashMap();
    private List<Object> constants;
    private Map<String, Object> constantMap;

    public static String getName(Object e) {
        RemappedEnumConstant c;
        String s;
        if (e instanceof RemappedEnumConstant && !(s = (c = (RemappedEnumConstant)e).getRemappedEnumConstantName()).isEmpty()) {
            return s;
        }
        return ((Enum)e).name();
    }

    EnumTypeInfo(Class<?> type) {
        super(type);
    }

    @Override
    public List<Object> enumConstants() {
        if (this.constants == null) {
            this.constants = List.of(this.asClass().getEnumConstants());
        }
        return this.constants;
    }

    @Override
    public Object wrap(Context cx, Object from, TypeInfo target) {
        if (from instanceof CharSequence) {
            Object lookup;
            String s = from.toString();
            if (s.isEmpty()) {
                return null;
            }
            List<Object> constants = this.enumConstants();
            if (this.constantMap == null) {
                this.constantMap = new HashMap<String, Object>(constants.size());
                for (Object entry : constants) {
                    String name = EnumTypeInfo.getName(entry);
                    this.constantMap.put(name.toLowerCase(Locale.ROOT), entry);
                    this.constantMap.put(name, entry);
                }
            }
            if ((lookup = this.constantMap.get(s)) != null) {
                return lookup;
            }
            for (Object entry : constants) {
                if (!EnumTypeInfo.getName(entry).equalsIgnoreCase(s)) continue;
                return entry;
            }
            throw new IllegalArgumentException("'" + s + "' is not a valid enum constant! Valid values are: " + constants.stream().map(EnumTypeInfo::getName).map(s1 -> "'" + s1 + "'").collect(Collectors.joining(", ")));
        }
        if (from instanceof Number) {
            int index = ((Number)from).intValue();
            List<Object> constants = this.enumConstants();
            if (index < 0 || index >= constants.size()) {
                throw new IllegalArgumentException(index + " is not a valid enum index! Valid values are: 0 - " + (constants.size() - 1));
            }
            return constants.get(index);
        }
        return from;
    }
}

