/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.ArrowFunction;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.CachedClassStorage;
import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.CompilerEnvirons;
import dev.latvian.mods.rhino.ContextFactory;
import dev.latvian.mods.rhino.DefaultErrorReporter;
import dev.latvian.mods.rhino.DefiningClassLoader;
import dev.latvian.mods.rhino.ErrorReporter;
import dev.latvian.mods.rhino.Evaluator;
import dev.latvian.mods.rhino.EvaluatorException;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.GeneratedClassLoader;
import dev.latvian.mods.rhino.IRFactory;
import dev.latvian.mods.rhino.ImplementationVersion;
import dev.latvian.mods.rhino.InterfaceAdapter;
import dev.latvian.mods.rhino.Interpreter;
import dev.latvian.mods.rhino.JavaAdapter;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.NativeCall;
import dev.latvian.mods.rhino.NativeDate;
import dev.latvian.mods.rhino.NativeFunction;
import dev.latvian.mods.rhino.NativeGSON;
import dev.latvian.mods.rhino.NativeJSON;
import dev.latvian.mods.rhino.NativeJavaArray;
import dev.latvian.mods.rhino.NativeJavaClass;
import dev.latvian.mods.rhino.NativeJavaList;
import dev.latvian.mods.rhino.NativeJavaMap;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.ObjArray;
import dev.latvian.mods.rhino.Parser;
import dev.latvian.mods.rhino.RhinoException;
import dev.latvian.mods.rhino.Script;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.TopLevel;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.WrappedException;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.ast.AstRoot;
import dev.latvian.mods.rhino.ast.ScriptNode;
import dev.latvian.mods.rhino.classfile.ClassFileWriter;
import dev.latvian.mods.rhino.regexp.RegExp;
import dev.latvian.mods.rhino.type.ArrayTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.ArrayValueProvider;
import dev.latvian.mods.rhino.util.ClassVisibilityContext;
import dev.latvian.mods.rhino.util.CustomJavaToJsWrapper;
import dev.latvian.mods.rhino.util.JavaSetWrapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import org.jetbrains.annotations.Nullable;

public class Context {
    public static final int CONVERSION_EXACT = 0;
    public static final int CONVERSION_TRIVIAL = 1;
    public static final int CONVERSION_NONE = 99;
    public static final int JSTYPE_UNDEFINED = 0;
    public static final int JSTYPE_NULL = 1;
    public static final int JSTYPE_BOOLEAN = 2;
    public static final int JSTYPE_NUMBER = 3;
    public static final int JSTYPE_STRING = 4;
    public static final int JSTYPE_JAVA_CLASS = 5;
    public static final int JSTYPE_JAVA_OBJECT = 6;
    public static final int JSTYPE_JAVA_ARRAY = 7;
    public static final int JSTYPE_OBJECT = 8;
    public final ContextFactory factory;
    public final Object lock = new Object();
    public boolean generateObserverCount = false;
    private Scriptable topCallScope;
    boolean isContinuationsTopCall;
    NativeCall currentActivationCall;
    BaseFunction typeErrorThrower;
    RegExp regExp;
    Object lastInterpreterFrame;
    ObjArray previousInterpreterInvocations;
    int instructionCount;
    int instructionThreshold;
    long scratchUint32;
    private Scriptable scratchScriptable;
    boolean isTopLevelStrict;
    private Map<Object, Object> threadLocalMap;
    private ClassLoader applicationClassLoader;
    private transient Map<Class<?>, JavaMembers> classTable;
    private transient Map<JavaAdapter.JavaAdapterSignature, Class<?>> classAdapterCache;
    private transient Map<Class<?>, Object> interfaceAdapterCache;
    private int generatedClassSerial;

    public static void reportWarning(Context cx, String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        cx.getErrorReporter().warning(message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportWarning(String message, Context cx) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(cx, linep);
        Context.reportWarning(cx, message, filename, linep[0], null, 0);
    }

    public static void reportError(Context cx, String message, int lineno, String lineSource, int lineOffset, String sourceName) {
        if (cx == null) {
            throw new EvaluatorException(cx, message, sourceName, lineno, lineSource, lineOffset);
        }
        cx.getErrorReporter().error(cx, message, sourceName, lineno, lineSource, lineOffset);
    }

    public static void reportError(Context cx, String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(cx, linep);
        Context.reportError(cx, message, linep[0], null, 0, filename);
    }

    public static EvaluatorException reportRuntimeError(Context cx, String message, String sourceName, int lineno, String lineSource, int lineOffset) {
        if (cx != null) {
            return cx.getErrorReporter().runtimeError(cx, message, sourceName, lineno, lineSource, lineOffset);
        }
        throw new EvaluatorException(cx, message, sourceName, lineno, lineSource, lineOffset);
    }

    public static EvaluatorException reportRuntimeError0(String messageId, Context cx) {
        String msg = ScriptRuntime.getMessage0(messageId);
        return Context.reportRuntimeError(msg, cx);
    }

    public static EvaluatorException reportRuntimeError1(String messageId, Object arg1, Context cx) {
        String msg = ScriptRuntime.getMessage1(messageId, arg1);
        return Context.reportRuntimeError(msg, cx);
    }

    public static EvaluatorException reportRuntimeError2(String messageId, Object arg1, Object arg2, Context cx) {
        String msg = ScriptRuntime.getMessage2(messageId, arg1, arg2);
        return Context.reportRuntimeError(msg, cx);
    }

    public static EvaluatorException reportRuntimeError3(String messageId, Object arg1, Object arg2, Object arg3, Context cx) {
        String msg = ScriptRuntime.getMessage3(messageId, arg1, arg2, arg3);
        return Context.reportRuntimeError(msg, cx);
    }

    public static EvaluatorException reportRuntimeError4(String messageId, Object arg1, Object arg2, Object arg3, Object arg4, Context cx) {
        String msg = ScriptRuntime.getMessage4(messageId, arg1, arg2, arg3, arg4);
        return Context.reportRuntimeError(msg, cx);
    }

    public static EvaluatorException reportRuntimeError(String message, Context cx) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(cx, linep);
        return Context.reportRuntimeError(cx, message, filename, linep[0], null, 0);
    }

    public static Object getUndefinedValue() {
        return Undefined.INSTANCE;
    }

    public static RuntimeException throwAsScriptRuntimeEx(Throwable e, Context cx) {
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Throwable throwable = e;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Error.class, RhinoException.class}, (Object)throwable, n)) {
            case 0: {
                Error err = (Error)throwable;
                throw err;
            }
            case 1: {
                RhinoException err = (RhinoException)throwable;
                throw err;
            }
        }
        throw new WrappedException(cx, e);
    }

    static Evaluator createInterpreter() {
        return new Interpreter();
    }

    public static String getSourcePositionFromStack(Context cx, int[] linep) {
        StackTraceElement[] stackTrace;
        Evaluator evaluator;
        if (cx == null) {
            return null;
        }
        if (cx.lastInterpreterFrame != null && (evaluator = Context.createInterpreter()) != null) {
            return evaluator.getSourcePositionFromStack(cx, linep);
        }
        for (StackTraceElement st : stackTrace = new Throwable().getStackTrace()) {
            int line;
            String file = st.getFileName();
            if (file == null || file.endsWith(".java") || (line = st.getLineNumber()) < 0) continue;
            linep[0] = line;
            return file;
        }
        return null;
    }

    public Context(ContextFactory factory) {
        this.factory = factory;
    }

    public final String getImplementationVersion() {
        return ImplementationVersion.get();
    }

    public final ErrorReporter getErrorReporter() {
        return DefaultErrorReporter.instance;
    }

    public final ScriptableObject initStandardObjects() {
        return this.initStandardObjects(null, false);
    }

    public final ScriptableObject initSafeStandardObjects() {
        return this.initSafeStandardObjects(null, false);
    }

    public final Scriptable initStandardObjects(ScriptableObject scope) {
        return this.initStandardObjects(scope, false);
    }

    public final Scriptable initSafeStandardObjects(ScriptableObject scope) {
        return this.initSafeStandardObjects(scope, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scope, boolean sealed) {
        return ScriptRuntime.initStandardObjects(this, scope, sealed);
    }

    public ScriptableObject initSafeStandardObjects(ScriptableObject scope, boolean sealed) {
        return ScriptRuntime.initSafeStandardObjects(this, scope, sealed);
    }

    public final Object evaluateString(Scriptable scope, String source, String sourceName, int lineno, Object securityDomain) {
        Script script = this.compileString(source, sourceName, lineno, securityDomain);
        if (script != null) {
            return script.exec(this, scope);
        }
        return null;
    }

    public final Object evaluateReader(Scriptable scope, Reader in, String sourceName, int lineno, Object securityDomain) throws IOException {
        Script script = this.compileReader(in, sourceName, lineno, securityDomain);
        if (script != null) {
            return script.exec(this, scope);
        }
        return null;
    }

    public final Script compileReader(Reader in, String sourceName, int lineno, Object securityDomain) throws IOException {
        if (lineno < 0) {
            lineno = 0;
        }
        return (Script)this.compileImpl(null, Kit.readReader(in), sourceName, lineno, securityDomain, false, null, null);
    }

    public final Script compileString(String source, String sourceName, int lineno, Object securityDomain) {
        if (lineno < 0) {
            lineno = 0;
        }
        return this.compileString(source, null, null, sourceName, lineno, securityDomain);
    }

    final Script compileString(String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
        try {
            return (Script)this.compileImpl(null, source, sourceName, lineno, securityDomain, false, compiler, compilationErrorReporter);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    final Function compileFunction(Scriptable scope, String source, Evaluator compiler, ErrorReporter compilationErrorReporter, String sourceName, int lineno, Object securityDomain) {
        try {
            return (Function)this.compileImpl(scope, source, sourceName, lineno, securityDomain, true, compiler, compilationErrorReporter);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public Scriptable newObject(Scriptable scope) {
        NativeObject result = new NativeObject(this.factory);
        ScriptRuntime.setBuiltinProtoAndParent(this, scope, result, TopLevel.Builtins.Object);
        return result;
    }

    public Scriptable newObject(Scriptable scope, String constructorName) {
        return this.newObject(scope, constructorName, ScriptRuntime.EMPTY_OBJECTS);
    }

    public Scriptable newObject(Scriptable scope, String constructorName, Object[] args) {
        return ScriptRuntime.newObject(this, scope, constructorName, args);
    }

    public Scriptable newArray(Scriptable scope, int length) {
        NativeArray result = new NativeArray(this, length);
        ScriptRuntime.setBuiltinProtoAndParent(this, scope, result, TopLevel.Builtins.Array);
        return result;
    }

    public Scriptable newArray(Scriptable scope, Object[] elements) {
        if (elements.getClass().getComponentType() != ScriptRuntime.ObjectClass) {
            throw new IllegalArgumentException();
        }
        NativeArray result = new NativeArray(this, elements);
        ScriptRuntime.setBuiltinProtoAndParent(this, scope, result, TopLevel.Builtins.Array);
        return result;
    }

    public boolean toBoolean(Object value) {
        return ScriptRuntime.toBoolean(this, value);
    }

    public double toNumber(Object value) {
        return ScriptRuntime.toNumber(this, value);
    }

    public String toString(Object value) {
        return ScriptRuntime.toString(this, value);
    }

    public Scriptable toObject(Object value, Scriptable scope) {
        return ScriptRuntime.toObject(this, scope, value);
    }

    public final Object getThreadLocal(Object key) {
        if (this.threadLocalMap == null) {
            return null;
        }
        return this.threadLocalMap.get(key);
    }

    public final synchronized void putThreadLocal(Object key, Object value) {
        if (this.threadLocalMap == null) {
            this.threadLocalMap = new HashMap<Object, Object>();
        }
        this.threadLocalMap.put(key, value);
    }

    public final void removeThreadLocal(Object key) {
        if (this.threadLocalMap == null) {
            return;
        }
        this.threadLocalMap.remove(key);
    }

    public final int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public final void setInstructionObserverThreshold(int threshold) {
        if (threshold < 0) {
            throw new IllegalArgumentException();
        }
        this.instructionThreshold = threshold;
        this.setGenerateObserverCount(threshold > 0);
    }

    public void setGenerateObserverCount(boolean generateObserverCount) {
        this.generateObserverCount = generateObserverCount;
    }

    protected void observeInstructionCount(int instructionCount) {
    }

    public final ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
            if (threadLoader != null && Kit.testIfCanLoadRhinoClasses(threadLoader)) {
                return threadLoader;
            }
            this.applicationClassLoader = this.getClass().getClassLoader();
        }
        return this.applicationClassLoader;
    }

    public final void setApplicationClassLoader(ClassLoader loader) {
        if (loader == null) {
            this.applicationClassLoader = null;
            return;
        }
        if (!Kit.testIfCanLoadRhinoClasses(loader)) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        this.applicationClassLoader = loader;
    }

    private Object compileImpl(Scriptable scope, String sourceString, String sourceName, int lineno, Object securityDomain, boolean returnFunction, Evaluator compiler, ErrorReporter compilationErrorReporter) throws IOException {
        Object bytecode;
        if (sourceName == null) {
            sourceName = "unnamed script";
        }
        if (securityDomain != null) {
            throw new IllegalArgumentException("securityDomain should be null if setSecurityController() was never called");
        }
        if (scope == null == returnFunction) {
            Kit.codeBug();
        }
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(this);
        if (compilationErrorReporter == null) {
            compilationErrorReporter = compilerEnv.getErrorReporter();
        }
        ScriptNode tree = this.parse(sourceString, sourceName, lineno, compilerEnv, compilationErrorReporter, returnFunction);
        try {
            if (compiler == null) {
                compiler = this.createCompiler();
            }
            bytecode = compiler.compile(compilerEnv, tree, returnFunction, this);
        }
        catch (ClassFileWriter.ClassFileFormatException e) {
            tree = this.parse(sourceString, sourceName, lineno, compilerEnv, compilationErrorReporter, returnFunction);
            compiler = Context.createInterpreter();
            bytecode = compiler.compile(compilerEnv, tree, returnFunction, this);
        }
        Object result = returnFunction ? compiler.createFunctionObject(this, scope, bytecode, securityDomain) : compiler.createScriptObject(bytecode, securityDomain);
        return result;
    }

    private ScriptNode parse(String sourceString, String sourceName, int lineno, CompilerEnvirons compilerEnv, ErrorReporter compilationErrorReporter, boolean returnFunction) throws IOException {
        Parser p = new Parser(this, compilerEnv, compilationErrorReporter);
        if (returnFunction) {
            p.calledByCompileFunction = true;
        }
        if (this.isStrictMode()) {
            p.setDefaultUseStrictDirective(true);
        }
        AstRoot ast = p.parse(sourceString, sourceName, lineno);
        if (returnFunction && (ast.getFirstChild() == null || ast.getFirstChild().getType() != 110)) {
            throw new IllegalArgumentException("compileFunction only accepts source with single JS function: " + sourceString);
        }
        return new IRFactory(this, compilerEnv, compilationErrorReporter).transformTree(ast);
    }

    private Evaluator createCompiler() {
        return Context.createInterpreter();
    }

    public RegExp getRegExp() {
        if (this.regExp == null) {
            this.regExp = new RegExp();
        }
        return this.regExp;
    }

    public final boolean isStrictMode() {
        return this.isTopLevelStrict || this.currentActivationCall != null && this.currentActivationCall.isStrict;
    }

    public void addToScope(Scriptable scope, String name, Object value) {
        if (value instanceof Class) {
            Class c = (Class)value;
            ScriptableObject.putProperty(scope, name, (Object)new NativeJavaClass(this, scope, c), this);
        } else {
            ScriptableObject.putProperty(scope, name, this.javaToJS(value, scope), this);
        }
    }

    Map<Class<?>, JavaMembers> getClassCacheMap() {
        if (this.classTable == null) {
            this.classTable = new ConcurrentHashMap(16, 0.75f, 1);
        }
        return this.classTable;
    }

    Map<JavaAdapter.JavaAdapterSignature, Class<?>> getInterfaceAdapterCacheMap() {
        if (this.classAdapterCache == null) {
            this.classAdapterCache = new ConcurrentHashMap(16, 0.75f, 1);
        }
        return this.classAdapterCache;
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class<?> cl) {
        return this.interfaceAdapterCache == null ? null : this.interfaceAdapterCache.get(cl);
    }

    synchronized void cacheInterfaceAdapter(Class<?> cl, Object iadapter) {
        if (this.interfaceAdapterCache == null) {
            this.interfaceAdapterCache = new ConcurrentHashMap(16, 0.75f, 1);
        }
        this.interfaceAdapterCache.put(cl, iadapter);
    }

    public boolean visibleToScripts(String fullClassName, ClassVisibilityContext type) {
        return true;
    }

    public Object wrap(Scriptable scope, Object obj, TypeInfo target) {
        if (obj == null || obj == Undefined.INSTANCE || obj instanceof Scriptable) {
            return obj;
        }
        if (target.isVoid()) {
            return Undefined.INSTANCE;
        }
        if (target.isCharacter()) {
            return (int)((Character)obj).charValue();
        }
        if (target.isPrimitive()) {
            return obj;
        }
        if (target instanceof ArrayTypeInfo) {
            ArrayTypeInfo array = (ArrayTypeInfo)target;
            return new NativeJavaArray(scope, obj, array, this);
        }
        return this.wrapAsJavaObject(scope, obj, target);
    }

    public Object wrapAny(Scriptable scope, Object obj) {
        if (obj instanceof String || obj instanceof Boolean || obj instanceof Integer || obj instanceof Short || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            return obj;
        }
        if (obj instanceof Character) {
            return String.valueOf(((Character)obj).charValue());
        }
        Class<?> cls = obj.getClass();
        TypeInfo ti = TypeInfo.NONE;
        if (cls.isArray()) {
            ti = TypeInfo.of(cls);
        }
        return this.wrap(scope, obj, ti);
    }

    public Object wrap(Scriptable scope, Object obj) {
        return this.wrap(scope, obj, TypeInfo.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTopCallScope() {
        Object object = this.lock;
        synchronized (object) {
            return this.topCallScope != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable getTopCallScope() {
        Object object = this.lock;
        synchronized (object) {
            return this.topCallScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable getTopCallOrThrow() {
        Object object = this.lock;
        synchronized (object) {
            if (this.topCallScope == null) {
                throw new IllegalStateException();
            }
            return this.topCallScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopCall(Scriptable scope) {
        Object object = this.lock;
        synchronized (object) {
            this.topCallScope = scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeScriptable(Scriptable value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.scratchScriptable != null) {
                throw new IllegalStateException();
            }
            this.scratchScriptable = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable lastStoredScriptable() {
        Object object = this.lock;
        synchronized (object) {
            Scriptable result = this.scratchScriptable;
            this.scratchScriptable = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callSync(Callable callable, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object object = this.lock;
        synchronized (object) {
            return callable.call(this, scope, thisObj, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTopCall(Scriptable scope, Callable callable, Scriptable thisObj, Object[] args, boolean isTopLevelStrict) {
        Object result;
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        if (this.hasTopCallScope()) {
            throw new IllegalStateException();
        }
        this.setTopCall(ScriptableObject.getTopLevelScope(scope));
        boolean previousTopLevelStrict = this.isTopLevelStrict;
        this.isTopLevelStrict = isTopLevelStrict;
        try {
            result = this.callSync(callable, scope, thisObj, args);
        }
        finally {
            this.setTopCall(null);
            this.isTopLevelStrict = previousTopLevelStrict;
            if (this.currentActivationCall != null) {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public Scriptable wrapJavaClass(Scriptable scope, Class<?> javaClass) {
        return new NativeJavaClass(this, scope, javaClass);
    }

    public Scriptable wrapAsJavaObject(Scriptable scope, Object javaObject, TypeInfo target) {
        if (javaObject instanceof CustomJavaToJsWrapper) {
            CustomJavaToJsWrapper w = (CustomJavaToJsWrapper)javaObject;
            return w.convertJavaToJs(this, scope, target);
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            return new NativeJavaMap(this, scope, map, map, target);
        }
        if (javaObject instanceof List) {
            List list = (List)javaObject;
            return new NativeJavaList(this, scope, list, list, target);
        }
        if (javaObject instanceof Set) {
            Set set = (Set)javaObject;
            return new NativeJavaList(this, scope, set, new JavaSetWrapper(set), target);
        }
        return new NativeJavaObject(scope, javaObject, target, this);
    }

    public Scriptable wrapNewObject(Scriptable scope, Object obj, TypeInfo objType) {
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        if (objType instanceof ArrayTypeInfo) {
            return new NativeJavaArray(scope, obj, objType, this);
        }
        return this.wrapAsJavaObject(scope, obj, TypeInfo.NONE);
    }

    public int internalConversionWeight(Object fromObj, TypeInfo target) {
        if (this.factory.getTypeWrappers().hasWrapper(fromObj, target)) {
            return 0;
        }
        return 99;
    }

    public int internalConversionWeightLast(Object fromObj, TypeInfo target) {
        return 99;
    }

    public GeneratedClassLoader createClassLoader(ClassLoader parent) {
        return new DefiningClassLoader(parent);
    }

    public int getMaximumInterpreterStackDepth() {
        return Integer.MAX_VALUE;
    }

    public ArrayValueProvider arrayValueProviderOf(Object value) {
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            return arr.length == 0 ? ArrayValueProvider.EMPTY : new ArrayValueProvider.FromPlainJavaArray(arr);
        }
        if (value != null && value.getClass().isArray()) {
            int len = Array.getLength(value);
            return len == 0 ? ArrayValueProvider.EMPTY : new ArrayValueProvider.FromJavaArray(value, len);
        }
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeArray.class, NativeJavaList.class, List.class, Iterable.class}, (Object)object, n)) {
            case 0 -> {
                NativeArray array = (NativeArray)object;
                yield ArrayValueProvider.fromNativeArray(array);
            }
            case 1 -> {
                NativeJavaList list = (NativeJavaList)object;
                yield ArrayValueProvider.fromJavaList(list.list, list);
            }
            case 2 -> {
                List list = (List)object;
                yield ArrayValueProvider.fromJavaList(list, list);
            }
            case 3 -> {
                Iterable itr = (Iterable)object;
                yield ArrayValueProvider.fromIterable(itr);
            }
            default -> value == null ? ArrayValueProvider.FromObject.FROM_NULL : new ArrayValueProvider.FromObject(value);
        };
    }

    public Object arrayOf(@Nullable Object from, TypeInfo target) {
        if (from instanceof Object[]) {
            Object[] arr = (Object[])from;
            if (target == null) {
                return from;
            }
            return arr.length == 0 ? target.newArray(0) : new ArrayValueProvider.FromPlainJavaArray(arr).createArray(this, target);
        }
        if (from != null && from.getClass().isArray()) {
            if (target == null) {
                return from;
            }
            int len = Array.getLength(from);
            return len == 0 ? target.newArray(0) : new ArrayValueProvider.FromJavaArray(from, len).createArray(this, target);
        }
        return this.arrayValueProviderOf(from).createArray(this, target);
    }

    public Object listOf(@Nullable Object from, TypeInfo target) {
        if (from instanceof NativeJavaList) {
            NativeJavaList n = (NativeJavaList)from;
            if (target == null) {
                return n.list;
            }
            if (target.equals(n.listType)) {
                return n.list;
            }
            ArrayList<Object> list = new ArrayList<Object>(n.list.size());
            for (Object o : n.list) {
                list.add(this.jsToJava(o, target));
            }
            return list;
        }
        return this.arrayValueProviderOf(from).createList(this, target);
    }

    public boolean isListLike(Object from) {
        return from instanceof NativeJavaList || from instanceof NativeJavaArray || from instanceof List;
    }

    @Nullable
    public <K> List<K> optionalListOf(@Nullable Object from, TypeInfo target) {
        return this.isListLike(from) ? (List)this.listOf(from, target) : null;
    }

    @Nullable
    public List<Object> optionalListOf(@Nullable Object from) {
        return this.optionalListOf(from, TypeInfo.NONE);
    }

    public Object setOf(@Nullable Object from, TypeInfo target) {
        if (from instanceof NativeJavaList) {
            NativeJavaList n = (NativeJavaList)from;
            if (target == null) {
                return new LinkedHashSet(n.list);
            }
            if (target.equals(n.listType)) {
                return new LinkedHashSet(n.list);
            }
            LinkedHashSet<Object> set = new LinkedHashSet<Object>(n.list.size());
            for (Object o : n.list) {
                set.add(this.jsToJava(o, target));
            }
            return set;
        }
        return this.arrayValueProviderOf(from).createSet(this, target);
    }

    public Object mapOf(@Nullable Object from, TypeInfo kTarget, TypeInfo vTarget) {
        if (from instanceof NativeJavaMap) {
            NativeJavaMap n = (NativeJavaMap)from;
            if (!kTarget.shouldConvert() && !vTarget.shouldConvert()) {
                return n.map;
            }
            if (kTarget.equals(n.mapKeyType) && vTarget.equals(n.mapValueType)) {
                return n.map;
            }
            if (n.map.isEmpty()) {
                return Map.of();
            }
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(n.map.size());
            for (Map.Entry entry : n.map.entrySet()) {
                map.put(this.jsToJava(entry.getKey(), kTarget), this.jsToJava(entry.getValue(), vTarget));
            }
            return map;
        }
        if (from instanceof NativeObject) {
            NativeObject obj = (NativeObject)from;
            Object[] keys = obj.getIds(this);
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(keys.length);
            for (Object key : keys) {
                map.put(this.jsToJava(key, kTarget), this.jsToJava(obj.get(this, key), vTarget));
            }
            return map;
        }
        if (from instanceof Map) {
            Map m = (Map)from;
            if (!kTarget.shouldConvert() && !vTarget.shouldConvert()) {
                return m;
            }
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(m.size());
            for (Map.Entry entry : m.entrySet()) {
                map.put(this.jsToJava(entry.getKey(), kTarget), this.jsToJava(entry.getValue(), vTarget));
            }
            return map;
        }
        return this.reportConversionError(from, TypeInfo.RAW_MAP);
    }

    public boolean isMapLike(Object from) {
        return from instanceof NativeJavaMap || from instanceof Map;
    }

    @Nullable
    public <K, V> Map<K, V> optionalMapOf(@Nullable Object from, TypeInfo kTarget, TypeInfo vTarget) {
        return this.isMapLike(from) ? (Map)this.mapOf(from, kTarget, vTarget) : null;
    }

    @Nullable
    public Map<String, Object> optionalMapOf(@Nullable Object from) {
        return this.optionalMapOf(from, TypeInfo.STRING, TypeInfo.NONE);
    }

    public Object classOf(Object from) {
        if (from instanceof NativeJavaClass) {
            NativeJavaClass n = (NativeJavaClass)from;
            return n.getClassObject();
        }
        if (from instanceof Class) {
            Class c = (Class)from;
            if (this.visibleToScripts(c.getName(), ClassVisibilityContext.ARGUMENT)) {
                return c;
            }
            throw Context.reportRuntimeError("Class " + c.getName() + " not allowed", this);
        }
        String s = ScriptRuntime.toString(this, from);
        if (this.visibleToScripts(s, ClassVisibilityContext.ARGUMENT)) {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                throw Context.reportRuntimeError("Failed to load class " + s, this);
            }
        }
        throw Context.reportRuntimeError("Class " + String.valueOf(from) + " not allowed", this);
    }

    public Object createInterfaceAdapter(TypeInfo type, ScriptableObject so) {
        Class<?> cl = type.asClass();
        if (cl == null) {
            throw new NullPointerException("type.asClass() must not be null");
        }
        Object key = Kit.makeHashKeyFromPair("Coerced Interface", cl);
        Object old = so.getAssociatedValue(key);
        if (old != null) {
            return old;
        }
        Object glue = InterfaceAdapter.create(this, cl, so);
        glue = so.associateValue(key, glue);
        return glue;
    }

    public Object javaToJS(Object value, Scriptable scope) {
        return this.javaToJS(value, scope, TypeInfo.NONE);
    }

    public Object javaToJS(Object value, Scriptable scope, TypeInfo target) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Scriptable) {
            return value;
        }
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue());
        }
        return this.wrap(scope, value, target);
    }

    public final Object jsToJava(@Nullable Object from, TypeInfo target) throws EvaluatorException {
        if (target == null || !target.shouldConvert()) {
            return Wrapper.unwrapped(from);
        }
        if (target.is(TypeInfo.RAW_SET)) {
            return this.setOf(from, target.param(0));
        }
        if (target.is(TypeInfo.RAW_MAP)) {
            return this.mapOf(from, target.param(0), target.param(1));
        }
        if (target instanceof ArrayTypeInfo) {
            return this.arrayOf(from, target.componentType());
        }
        if (List.class.isAssignableFrom(target.asClass())) {
            return this.listOf(from, target.param(0));
        }
        if (target.is(TypeInfo.CLASS)) {
            return this.classOf(from);
        }
        if (from == null || from.getClass() == target.asClass()) {
            return from;
        }
        return this.internalJsToJava(from, target);
    }

    private static int getJSTypeCode(Object from) {
        if (from == null) {
            return 1;
        }
        if (from == Undefined.INSTANCE) {
            return 0;
        }
        if (from instanceof CharSequence) {
            return 4;
        }
        if (from instanceof Number) {
            return 3;
        }
        if (from instanceof Boolean) {
            return 2;
        }
        if (from instanceof Scriptable) {
            Object object = from;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NativeJavaClass.class, NativeJavaArray.class, Wrapper.class}, (Object)object2, n)) {
                case 0 -> {
                    NativeJavaClass ignore = (NativeJavaClass)object2;
                    yield 5;
                }
                case 1 -> {
                    NativeJavaArray ignore = (NativeJavaArray)object2;
                    yield 7;
                }
                case 2 -> {
                    Wrapper ignore = (Wrapper)object2;
                    yield 6;
                }
                default -> 8;
            };
        }
        if (from instanceof Class) {
            return 5;
        }
        Class<?> valueClass = from.getClass();
        if (valueClass.isArray()) {
            return 7;
        }
        return 6;
    }

    protected Object internalJsToJava(Object from, TypeInfo target) {
        if (target instanceof ArrayTypeInfo) {
            TypeInfo arrayType = target.componentType();
            if (from instanceof NativeArray) {
                NativeArray array = (NativeArray)from;
                long length = array.getLength();
                Object result = arrayType.newArray((int)length);
                int i = 0;
                while ((long)i < length) {
                    try {
                        Array.set(result, i, this.jsToJava(array.get(this, i, (Scriptable)array), arrayType));
                    }
                    catch (EvaluatorException ee) {
                        return this.reportConversionError(from, target);
                    }
                    ++i;
                }
                return result;
            }
            Object result = arrayType.newArray(1);
            Array.set(result, 0, this.jsToJava(from, arrayType));
            return result;
        }
        Object unwrappedValue = Wrapper.unwrapped(from);
        TypeWrapperFactory<?> typeWrapper = this.factory.getTypeWrappers().getWrapperFactory(unwrappedValue, target);
        if (typeWrapper != null) {
            return typeWrapper.wrap(this, unwrappedValue, target);
        }
        switch (Context.getJSTypeCode(from)) {
            case 1: {
                if (target.isPrimitive()) {
                    return this.reportConversionError(from, target);
                }
                return null;
            }
            case 0: {
                if (target == TypeInfo.STRING || target == TypeInfo.OBJECT) {
                    return "undefined";
                }
                return this.reportConversionError(from, target);
            }
            case 2: {
                if (target.isBoolean() || target == TypeInfo.OBJECT) {
                    return from;
                }
                if (target == TypeInfo.STRING) {
                    return from.toString();
                }
                return this.internalJsToJavaLast(from, target);
            }
            case 3: {
                if (target == TypeInfo.STRING) {
                    return ScriptRuntime.toString(this, from);
                }
                if (target == TypeInfo.OBJECT) {
                    return this.coerceToNumber(TypeInfo.DOUBLE, from);
                }
                if (target.isPrimitive() && !target.isBoolean() || ScriptRuntime.NumberClass.isAssignableFrom(target.asClass())) {
                    return this.coerceToNumber(target, from);
                }
                return this.internalJsToJavaLast(from, target);
            }
            case 4: {
                if (target == TypeInfo.STRING || target.asClass().isInstance(from)) {
                    return from.toString();
                }
                if (target.isCharacter()) {
                    if (((CharSequence)from).length() == 1) {
                        return Character.valueOf(((CharSequence)from).charAt(0));
                    }
                    return this.coerceToNumber(target, from);
                }
                if (target.isPrimitive() && !target.isBoolean() || ScriptRuntime.NumberClass.isAssignableFrom(target.asClass())) {
                    return this.coerceToNumber(target, from);
                }
                return this.internalJsToJavaLast(from, target);
            }
            case 5: {
                if (target == TypeInfo.CLASS || target == TypeInfo.OBJECT) {
                    return unwrappedValue;
                }
                if (target == TypeInfo.STRING) {
                    return unwrappedValue.toString();
                }
                return this.internalJsToJavaLast(unwrappedValue, target);
            }
            case 6: 
            case 7: {
                if (target.isPrimitive()) {
                    if (target.isBoolean()) {
                        return this.internalJsToJavaLast(unwrappedValue, target);
                    }
                    return this.coerceToNumber(target, unwrappedValue);
                }
                if (target == TypeInfo.STRING) {
                    return unwrappedValue.toString();
                }
                if (target.asClass().isInstance(unwrappedValue)) {
                    return unwrappedValue;
                }
                return this.internalJsToJavaLast(unwrappedValue, target);
            }
            case 8: {
                if (target == TypeInfo.STRING) {
                    return ScriptRuntime.toString(this, from);
                }
                if (target.isPrimitive()) {
                    if (target.isBoolean()) {
                        return this.internalJsToJavaLast(from, target);
                    }
                    return this.coerceToNumber(target, from);
                }
                if (target.asClass().isInstance(from)) {
                    return from;
                }
                if (target == TypeInfo.DATE && from instanceof NativeDate) {
                    double time = ((NativeDate)from).getJSTimeValue();
                    return new Date((long)time);
                }
                if (from instanceof Wrapper) {
                    if (target.asClass().isInstance(unwrappedValue)) {
                        return unwrappedValue;
                    }
                    return this.internalJsToJavaLast(unwrappedValue, target);
                }
                if (target.asClass().isInterface() && (from instanceof NativeObject || from instanceof NativeFunction || from instanceof ArrowFunction)) {
                    return this.createInterfaceAdapter(target, (ScriptableObject)from);
                }
                return this.internalJsToJavaLast(from, target);
            }
        }
        return this.internalJsToJavaLast(from, target);
    }

    protected Object internalJsToJavaLast(Object from, TypeInfo target) {
        if (target instanceof TypeWrapperFactory) {
            TypeWrapperFactory f = (TypeWrapperFactory)((Object)target);
            return f.wrap(this, from, target);
        }
        return this.reportConversionError(from, target);
    }

    public final boolean canConvert(Object from, TypeInfo target) {
        return this.getConversionWeight(from, target) < 99;
    }

    public final int getConversionWeight(Object from, TypeInfo target) {
        int fcw = this.internalConversionWeight(from, target);
        if (fcw != 99) {
            return fcw;
        }
        if (target instanceof ArrayTypeInfo || Collection.class.isAssignableFrom(target.asClass())) {
            return 0;
        }
        if (target.is(TypeInfo.CLASS)) {
            return from instanceof Class || from instanceof NativeJavaClass ? 1 : 0;
        }
        if (from == null) {
            if (!target.isPrimitive()) {
                return 1;
            }
        } else if (from == Undefined.INSTANCE) {
            if (target == TypeInfo.STRING || target == TypeInfo.OBJECT) {
                return 1;
            }
        } else if (from instanceof CharSequence) {
            if (target == TypeInfo.STRING) {
                return 1;
            }
            if (target.asClass().isInstance(from)) {
                return 2;
            }
            if (target.isPrimitive()) {
                if (target.isCharacter()) {
                    return 3;
                }
                if (!target.isBoolean()) {
                    return 4;
                }
            }
        } else if (from instanceof Number) {
            if (target.isPrimitive()) {
                if (target.isDouble()) {
                    return 1;
                }
                if (!target.isBoolean()) {
                    return 1 + Context.getSizeRank(target);
                }
            } else {
                if (target == TypeInfo.STRING) {
                    return 9;
                }
                if (target == TypeInfo.OBJECT) {
                    return 10;
                }
                if (ScriptRuntime.NumberClass.isAssignableFrom(target.asClass())) {
                    return 2;
                }
            }
        } else if (from instanceof Boolean) {
            if (target.isBoolean()) {
                return 1;
            }
            if (target == TypeInfo.OBJECT) {
                return 3;
            }
            if (target == TypeInfo.STRING) {
                return 4;
            }
        } else if (from instanceof Class || from instanceof NativeJavaClass) {
            if (target.is(TypeInfo.CLASS)) {
                return 0;
            }
            if (target == TypeInfo.OBJECT) {
                return 3;
            }
            if (target == TypeInfo.STRING) {
                return 4;
            }
        }
        int fromCode = Context.getJSTypeCode(from);
        switch (fromCode) {
            case 6: 
            case 7: {
                Object javaObj = Wrapper.unwrapped(from);
                if (target.asClass().isInstance(javaObj)) {
                    return 0;
                }
                if (target == TypeInfo.STRING) {
                    return 2;
                }
                if (target.isPrimitive() && !target.isBoolean()) {
                    return fromCode == 7 ? 99 : 2 + Context.getSizeRank(target);
                }
                if (target instanceof ArrayTypeInfo) {
                    return 3;
                }
                return this.internalConversionWeightLast(from, target);
            }
            case 8: {
                if (target != TypeInfo.OBJECT && target.asClass().isInstance(from)) {
                    return 1;
                }
                if (target instanceof ArrayTypeInfo) {
                    if (from instanceof NativeArray) {
                        return 2;
                    }
                    return 1;
                }
                if (target == TypeInfo.OBJECT) {
                    return 3;
                }
                if (target == TypeInfo.STRING) {
                    return 4;
                }
                if (target == TypeInfo.DATE) {
                    if (!(from instanceof NativeDate)) break;
                    return 1;
                }
                if (target.isFunctionalInterface()) {
                    if (from instanceof NativeFunction) {
                        return 1;
                    }
                    if (from instanceof NativeObject) {
                        return 2;
                    }
                    return 12;
                }
                if (!target.isPrimitive() || target.isBoolean()) break;
                return 4 + Context.getSizeRank(target);
            }
        }
        return this.internalConversionWeightLast(from, target);
    }

    public static int getSizeRank(TypeInfo aType) {
        if (aType.isDouble()) {
            return 1;
        }
        if (aType.isFloat()) {
            return 2;
        }
        if (aType.isLong()) {
            return 3;
        }
        if (aType.isInt()) {
            return 4;
        }
        if (aType.isShort()) {
            return 5;
        }
        if (aType.isCharacter()) {
            return 6;
        }
        if (aType.isByte()) {
            return 7;
        }
        if (aType.isBoolean()) {
            return 99;
        }
        return 8;
    }

    protected Object coerceToNumber(TypeInfo target, Object value) {
        Class<?> valueClass = value.getClass();
        if (target.isCharacter()) {
            if (valueClass == ScriptRuntime.CharacterClass) {
                return value;
            }
            return Character.valueOf((char)this.toInteger(value, target, 0.0, 65535.0));
        }
        if (target == TypeInfo.OBJECT || target.isDouble()) {
            return valueClass == ScriptRuntime.DoubleClass ? value : Double.valueOf(this.toDouble(value));
        }
        if (target.isFloat()) {
            if (valueClass == ScriptRuntime.FloatClass) {
                return value;
            }
            double number = this.toDouble(value);
            if (Double.isInfinite(number) || Double.isNaN(number) || number == 0.0) {
                return Float.valueOf((float)number);
            }
            double absNumber = Math.abs(number);
            if (absNumber < (double)1.4E-45f) {
                return Float.valueOf(number > 0.0 ? 0.0f : -0.0f);
            }
            if (absNumber > 3.4028234663852886E38) {
                return Float.valueOf(number > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return Float.valueOf((float)number);
        }
        if (target.isInt()) {
            if (valueClass == ScriptRuntime.IntegerClass) {
                return value;
            }
            return (int)this.toInteger(value, target, -2.147483648E9, 2.147483647E9);
        }
        if (target.isLong()) {
            if (valueClass == ScriptRuntime.LongClass) {
                return value;
            }
            double max = Double.longBitsToDouble(4890909195324358655L);
            double min = Double.longBitsToDouble(-4332462841530417152L);
            return this.toInteger(value, target, min, max);
        }
        if (target.isShort()) {
            if (valueClass == ScriptRuntime.ShortClass) {
                return value;
            }
            return (short)this.toInteger(value, target, -32768.0, 32767.0);
        }
        if (target.isByte()) {
            if (valueClass == ScriptRuntime.ByteClass) {
                return value;
            }
            return (byte)this.toInteger(value, target, -128.0, 127.0);
        }
        return this.toDouble(value);
    }

    protected double toDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return ScriptRuntime.toNumber(this, (String)value);
        }
        if (value instanceof Scriptable) {
            if (value instanceof Wrapper) {
                return this.toDouble(((Wrapper)value).unwrap());
            }
            return ScriptRuntime.toNumber(this, value);
        }
        if (value instanceof DoubleSupplier) {
            return ((DoubleSupplier)value).getAsDouble();
        }
        return ScriptRuntime.toNumber(this, value.toString());
    }

    protected long toInteger(Object value, TypeInfo type, double min, double max) {
        double d = this.toDouble(value);
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.reportConversionError(ScriptRuntime.toString(this, value), type);
        }
        if ((d = d > 0.0 ? Math.floor(d) : Math.ceil(d)) < min || d > max) {
            this.reportConversionError(ScriptRuntime.toString(this, value), type);
        }
        return (long)d;
    }

    public Object reportConversionError(Object value, TypeInfo type) {
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", String.valueOf(value), type.signature(), this);
    }

    public String defaultObjectToSource(Scriptable scope, Scriptable thisObj, Object[] args) {
        return "not_supported";
    }

    public void initJSON(ScriptableObject scope, boolean sealed) {
        try {
            NativeGSON.initGSON(scope, sealed, this);
        }
        catch (Throwable ex) {
            NativeJSON.init(scope, sealed, this);
        }
    }

    public CachedClassStorage getCachedClassStorage(boolean includeProtected) {
        return includeProtected ? CachedClassStorage.GLOBAL_PROTECTED : this.factory.getCachedClassStorage();
    }
}

