/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.core.IngredientKJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.IngredientWrapper;
import dev.latvian.mods.kubejs.script.SourceLine;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

@Info(value="Various SizedIngredient related helper methods")
public interface SizedIngredientWrapper {
    public static final TypeInfo TYPE_INFO = TypeInfo.of(SizedIngredient.class);
    @Info(value="A completely empty ingredient that will only match air")
    public static final SizedIngredient empty = new SizedIngredient(Ingredient.EMPTY, 1);
    @Info(value="An ingredient that matches everything")
    public static final SizedIngredient all = new SizedIngredient(IngredientWrapper.all, 1);

    @Info(value="Returns a sized ingredient of the input")
    public static SizedIngredient of(SizedIngredient ingredient) {
        return ingredient;
    }

    @Info(value="Returns a sized ingredient of the input")
    public static SizedIngredient of(Ingredient ingredient, int count) {
        return new SizedIngredient(ingredient, count);
    }

    public static SizedIngredient ofTag(TagKey<Item> tag, int count) {
        return SizedIngredient.of(tag, (int)count);
    }

    @HideFromJS
    private static SizedIngredient wrapTrivial(Context cx, Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SizedIngredient.class, Ingredient.class, ItemStack.class, ItemLike.class}, (Object)object, n)) {
            case 0 -> {
                SizedIngredient s;
                yield s = (SizedIngredient)object;
            }
            case 1 -> {
                Ingredient ingredient = (Ingredient)object;
                yield ingredient.kjs$asStack();
            }
            case 2 -> {
                ItemStack stack = (ItemStack)object;
                yield Ingredient.of((ItemStack[])new ItemStack[]{stack.kjs$withCount(1)}).kjs$withCount(stack.getCount());
            }
            case 3 -> {
                ItemLike item = (ItemLike)object;
                yield Ingredient.of((ItemLike[])new ItemLike[]{item}).kjs$asStack();
            }
            default -> null;
        };
    }

    @HideFromJS
    public static DataResult<SizedIngredient> wrapResult(Context cx, Object from) {
        SizedIngredient trivial = SizedIngredientWrapper.wrapTrivial(cx, from);
        if (trivial != null) {
            return DataResult.success((Object)trivial);
        }
        if (from instanceof CharSequence) {
            try {
                return SizedIngredientWrapper.read(cx, new StringReader(from.toString()));
            }
            catch (Exception ex) {
                return DataResult.error(() -> "Error parsing sized ingredient: " + String.valueOf(ex));
            }
        }
        return IngredientWrapper.wrapResult(cx, from).map(IngredientKJS::kjs$asStack);
    }

    @HideFromJS
    public static SizedIngredient wrap(Context cx, Object from) {
        SizedIngredient trivial = SizedIngredientWrapper.wrapTrivial(cx, from);
        if (trivial != null) {
            return trivial;
        }
        return (SizedIngredient)SizedIngredientWrapper.wrapResult(cx, from).getOrThrow(error -> new KubeRuntimeException("Failed to read ingredient from %s: %s".formatted(from, error)).source(SourceLine.of(cx)));
    }

    @HideFromJS
    public static DataResult<SizedIngredient> read(Context cx, StringReader reader) throws CommandSyntaxException {
        int count;
        if (StringReader.isAllowedNumber((char)reader.peek())) {
            count = Mth.ceil((double)reader.readDouble());
            reader.skipWhitespace();
            reader.expect('x');
            reader.skipWhitespace();
            if (count < 1) {
                return DataResult.error(() -> "SizedIngredient count smaller than 1 is not allowed!");
            }
        } else {
            count = 1;
        }
        return IngredientWrapper.read(cx, reader).map(ingredient -> ingredient.kjs$withCount(count));
    }
}

