/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.net;

import dev.latvian.mods.kubejs.net.KubeJSNet;
import dev.latvian.mods.kubejs.net.NetworkKubeEvent;
import dev.latvian.mods.kubejs.plugin.builtin.event.NetworkEvents;
import dev.latvian.mods.kubejs.script.ScriptType;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public record SendDataFromClientPayload(String channel, CompoundTag data) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, SendDataFromClientPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SendDataFromClientPayload::channel, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SendDataFromClientPayload::data, SendDataFromClientPayload::new);

    public SendDataFromClientPayload(String channel, @Nullable CompoundTag data) {
        this.channel = channel;
        this.data = Objects.requireNonNullElseGet(data, CompoundTag::new);
    }

    public CustomPacketPayload.Type<?> type() {
        return KubeJSNet.SEND_DATA_FROM_CLIENT;
    }

    public void handle(IPayloadContext ctx) {
        Player player;
        if (!this.channel.isEmpty() && (player = ctx.player()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (NetworkEvents.DATA_RECEIVED.hasListeners(this.channel)) {
                ctx.enqueueWork(() -> NetworkEvents.DATA_RECEIVED.post(ScriptType.SERVER, this.channel, new NetworkKubeEvent((Player)serverPlayer, this.channel, this.data)));
            }
        }
    }
}

