/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.config;

import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import net.createmod.catnip.config.ConfigBase;

public class CLoader
extends ConfigBase {
    public final ConfigBase.ConfigInt chunkUpdateInterval = this.i(10, 0, 200, "chunkUpdateInterval", new String[]{Comments.chunkUpdateInterval});
    public final ConfigBase.ConfigInt unloadGracePeriod = this.i(20, 0, 1200, "unloadGracePeriod", new String[]{Comments.unloadGracePeriod});
    public final ConfigBase.ConfigFloat speedMultiplier = this.f(1.0f, 0.0f, 128.0f, "speedMultiplier", new String[]{Comments.speedMultiplier});
    public final ConfigBase.ConfigFloat stressImpact = this.f(16.0f, 0.0f, Float.MAX_VALUE, "stressImpact", new String[]{Comments.stressImpact});
    public final ConfigBase.ConfigBool enableStatic = this.b(true, "enableStatic", new String[]{Comments.enableStatic});
    public final ConfigBase.ConfigBool enableContraption;
    public final ConfigBase.ConfigInt rangeOnContraption = this.i(2, 1, 10, "rangeOnContraption", new String[]{Comments.rangeOnContraption});
    public final ConfigBase.ConfigBool enableTrain;
    public final ConfigBase.ConfigInt rangeOnTrain = this.i(2, 1, 10, "rangeOnTrain", new String[]{Comments.rangeOnTrain});
    public final ConfigBase.ConfigBool enableStation;
    public final ConfigBase.ConfigInt rangeOnStation = this.i(2, 1, 10, "rangeOnStation", new String[]{Comments.rangeOnStation});
    private final LoaderType type;

    public CLoader(LoaderType type) {
        this.type = type;
        this.enableContraption = this.b(type == LoaderType.BRASS, "enableContraption", new String[]{Comments.enableContraption});
        this.enableTrain = this.b(type == LoaderType.BRASS, "enableTrain", new String[]{Comments.enableTrain});
        this.enableStation = this.b(type == LoaderType.BRASS, "enableStation", new String[]{Comments.enableStation});
    }

    public boolean modeEnabled(LoaderMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case LoaderMode.STATIC -> (Boolean)this.enableStatic.get();
            case LoaderMode.CONTRAPTION -> (Boolean)this.enableContraption.get();
            case LoaderMode.TRAIN -> (Boolean)this.enableTrain.get();
            case LoaderMode.STATION -> (Boolean)this.enableStation.get();
        };
    }

    public String getName() {
        return this.type.getSerializedName();
    }

    private static class Comments {
        static String chunkUpdateInterval = "Number of ticks between chunk loading checks. Does not affect contraptions";
        static String unloadGracePeriod = "Minimum number of ticks between loss of power and chunk unloading. Rounds up to multiples of update interval";
        static String speedMultiplier = "A multiplier for the minimum speed requirement of a chunk loader";
        static String stressImpact = "The stress impact of a chunk loader when it is at 1 RPM";
        static String enableStatic = "Whether the chunk loader functions on the ground when given rotational power";
        static String enableContraption = "Whether the chunk loader functions on contraptions other than trains. WARNING: does not update contraptions that are currently unloaded";
        static String rangeOnContraption = "Chunk loading radius on contraptions. 1 = 1 chunk, 2 = 9 chunks. Contraptions require a minimum radius of 2 for reliable loading";
        static String enableTrain = "Whether the chunk loader functions on trains";
        static String rangeOnTrain = "Chunk loading radius on trains. 1 = 1 chunk, 2 = 9 chunks";
        static String enableStation = "Whether the chunk loader functions when attached to train stations.";
        static String rangeOnStation = "Chunk loading radius on train stations. 1 = 1 chunk, 2 = 9 chunks";

        private Comments() {
        }
    }
}

