/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;

public class EmiFireworkRocketRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::byColor).toList();

    public EmiFireworkRocketRecipe(ResourceLocation id) {
        super(List.of(EmiStack.of((ItemLike)Items.PAPER), EmiStack.of((ItemLike)Items.FIREWORK_STAR), EmiStack.of((ItemLike)Items.GUNPOWDER)), EmiStack.of((ItemLike)Items.FIREWORK_ROCKET), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of((ItemLike)Items.PAPER), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<EmiStack> items = this.getItems((Random)r);
            if (s < items.size()) {
                return items.get(s);
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getFireworkRocket, this.unique, x, y);
    }

    private EmiStack getFireworkRocket(Random random) {
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        List<EmiStack> items = this.getItems(random);
        int gunpowder = 0;
        for (EmiStack item : items) {
            if (item.getId() == EmiStack.of((ItemLike)Items.FIREWORK_STAR).getId()) {
                explosions.add(item.getOrDefault(DataComponents.FIREWORK_EXPLOSION, FireworkExplosion.DEFAULT));
                continue;
            }
            if (!item.isEqual(EmiStack.of((ItemLike)Items.GUNPOWDER))) continue;
            ++gunpowder;
        }
        stack.set(DataComponents.FIREWORKS, (Object)new Fireworks(gunpowder, explosions));
        return EmiStack.of(stack, 3L);
    }

    private List<EmiStack> getItems(Random random) {
        int i;
        ArrayList items = Lists.newArrayList();
        int amount = random.nextInt(3);
        for (i = 0; i <= amount; ++i) {
            items.add(EmiStack.of((ItemLike)Items.GUNPOWDER));
        }
        amount = random.nextInt(8 - items.size());
        for (i = 0; i <= amount; ++i) {
            items.add(this.getFireworkStar(random));
        }
        return items;
    }

    private List<DyeItem> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private EmiStack getFireworkStar(Random random) {
        IntList fadedColors;
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_STAR);
        int items = 0;
        int amount = random.nextInt(5);
        FireworkExplosion.Shape type = FireworkExplosion.Shape.values()[random.nextInt(FireworkExplosion.Shape.values().length)];
        if (amount != 0) {
            ++items;
        }
        amount = random.nextInt(4);
        boolean flicker = false;
        boolean trail = false;
        if (amount == 0) {
            flicker = true;
            ++items;
        } else if (amount == 1) {
            trail = true;
            ++items;
        } else if (amount == 2) {
            flicker = true;
            trail = true;
            items += 2;
        }
        List<DyeItem> dyeItems = this.getDyes(random, 8 - items);
        IntArrayList colors = new IntArrayList();
        for (DyeItem dyeItem : dyeItems) {
            colors.add(dyeItem.getDyeColor().getFireworkColor());
        }
        amount = random.nextInt(2);
        if (amount == 1) {
            List<DyeItem> dyeItemsFaded = this.getDyes(random, 8);
            fadedColors = new IntArrayList();
            for (DyeItem dyeItem : dyeItemsFaded) {
                fadedColors.add(dyeItem.getDyeColor().getFireworkColor());
            }
        } else {
            fadedColors = IntLists.emptyList();
        }
        FireworkExplosion component = new FireworkExplosion(type, (IntList)colors, fadedColors, trail, flicker);
        stack.set(DataComponents.FIREWORK_EXPLOSION, (Object)component);
        return EmiStack.of(stack);
    }
}

