/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.data.mob_spawning;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import me.wesley1808.servercore.common.config.data.mob_spawning.EnforcedMobcap;
import me.wesley1808.servercore.common.config.data.mob_spawning.MobSpawnEntry;
import me.wesley1808.servercore.common.config.impl.mob_spawning.MobSpawnEntryImpl;
import me.wesley1808.servercore.common.interfaces.IMobCategory;
import net.minecraft.world.entity.MobCategory;
import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.SubSection;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

public interface MobSpawnConfig {
    @AnnotationBasedSorter.Order(value=1)
    @SubSection
    @ConfKey(value="zombie-reinforcements")
    @ConfComments(value={"Mobcap settings for zombie reinforcements.", "\u25ba enforce-mobcaps = Whether to enforce mobcaps for this type of mobspawning.", "\u25ba additional-capacity = Additional capacity for this specific mobcap. Decides how much it can spawn over the regular mobcap.", "It is recommended to allow them to spawn a bit over the regular mobcap as they would otherwise never get a chance to spawn."})
    public EnforcedMobcap zombieReinforcements();

    @AnnotationBasedSorter.Order(value=2)
    @SubSection
    @ConfKey(value="nether-portal-randomticks")
    @ConfComments(value={"Mobcap settings for zombified piglin spawning from nether portal random ticks."})
    public EnforcedMobcap portalRandomTicks();

    @AnnotationBasedSorter.Order(value=3)
    @SubSection
    @ConfKey(value="monster-spawners")
    @ConfComments(value={"Mobcap settings for mobs spawned from monster spawners."})
    public EnforcedMobcap monsterSpawner();

    @AnnotationBasedSorter.Order(value=4)
    @SubSection
    @ConfKey(value="infested")
    @ConfComments(value={"Mobcap settings for silverfish spawned from the infested potion effect."})
    public EnforcedMobcap infested();

    @AnnotationBasedSorter.Order(value=5)
    @ConfKey(value="categories")
    @ConfDefault.DefaultObject(value="defaultCategories")
    @ConfComments(value={"A list of mob categories with their respective mobcap and spawn interval.", "\u25ba category = The vanilla spawn category.", "\u25ba mobcap = The maximum amount of entities in the same category that can spawn near a player.", "\u25ba spawn-interval = The interval between spawn attempts in ticks. Higher values mean less frequent spawn attempts."})
    public List<@SubSection MobSpawnEntry> categories();

    public static List<MobSpawnEntry> defaultCategories() {
        ObjectArrayList entries = new ObjectArrayList();
        for (MobCategory category : MobCategory.values()) {
            if (category == MobCategory.MISC) continue;
            entries.add((Object)new MobSpawnEntryImpl(category, IMobCategory.getOriginalCapacity(category), category.isPersistent() ? 400 : 1));
        }
        return entries;
    }
}

