/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import me.srrapero720.waterframes.common.block.data.types.PositionHorizontal;
import me.srrapero720.waterframes.common.block.data.types.PositionVertical;
import me.srrapero720.waterframes.common.screens.styles.IconStyles;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.joml.Matrix4f;
import team.creative.creativecore.common.gui.control.simple.GuiIcon;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.util.math.geo.Rect;

public class WidgetClickableArea
extends GuiIcon {
    private PositionHorizontal x;
    private PositionVertical y;
    private boolean selected = false;

    public WidgetClickableArea(String name, PositionHorizontal x, PositionVertical y) {
        super(name, IconStyles.POS_BASE);
        this.x = x;
        this.y = y;
    }

    protected void renderContent(GuiGraphics graphics, Rect control, Rect rect, double scale, int mouseX, int mouseY) {
        super.renderContent(graphics, control, rect, scale, mouseX, mouseY);
        this.renderSelector(graphics, control, rect, mouseX, mouseY);
    }

    protected void renderSelector(GuiGraphics graphics, Rect control, Rect rect, int mouseX, int mouseY) {
        PoseStack pose = graphics.pose();
        Icon icon = IconStyles.POS_ICON;
        float width = (float)rect.getWidth() / 3.0f;
        float height = (float)rect.getWidth() / 3.0f;
        float offsetX = switch (this.x) {
            default -> throw new MatchException(null, null);
            case PositionHorizontal.LEFT -> 0.0f;
            case PositionHorizontal.CENTER -> width;
            case PositionHorizontal.RIGHT -> (float)((double)width * 2.0);
        };
        float offsetY = switch (this.y) {
            default -> throw new MatchException(null, null);
            case PositionVertical.TOP -> 0.0f;
            case PositionVertical.CENTER -> height;
            case PositionVertical.BOTTOM -> (float)((double)height * 2.0);
        };
        pose.pushPose();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon.location());
        this.color.glColor();
        Matrix4f matrix = pose.last().pose();
        float x = offsetX;
        float x2 = offsetX + width;
        float y = offsetY;
        float y2 = offsetY + height;
        float u = (float)icon.minX() / 256.0f;
        float v = (float)icon.minY() / 256.0f;
        float u2 = (float)(icon.minX() + icon.width()) / 256.0f;
        float v2 = (float)(icon.minY() + icon.height()) / 256.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix, x, y2, 0.0f).setUv(u, v2);
        bufferbuilder.addVertex(matrix, x2, y2, 0.0f).setUv(u2, v2);
        bufferbuilder.addVertex(matrix, x2, y, 0.0f).setUv(u2, v);
        bufferbuilder.addVertex(matrix, x, y, 0.0f).setUv(u, v);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
        pose.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        WidgetClickableArea.playSound((Holder.Reference)SoundEvents.UI_BUTTON_CLICK);
        this.selected = true;
        this.mouseMoved(mouseX, mouseY);
        return true;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        if (this.selected) {
            int areaX = (int)(mouseX / (double)this.rect.getWidth() * 3.0);
            int areaY = (int)(mouseY / (double)this.rect.getHeight() * 3.0);
            this.x = switch (areaX) {
                case 0 -> PositionHorizontal.LEFT;
                case 1 -> PositionHorizontal.CENTER;
                case 2, 3 -> PositionHorizontal.RIGHT;
                default -> areaX > 3 ? PositionHorizontal.RIGHT : PositionHorizontal.LEFT;
            };
            this.y = switch (areaY) {
                case 0 -> PositionVertical.TOP;
                case 1 -> PositionVertical.CENTER;
                case 2, 3 -> PositionVertical.BOTTOM;
                default -> areaY > 3 ? PositionVertical.BOTTOM : PositionVertical.TOP;
            };
        }
    }

    public void mouseReleased(double x, double y, int button) {
        this.selected = false;
        super.mouseReleased(x, y, button);
    }

    public List<Component> getTooltip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.desc"));
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.vertical", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.y.name().toLowerCase()))}));
        tooltips.add((Component)WidgetClickableArea.translatable((String)"waterframes.gui.position.horizontal", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + WidgetClickableArea.translate((String)("waterframes.gui.position." + this.x.name().toLowerCase()))}));
        return tooltips;
    }

    public PositionHorizontal getX() {
        return this.x;
    }

    public PositionVertical getY() {
        return this.y;
    }
}

