/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes;

import com.mojang.brigadier.CommandDispatcher;
import java.util.UUID;
import java.util.function.Supplier;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.rendering.DisplayRenderer;
import me.srrapero720.waterframes.client.rendering.TextureWrapper;
import me.srrapero720.waterframes.common.block.BigTvBlock;
import me.srrapero720.waterframes.common.block.DisplayBlock;
import me.srrapero720.waterframes.common.block.FrameBlock;
import me.srrapero720.waterframes.common.block.ProjectorBlock;
import me.srrapero720.waterframes.common.block.TVBoxBlock;
import me.srrapero720.waterframes.common.block.TvBlock;
import me.srrapero720.waterframes.common.block.entity.BigTvTile;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.block.entity.FrameTile;
import me.srrapero720.waterframes.common.block.entity.ProjectorTile;
import me.srrapero720.waterframes.common.block.entity.TVBoxTile;
import me.srrapero720.waterframes.common.block.entity.TvTile;
import me.srrapero720.waterframes.common.commands.WaterFramesCommand;
import me.srrapero720.waterframes.common.item.RemoteControl;
import me.srrapero720.waterframes.common.item.data.CodecManager;
import me.srrapero720.waterframes.common.item.data.RemoteData;
import me.srrapero720.waterframes.common.network.DisplayNetwork;
import me.srrapero720.waterframes.common.network.packets.ActivePacket;
import me.srrapero720.waterframes.common.network.packets.DataListSyncPacket;
import me.srrapero720.waterframes.common.network.packets.DataSyncPacket;
import me.srrapero720.waterframes.common.network.packets.LoopPacket;
import me.srrapero720.waterframes.common.network.packets.MutePacket;
import me.srrapero720.waterframes.common.network.packets.NextPacket;
import me.srrapero720.waterframes.common.network.packets.PausePacket;
import me.srrapero720.waterframes.common.network.packets.PositionPacket;
import me.srrapero720.waterframes.common.network.packets.PreviousPacket;
import me.srrapero720.waterframes.common.network.packets.TimePacket;
import me.srrapero720.waterframes.common.network.packets.VolumePacket;
import me.srrapero720.waterframes.common.network.packets.VolumeRangePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.watermedia.WaterMedia;
import org.watermedia.api.image.ImageAPI;

@EventBusSubscriber(modid="waterframes")
public class DisplaysRegistry {
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"waterframes");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"waterframes");
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"waterframes");
    private static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"waterframes");
    public static final DeferredRegister<DataComponentType<?>> DATA = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"waterframes");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<RemoteData>> REMOTE_DATA = DATA.register("remote", () -> new DataComponentType.Builder().persistent(CodecManager.REMOTE_CODEC).networkSynchronized(CodecManager.REMOTE_STREAM_CODEC).build());
    public static final DeferredBlock<DisplayBlock> FRAME = BLOCKS.register("frame", () -> new FrameBlock());
    public static final DeferredBlock<DisplayBlock> PROJECTOR = BLOCKS.register("projector", () -> new ProjectorBlock());
    public static final DeferredBlock<DisplayBlock> TV = BLOCKS.register("tv", () -> new TvBlock());
    public static final DeferredBlock<DisplayBlock> BIG_TV = BLOCKS.register("big_tv", () -> new BigTvBlock());
    public static final DeferredBlock<DisplayBlock> TV_BOX = BLOCKS.register("tv_box", () -> new TVBoxBlock());
    public static final DeferredItem<Item> REMOTE_ITEM = ITEMS.register("remote", () -> new RemoteControl(DisplaysRegistry.remoteProp()));
    public static final DeferredItem<Item> FRAME_ITEM = ITEMS.register("frame", () -> new BlockItem((Block)FRAME.get(), DisplaysRegistry.prop()));
    public static final DeferredItem<Item> PROJECTOR_ITEM = ITEMS.register("projector", () -> new BlockItem((Block)PROJECTOR.get(), DisplaysRegistry.prop()));
    public static final DeferredItem<Item> TV_ITEM = ITEMS.register("tv", () -> new BlockItem((Block)TV.get(), DisplaysRegistry.prop()));
    public static final DeferredItem<Item> BIG_TV_ITEM = ITEMS.register("big_tv", () -> new BlockItem((Block)BIG_TV.get(), DisplaysRegistry.prop()));
    public static final DeferredItem<Item> TV_BOX_ITEM = ITEMS.register("tv_box", () -> new BlockItem((Block)TV_BOX.get(), DisplaysRegistry.prop()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_FRAME = DisplaysRegistry.tile("frame", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)FrameTile::new), FRAME);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_PROJECTOR = DisplaysRegistry.tile("projector", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)ProjectorTile::new), PROJECTOR);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_TV = DisplaysRegistry.tile("tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)TvTile::new), TV);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_BIG_TV = DisplaysRegistry.tile("big_tv", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)BigTvTile::new), BIG_TV);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> TILE_TV_BOX = DisplaysRegistry.tile("tv_box", (BlockEntityType.BlockEntitySupplier<DisplayTile>)((BlockEntityType.BlockEntitySupplier)TVBoxTile::new), TV_BOX);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> WATERTAB = TABS.register("tab", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).icon(() -> new ItemStack((ItemLike)FRAME.get())).title((Component)Component.translatable((String)"itemGroup.waterframes")).build());
    public static final PermissionNode<Boolean> PERM_DISPLAYS_EDIT = DisplaysRegistry.permission("waterframes.displays.save", false, "Save changes on displays", "Allows saving whitelisted URLs");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT = DisplaysRegistry.permission("waterframes.displays.interact", true, "Interact with displays", "Allows interact (open) the Gui of all displays");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT_FRAME = DisplaysRegistry.permission("waterframes.displays.interact.frame", true, "Interact with frame display", "Allows interact (open) the Gui of frame display");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT_PROJECTOR = DisplaysRegistry.permission("waterframes.displays.interact.projector", true, "Interact with frame display", "Allows interact (open) the Gui of projector display");
    public static final PermissionNode<Boolean> PERM_DISPLAYS_INTERACT_TV = DisplaysRegistry.permission("waterframes.displays.interact.tv", true, "Interact with frame display", "Allows interact (open) the Gui of tv display");
    public static final PermissionNode<Boolean> PERM_REMOTE_INTERACT = DisplaysRegistry.permission("waterframes.remote.interact", true, "Interact with remotes", "Allows interact (open) the Gui of remotes");
    public static final PermissionNode<Boolean> PERM_REMOTE_BIND = DisplaysRegistry.permission("waterframes.remote.bind", true, "Bind remotes to displays", "Allows bind displays on remotes");
    public static final PermissionNode<Boolean> PERM_WHITELIST_BYPASS = DisplaysRegistry.permission("waterframes.whitelist.bypass", false, "Bypass whitelisted URLS", "Allows to bypass whitelisted URLS");

    private static PermissionNode<Boolean> permission(String node, boolean def, String title, String desc) {
        return new PermissionNode("waterframes", node, PermissionTypes.BOOLEAN, (player, uuid, context) -> def, new PermissionDynamicContextKey[0]).setInformation((Component)Component.literal((String)title), (Component)Component.literal((String)desc));
    }

    public static boolean getPermBoolean(UUID player, PermissionNode<Boolean> node) {
        return (Boolean)PermissionAPI.getOfflinePermission((UUID)player, node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
    }

    private static DeferredHolder<BlockEntityType<?>, BlockEntityType<DisplayTile>> tile(String name, BlockEntityType.BlockEntitySupplier<DisplayTile> creator, Supplier<DisplayBlock> block) {
        return TILES.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)creator, (Block[])new Block[]{(Block)block.get()}).build(null));
    }

    private static Item.Properties remoteProp() {
        return new Item.Properties().stacksTo(1).rarity(Rarity.RARE).setNoRepair().fireResistant();
    }

    private static Item.Properties prop() {
        return new Item.Properties().stacksTo(16).rarity(Rarity.RARE);
    }

    public static void init(IEventBus bus, ModContainer container) {
        DATA.register(bus);
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TILES.register(bus);
        TABS.register(bus);
    }

    @SubscribeEvent
    public static void registerPermissions(PermissionGatherEvent.Nodes e) {
        e.addNodes(new PermissionNode[]{PERM_DISPLAYS_EDIT, PERM_DISPLAYS_INTERACT, PERM_DISPLAYS_INTERACT_FRAME, PERM_DISPLAYS_INTERACT_PROJECTOR, PERM_DISPLAYS_INTERACT_TV, PERM_REMOTE_BIND, PERM_REMOTE_INTERACT, PERM_WHITELIST_BYPASS});
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        WaterFramesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerCommands(RegisterClientCommandsEvent event) {
        WaterFramesCommand.registerClient((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerTexture(ResourceLocation location, AbstractTexture texture) {
        Minecraft.getInstance().getTextureManager().register(location, texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void unregisterTexture(ResourceLocation location) {
        Minecraft.getInstance().getTextureManager().release(location);
    }

    public static class UnsupportedModException
    extends UnsupportedOperationException {
        private static final String MSG_REASON = "\u00a7fMod \u00a76'%s' \u00a7fis not compatible with \u00a7e'%s' \u00a7fbecause \u00a7c%s \u00a7fplease remove it";

        public UnsupportedModException(String modid, String reason) {
            super(String.format(MSG_REASON, modid, "WATERFrAMES", reason));
        }
    }

    @EventBusSubscriber(modid="waterframes")
    public static class ModEvents {
        @SubscribeEvent
        public static void onCreativeTabsLoading(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == WATERTAB.getKey()) {
                event.accept(REMOTE_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(FRAME_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(PROJECTOR_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(TV_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(BIG_TV_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                event.accept(TV_BOX_ITEM, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }

        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            DisplayNetwork.NET.registerType(DataSyncPacket.class, DataSyncPacket::new);
            DisplayNetwork.NET.registerType(DataListSyncPacket.class, DataListSyncPacket::new);
            DisplayNetwork.NET.registerType(NextPacket.class, NextPacket::new);
            DisplayNetwork.NET.registerType(PreviousPacket.class, PreviousPacket::new);
            DisplayNetwork.NET.registerType(ActivePacket.class, ActivePacket::new);
            DisplayNetwork.NET.registerType(LoopPacket.class, LoopPacket::new);
            DisplayNetwork.NET.registerType(MutePacket.class, MutePacket::new);
            DisplayNetwork.NET.registerType(PausePacket.class, PausePacket::new);
            DisplayNetwork.NET.registerType(TimePacket.class, TimePacket::new);
            DisplayNetwork.NET.registerType(VolumePacket.class, VolumePacket::new);
            DisplayNetwork.NET.registerType(VolumeRangePacket.class, VolumeRangePacket::new);
            DisplayNetwork.NET.registerType(PositionPacket.class, PositionPacket::new);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void init(FMLClientSetupEvent e) {
            WaterFrames.LOGGER.info(WaterMedia.IT, "Running WATERFrAMES v{}", (Object)ModList.get().getModFileById("waterframes").versionString());
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerOtherStuff(FMLClientSetupEvent e) {
            e.enqueueWork(() -> DisplaysRegistry.registerTexture(WaterFrames.LOADING_ANIMATION, new TextureWrapper.Renderer(ImageAPI.loadingGif((String)"waterframes"))));
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerTileRenderer(EntityRenderersEvent.RegisterRenderers e) {
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_FRAME.get()), DisplayRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_PROJECTOR.get()), DisplayRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_TV.get()), DisplayRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_BIG_TV.get()), DisplayRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)TILE_TV_BOX.get()), DisplayRenderer::new);
        }
    }
}

