/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VanillaCopiesServer {
    public static DamageSource create(Level level, ResourceKey<DamageType> key, Entity attacker) {
        Holder.Reference damageType = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(key);
        return new DamageSource((Holder)damageType, attacker);
    }

    public static void travel(Vec3 relative, LivingEntity entity, float baseFrictionCoefficient) {
        if (entity.isInWater()) {
            entity.moveRelative(0.02f, relative);
            entity.move(MoverType.SELF, entity.getDeltaMovement());
            entity.setDeltaMovement(entity.getDeltaMovement().scale((double)0.8f));
        } else if (entity.isInLava()) {
            entity.moveRelative(0.02f, relative);
            entity.move(MoverType.SELF, entity.getDeltaMovement());
            entity.setDeltaMovement(entity.getDeltaMovement().scale(0.5));
        } else {
            float friction = entity.onGround() ? entity.level().getBlockState(BlockPos.containing((double)entity.getX(), (double)(entity.getY() - 1.0), (double)entity.getZ())).getBlock().getFriction() * baseFrictionCoefficient : baseFrictionCoefficient;
            float g = 0.16277137f / (friction * friction * friction);
            entity.moveRelative(entity.onGround() ? 0.1f * g : 0.02f, relative);
            entity.move(MoverType.SELF, entity.getDeltaMovement());
            entity.setDeltaMovement(entity.getDeltaMovement().scale((double)friction));
        }
        entity.calculateEntityAnimation(false);
    }

    public static void lookAtTarget(Mob mobEntity, Vec3 target, float maxYawChange, float maxPitchChange) {
        double d = target.x - mobEntity.getX();
        double e = target.z - mobEntity.getZ();
        double g = target.y - mobEntity.getEyeY();
        double h = Math.sqrt(d * d + e * e);
        float i = (float)(Mth.atan2((double)e, (double)d) * 57.2957763671875 - 90.0);
        float j = (float)(-(Mth.atan2((double)g, (double)h) * 57.2957763671875));
        mobEntity.setXRot(VanillaCopiesServer.changeAngle(mobEntity.getXRot(), j, maxPitchChange));
        mobEntity.setYRot(VanillaCopiesServer.changeAngle(mobEntity.getYRot(), i, maxYawChange));
    }

    public static float changeAngle(float oldAngle, float newAngle, float maxChangeInAngle) {
        float f = Mth.wrapDegrees((float)(newAngle - oldAngle));
        if (f > maxChangeInAngle) {
            f = maxChangeInAngle;
        }
        if (f < -maxChangeInAngle) {
            f = -maxChangeInAngle;
        }
        return oldAngle + f;
    }

    public static boolean hasDirectLineOfSight(Vec3 to, Vec3 from, BlockGetter level, Entity entity) {
        ClipContext context = new ClipContext(to, from, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        return level.clip(context).getType() == HitResult.Type.MISS;
    }

    public static void awardExperience(int amount, Vec3 pos, Level level) {
        int i;
        for (int amt = amount; amt > 0; amt -= i) {
            i = ExperienceOrb.getExperienceValue((int)amt);
            level.addFreshEntity((Entity)new ExperienceOrb(level, pos.x, pos.y, pos.z, i));
        }
    }

    public static int getBlockLight(Entity entity, BlockPos blockPos) {
        return entity.isOnFire() ? 15 : entity.level().getBrightness(LightLayer.BLOCK, blockPos);
    }

    public static void destroyBlocks(Entity entity, AABB aabb) {
        int i = Mth.floor((double)aabb.minX);
        int j = Mth.floor((double)aabb.minY);
        int k = Mth.floor((double)aabb.minZ);
        int l = Mth.floor((double)aabb.maxX);
        int m = Mth.floor((double)aabb.maxY);
        int n = Mth.floor((double)aabb.maxZ);
        boolean bl2 = false;
        for (int o = i; o <= l; ++o) {
            for (int p = j; p <= m; ++p) {
                for (int q = k; q <= n; ++q) {
                    BlockPos blockPos = new BlockPos(o, p, q);
                    BlockState blockState = entity.level().getBlockState(blockPos);
                    if (blockState.isAir() || blockState.getBlock() != Blocks.FIRE || !entity.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || blockState.is(BlockTags.WITHER_IMMUNE)) continue;
                    bl2 = entity.level().destroyBlock(blockPos, false) || bl2;
                }
            }
        }
    }

    public static void onBreakInCreative(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue((Property)DoublePlantBlock.HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState = level.getBlockState(blockPos = pos.below())).getBlock() == state.getBlock() && blockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
    }
}

