/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure.structure_repair;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.structure.BMDStructures;
import com.cerbon.bosses_of_mass_destruction.structure.structure_repair.StructureRepair;
import com.cerbon.cerbons_api.api.static_utilities.ParticleUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class GauntletStructureRepair
implements StructureRepair {
    @Override
    public ResourceKey<Structure> associatedStructure() {
        return BMDStructures.GAUNTLET_STRUCTURE_REGISTRY.getConfiguredStructureKey();
    }

    @Override
    public void repairStructure(ServerLevel level, StructureStart structureStart) {
        BlockPos pos = this.runeCenter(structureStart);
        ParticleUtils.spawnParticle((ServerLevel)level, (ParticleOptions)((ParticleOptions)BMDParticles.GAUNTLET_REVIVE_SPARKLES.get()), (Vec3)VecUtils.asVec3((BlockPos)pos.above(5)), (Vec3)VecUtils.unit.scale(3.0), (int)100, (double)0.0);
        this.spawnBlocks(level, pos);
    }

    @Override
    public boolean shouldRepairStructure(ServerLevel level, StructureStart structureStart) {
        BlockPos pos = this.runeCenter(structureStart);
        boolean hasSealAlready = level.getBlockState(pos.above()).getBlock() == BMDBlocks.GAUNTLET_BLACKSTONE.get();
        boolean noBoss = level.getEntities((EntityTypeTest)BMDEntities.GAUNTLET.get(), entity -> entity.distanceToSqr(VecUtils.asVec3((BlockPos)pos)) < 10000.0).isEmpty();
        return !hasSealAlready && noBoss;
    }

    private void spawnBlocks(ServerLevel level, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 4; ++y) {
                    level.setBlockAndUpdate(pos.offset(x, y, z), ((Block)BMDBlocks.SEALED_BLACKSTONE.get()).defaultBlockState());
                }
            }
        }
        BlockPos up = pos.above();
        BlockState seal = ((Block)BMDBlocks.GAUNTLET_BLACKSTONE.get()).defaultBlockState();
        level.setBlockAndUpdate(up, seal);
        level.setBlockAndUpdate(up.east(), seal);
        level.setBlockAndUpdate(up.north(), seal);
        level.setBlockAndUpdate(up.west(), seal);
        level.setBlockAndUpdate(up.south(), seal);
    }

    private BlockPos runeCenter(StructureStart structureStart) {
        return structureStart.getBoundingBox().getCenter().below(10);
    }
}

