/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.block.custom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlockEntities;
import com.cerbon.bosses_of_mass_destruction.packet.custom.SendParticleS2CPacket;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.structure.BMDStructures;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.network.Dispatcher;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class VoidLilyBlockEntity
extends BlockEntity {
    private Vec3 structureDirection = null;

    public VoidLilyBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BMDBlockEntities.VOID_LILY_BLOCK_ENTITY.get(), pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("dirX")) {
            this.structureDirection = new Vec3(tag.getDouble("dirX"), tag.getDouble("dirY"), tag.getDouble("dirZ"));
        }
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        Vec3 dir = this.structureDirection;
        if (dir != null) {
            tag.putDouble("dirX", dir.x);
            tag.putDouble("dirY", dir.y);
            tag.putDouble("dirZ", dir.z);
        }
        super.saveAdditional(tag, registries);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, VoidLilyBlockEntity entity) {
        if (RandomUtils.range((int)0, (int)30) == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 direction = entity.structureDirection;
            if (direction == null) {
                VoidLilyBlockEntity.setNearestStructureDirection(serverLevel, pos, entity);
            }
            if (direction != null) {
                Dispatcher.sendToClientsLoadingPos((Object)new SendParticleS2CPacket(pos, direction), (ServerLevel)serverLevel, (Vec3)VecUtils.asVec3((BlockPos)pos));
            }
        }
    }

    private static void setNearestStructureDirection(ServerLevel level, BlockPos pos, VoidLilyBlockEntity entity) {
        BlockPos blockPos = level.findNearestMapStructure(BMDStructures.VOID_LILY_STRUCTURE_KEY, pos, 50, false);
        entity.structureDirection = blockPos != null ? VecUtils.asVec3((BlockPos)new BlockPos(blockPos.getX(), level.getMinBuildHeight(), blockPos.getZ()).subtract((Vec3i)pos)).normalize() : VecUtils.yAxis;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnVoidLilyParticles(ClientLevel level, Vec3 pos, Vec3 dir) {
        Vec3 streakPos = pos.add(new Vec3(0.5, 0.7, 0.5)).add(RandomUtils.randVec().scale(0.5));
        Vec3 right = dir.cross(VecUtils.yAxis).normalize();
        double sinCurve = RandomUtils.range((double)8.0, (double)11.0) * (double)RandomUtils.randSign();
        double curveLength = RandomUtils.range((double)1.2, (double)1.6);
        int particleAmount = RandomUtils.range((int)7, (int)10);
        CapabilityUtils.getLevelEventScheduler((Level)level).addEvent((IEvent)new TimedEvent(() -> {
            Vec3 particlePos = streakPos.add(RandomUtils.randVec().scale(0.05));
            Particles.pollenParticles.continuousPosition(p -> {
                float age = p.ageRatio;
                Vec3 forward = dir.scale((double)age * curveLength);
                Vec3 sinSide = right.scale(Math.sin((double)age * sinCurve) * 0.1);
                return particlePos.add(forward).add(sinSide);
            }).build(particlePos, Vec3.ZERO);
        }, 0, particleAmount, () -> false));
    }

    private static class Particles {
        @OnlyIn(value=Dist.CLIENT)
        private static final ClientParticleBuilder pollenParticles = new ClientParticleBuilder((ParticleOptions)BMDParticles.POLLEN.get()).scale(age -> Float.valueOf((float)(Math.sin(age.floatValue() * (float)Math.PI) * (double)0.04f))).age(30);

        private Particles() {
        }
    }
}

