/*
 * Decompiled with CFR 0.152.
 */
package net.werdei.biome_replacer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.werdei.biome_replacer.config.Config;
import net.werdei.biome_replacer.replacer.VanillaReplacer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeReplacer {
    private static final Logger LOGGER = LogManager.getLogger(BiomeReplacer.class);
    private static final String LOG_PREFIX = "[BiomeReplacer] ";
    private static List<Warning> unshownWarnings = new ArrayList<Warning>();

    public static void initialize() {
        Config.getOrCreateFile();
    }

    public static void doReplacement(Registry<Biome> biomeRegistry, Registry<LevelStem> stemRegistry) {
        Config.reload();
        VanillaReplacer.doReplacement(biomeRegistry, stemRegistry);
    }

    public static void debug(String message) {
        LOGGER.debug("[BiomeReplacer] {}", (Object)message);
    }

    public static void log(String message) {
        LOGGER.info("[BiomeReplacer] {}", (Object)message);
    }

    public static void logWarn(String message) {
        LOGGER.warn("[BiomeReplacer] {}", (Object)message);
    }

    public static void logRuleWarning(int line, String message) {
        LOGGER.warn("{}Config issue on line {}: {}", (Object)LOG_PREFIX, (Object)line, (Object)message);
    }

    public static List<Warning> getWarningsAndClear() {
        List<Warning> out = unshownWarnings;
        unshownWarnings = new ArrayList<Warning>();
        return out;
    }

    public record Warning(int line, String message) {
    }
}

