/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.block.PricklyPeachCactusBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.util.DistributionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PricklyPeachCactusPatchFeature
extends Feature<NoneFeatureConfiguration> {
    public static final int MAX_PLACEMENT_ATTEMPTS = 13;
    public static final float PLACEMENT_SKIP_CHANCE = 0.25f;
    public static final int MAX_TOTAL_PLACEMENTS = 4;
    public static final int PLACEMENT_RADIUS_XZ = 7;
    public static final int PLACEMENT_RADIUS_Y = 5;
    public static final float FRUIT_CHANCE = 0.4f;

    public PricklyPeachCactusPatchFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        int cactiRemaining = 4;
        for (int i = 0; i < 13; ++i) {
            BlockPos pos;
            if (cactiRemaining <= 0) {
                return true;
            }
            if (random.nextFloat() < 0.25f || !level.getBlockState((pos = DistributionUtils.ellipsoidCenterBiasedSpread(7.0f, 5.0f, random, (x, y, z) -> origin.offset(Math.round(x), Math.round(y), Math.round(z)))).below()).is((Block)BlockModule.ANCIENT_SAND.get())) continue;
            boolean isAdjacentCactus = false;
            int solidNeighbors = 0;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState neighborState = level.getBlockState(pos.relative(direction));
                Block neighborBlock = neighborState.getBlock();
                if (neighborBlock == BlockModule.PRICKLY_PEACH_CACTUS.get() || neighborBlock == Blocks.CACTUS) {
                    isAdjacentCactus = true;
                    break;
                }
                if (!neighborState.isAir()) {
                    ++solidNeighbors;
                }
                if (solidNeighbors <= 2) continue;
                break;
            }
            if (isAdjacentCactus || solidNeighbors >= 3) continue;
            BlockState cactusBlockState = (BlockState)((Block)BlockModule.PRICKLY_PEACH_CACTUS.get()).defaultBlockState().setValue((Property)PricklyPeachCactusBlock.FRUIT, (Comparable)Boolean.valueOf(random.nextFloat() < 0.4f));
            level.setBlock(pos, cactusBlockState, 3);
            --cactiRemaining;
        }
        return cactiRemaining < 4;
    }
}

