/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.IceSheetConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class IceSheetFeature
extends Feature<IceSheetConfiguration> {
    public IceSheetFeature(Codec<IceSheetConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<IceSheetConfiguration> featurePlaceContext) {
        WorldGenLevel worldGenLevel = featurePlaceContext.level();
        BlockPos originPos = featurePlaceContext.origin();
        IceSheetConfiguration config = (IceSheetConfiguration)featurePlaceContext.config();
        int radius = config.searchRange;
        BlockPos.MutableBlockPos blockPos = originPos.mutable();
        BlockPos.MutableBlockPos neighborPos = blockPos.mutable();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dx = (double)x / (double)radius;
                    double dy = (double)y / (double)radius;
                    double dz = (double)z / (double)radius;
                    if (dx * dx + dy * dy + dz * dz > 1.0) continue;
                    blockPos.setWithOffset((Vec3i)originPos, x, y, z);
                    BlockState blockState = worldGenLevel.getBlockState((BlockPos)blockPos);
                    if (!IceSheetFeature.isAirOrWater(blockState)) continue;
                    for (Direction direction : config.validDirections) {
                        IceSheetBlock iceSheetBlock;
                        BlockState updatedBlockState;
                        neighborPos.setWithOffset((Vec3i)blockPos, direction);
                        BlockState neighborBlockState = worldGenLevel.getBlockState((BlockPos)neighborPos);
                        if (neighborBlockState.is(BlockModule.ICE_SHEET_FEATURE_AVOID) || (updatedBlockState = (iceSheetBlock = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get())).getStateForPlacement(blockState, (BlockGetter)worldGenLevel, (BlockPos)blockPos, direction)) == null) continue;
                        blockState = updatedBlockState;
                    }
                    if (!blockState.is((Block)BlockModule.ICE_SHEET.get())) continue;
                    blockState = (BlockState)blockState.setValue((Property)IceSheetBlock.GROWTH_DISTANCE, (Comparable)Integer.valueOf(3));
                    worldGenLevel.setBlock((BlockPos)blockPos, blockState, 3);
                    worldGenLevel.getChunk((BlockPos)blockPos).markPosForPostprocessing((BlockPos)blockPos);
                }
            }
        }
        return true;
    }

    private static boolean isAirOrWater(BlockState blockState) {
        return blockState.isAir() || blockState.is(Blocks.WATER);
    }
}

