/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.services;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterItem;
import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.DecoratedPotPatternsModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.DecoratedPotPatternsModuleNeoForge;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.network.payload.IcicleShatterS2CPayload;
import com.yungnickyoung.minecraft.yungscavebiomes.network.payload.SandstormSyncS2CPayload;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import com.yungnickyoung.minecraft.yungscavebiomes.services.IPlatformHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.DecoratedPotPattern;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void sendIcicleProjectileShatterS2CPacket(ServerLevel serverLevel, Vec3 pos) {
        ChunkAccess chunkAccess;
        if (serverLevel.isLoaded(BlockPos.containing((Position)pos)) && (chunkAccess = serverLevel.getChunk(BlockPos.containing((Position)pos))) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            IcicleShatterS2CPayload payload = new IcicleShatterS2CPayload(pos.x(), pos.y(), pos.z());
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)levelChunk.getPos(), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void syncSandstormDataToClients(SandstormServerData sandstormServerData) {
        SandstormSyncS2CPayload payload = new SandstormSyncS2CPayload(sandstormServerData.isSandstormActive(), sandstormServerData.getCurrSandstormTicks(), sandstormServerData.getSeed(), sandstormServerData.getTotalSandstormDurationTicks());
        PacketDistributor.sendToPlayersInDimension((ServerLevel)sandstormServerData.getServerLevel(), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void syncSandstormDataToPlayer(SandstormServerData sandstormServerData, ServerPlayer serverPlayer) {
        SandstormSyncS2CPayload payload = new SandstormSyncS2CPayload(sandstormServerData.isSandstormActive(), sandstormServerData.getCurrSandstormTicks(), sandstormServerData.getSeed(), sandstormServerData.getTotalSandstormDurationTicks());
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Supplier<Item> getIceCubeSpawnEggItem() {
        return () -> new DeferredSpawnEggItem(() -> (EntityType)EntityTypeModule.ICE_CUBE.get(), 10798332, 15002876, new Item.Properties());
    }

    @Override
    public Supplier<Item> getSandSnapperSpawnEggItem() {
        return () -> new DeferredSpawnEggItem(() -> (EntityType)EntityTypeModule.SAND_SNAPPER.get(), 12223791, 13610069, new Item.Properties());
    }

    @Override
    public Block getPottedPricklyPeachCactusBlock() {
        FlowerPotBlock flowerPotBlock = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, () -> (Block)BlockModule.PRICKLY_PEACH_CACTUS.get(), BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY));
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(YungsCaveBiomesCommon.id("prickly_peach_cactus"), () -> flowerPotBlock);
        return flowerPotBlock;
    }

    @Override
    public ResourceKey<DecoratedPotPattern> registerDecoratedPotPattern(String name, AutoRegisterItem potterySherdItem) {
        ResourceLocation resourceLocation = YungsCaveBiomesCommon.id(name);
        DecoratedPotPatternsModuleNeoForge.queueForRegistration(resourceLocation);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DECORATED_POT_PATTERN, (ResourceLocation)resourceLocation);
        DecoratedPotPatternsModule.ALL_PATTERNS.add((ResourceKey<DecoratedPotPattern>)resourceKey);
        DecoratedPotPatternsModule.RESOUCE_KEY_BY_ITEM.put((Item)potterySherdItem.get(), (ResourceKey<DecoratedPotPattern>)resourceKey);
        return resourceKey;
    }
}

