/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.mixin.frosted_caves;

import com.yungnickyoung.minecraft.yungscavebiomes.block.IcicleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractCauldronBlock.class})
public abstract class AbstractCauldronBlockMixin
extends Block {
    public AbstractCauldronBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Shadow
    protected abstract boolean canReceiveStalactiteDrip(Fluid var1);

    @Shadow
    protected abstract void receiveStalactiteDrip(BlockState var1, Level var2, BlockPos var3, Fluid var4);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void yungscavebiomes_checkForIcicleDrip(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random, CallbackInfo ci) {
        BlockPos iciclePos = IcicleBlock.findIcicleTipAboveCauldron((Level)serverLevel, blockPos);
        if (iciclePos == null) {
            return;
        }
        Fluid fluid = IcicleBlock.getCauldronFillFluidType((Level)serverLevel, iciclePos);
        if (fluid != Fluids.EMPTY && this.canReceiveStalactiteDrip(fluid)) {
            this.receiveStalactiteDrip(blockState, (Level)serverLevel, blockPos, fluid);
        }
    }
}

